/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.util;

import org.apache.shiro.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class StringUtilsTest {
    @Test
    public void splitWithNullInput() {
        String line = null;
        String[] split = StringUtils.split(line);
        Assert.assertNull((Object)split);
    }

    @Test
    public void splitWithCommas() {
        String line = "shall,we,play,a,game?";
        String[] split = StringUtils.split((String)line);
        Assert.assertNotNull((Object)split);
        Assert.assertTrue((split.length == 5 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"shall", (Object)split[0]);
        Assert.assertEquals((Object)"we", (Object)split[1]);
        Assert.assertEquals((Object)"play", (Object)split[2]);
        Assert.assertEquals((Object)"a", (Object)split[3]);
        Assert.assertEquals((Object)"game?", (Object)split[4]);
    }

    @Test
    public void splitWithCommasAndSpaces() {
        String line = "shall,we ,    play, a,game?";
        String[] split = StringUtils.split((String)line);
        Assert.assertNotNull((Object)split);
        Assert.assertTrue((split.length == 5 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"shall", (Object)split[0]);
        Assert.assertEquals((Object)"we", (Object)split[1]);
        Assert.assertEquals((Object)"play", (Object)split[2]);
        Assert.assertEquals((Object)"a", (Object)split[3]);
        Assert.assertEquals((Object)"game?", (Object)split[4]);
    }

    @Test
    public void splitWithQuotedCommasAndSpaces() {
        String line = "shall, \"we, play\", a, game?";
        String[] split = StringUtils.split((String)line);
        Assert.assertNotNull((Object)split);
        Assert.assertTrue((split.length == 4 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"shall", (Object)split[0]);
        Assert.assertEquals((Object)"we, play", (Object)split[1]);
        Assert.assertEquals((Object)"a", (Object)split[2]);
        Assert.assertEquals((Object)"game?", (Object)split[3]);
    }

    @Test
    public void splitWithQuotedCommasAndSpacesAndDifferentQuoteChars() {
        String line = "authc, test[blah], test[1,2,3], test[]";
        String[] split = StringUtils.split((String)line, (char)',', (char)'[', (char)']', (boolean)false, (boolean)true);
        Assert.assertNotNull((Object)split);
        Assert.assertTrue((split.length == 4 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"authc", (Object)split[0]);
        Assert.assertEquals((Object)"testblah", (Object)split[1]);
        Assert.assertEquals((Object)"test1,2,3", (Object)split[2]);
        Assert.assertEquals((Object)"test", (Object)split[3]);
    }

    @Test
    public void splitWithQuotedCommasAndSpacesAndDifferentQuoteCharsWhileRetainingQuotes() {
        String line = "authc, test[blah], test[1,2,3], test[]";
        String[] split = StringUtils.split((String)line, (char)',', (char)'[', (char)']', (boolean)true, (boolean)true);
        Assert.assertNotNull((Object)split);
        Assert.assertTrue((split.length == 4 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"authc", (Object)split[0]);
        Assert.assertEquals((Object)"test[blah]", (Object)split[1]);
        Assert.assertEquals((Object)"test[1,2,3]", (Object)split[2]);
        Assert.assertEquals((Object)"test[]", (Object)split[3]);
    }

    @Test
    public void splitTestWithQuotedCommas() {
        String line = "authc, test[blah], test[\"1,2,3\"], test[]";
        String[] split = StringUtils.split((String)line);
        Assert.assertNotNull((Object)split);
        Assert.assertTrue((split.length == 4 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"authc", (Object)split[0]);
        Assert.assertEquals((Object)"test[blah]", (Object)split[1]);
        Assert.assertEquals((Object)"test[1,2,3]", (Object)split[2]);
        Assert.assertEquals((Object)"test[]", (Object)split[3]);
    }

    @Test
    public void splitWithQuotedCommasAndSpacesAndEscapedQuotes() {
        String line = "shall, \"\"\"we, play\", a, \"\"\"game?";
        String[] split = StringUtils.split((String)line);
        Assert.assertNotNull((Object)split);
        Assert.assertTrue((split.length == 4 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"shall", (Object)split[0]);
        Assert.assertEquals((Object)"\"we, play", (Object)split[1]);
        Assert.assertEquals((Object)"a", (Object)split[2]);
        Assert.assertEquals((Object)"\"game?", (Object)split[3]);
    }
}

