/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.test;

import org.apache.shiro.SecurityUtils;
import org.apache.shiro.UnavailableSecurityManagerException;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.support.SubjectThreadState;
import org.apache.shiro.util.LifecycleUtils;
import org.apache.shiro.util.ThreadState;
import org.junit.AfterClass;

public abstract class AbstractShiroTest {
    private static ThreadState subjectThreadState;

    protected void setSubject(Subject subject) {
        this.clearSubject();
        subjectThreadState = this.createThreadState(subject);
        subjectThreadState.bind();
    }

    protected Subject getSubject() {
        return SecurityUtils.getSubject();
    }

    protected ThreadState createThreadState(Subject subject) {
        return new SubjectThreadState(subject);
    }

    protected void clearSubject() {
        AbstractShiroTest.doClearSubject();
    }

    private static void doClearSubject() {
        if (subjectThreadState != null) {
            subjectThreadState.clear();
            subjectThreadState = null;
        }
    }

    protected static void setSecurityManager(SecurityManager securityManager) {
        SecurityUtils.setSecurityManager((SecurityManager)securityManager);
    }

    protected static SecurityManager getSecurityManager() {
        return SecurityUtils.getSecurityManager();
    }

    @AfterClass
    public static void tearDownShiro() {
        AbstractShiroTest.doClearSubject();
        try {
            SecurityManager securityManager = AbstractShiroTest.getSecurityManager();
            LifecycleUtils.destroy((Object)securityManager);
        }
        catch (UnavailableSecurityManagerException unavailableSecurityManagerException) {
            // empty catch block
        }
        AbstractShiroTest.setSecurityManager(null);
    }
}

