/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.realm.text;

import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.config.Ini;
import org.apache.shiro.realm.text.IniRealm;
import org.junit.Assert;
import org.junit.Test;

public class IniRealmTest {
    @Test
    public void testNullIni() {
        IniRealm realm = new IniRealm((Ini)null);
    }

    @Test
    public void testEmptyIni() {
        new IniRealm(new Ini());
    }

    @Test(expected=IllegalStateException.class)
    public void testInitWithoutIniResource() {
        new IniRealm().init();
    }

    @Test
    public void testIniFile() {
        IniRealm realm = new IniRealm();
        realm.setResourcePath("classpath:org/apache/shiro/realm/text/IniRealmTest.simple.ini");
        realm.init();
        Assert.assertTrue((boolean)realm.roleExists("admin"));
        UsernamePasswordToken token = new UsernamePasswordToken("user1", "user1");
        AuthenticationInfo info = realm.getAuthenticationInfo((AuthenticationToken)token);
        Assert.assertNotNull((Object)info);
        Assert.assertTrue((boolean)realm.hasRole(info.getPrincipals(), "admin"));
    }

    @Test
    public void testIniFileWithoutUsers() {
        IniRealm realm = new IniRealm();
        realm.setResourcePath("classpath:org/apache/shiro/realm/text/IniRealmTest.noUsers.ini");
        realm.init();
        Assert.assertTrue((boolean)realm.roleExists("admin"));
    }
}

