/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.jndi;

import javax.naming.NamingException;
import org.apache.shiro.jndi.JndiObjectFactory;
import org.junit.Assert;
import org.junit.Test;

public class JndiObjectFactoryTest {
    @Test
    public void testGetInstanceWithType() throws Exception {
        String name = "my/jndi/resource";
        String returnValue = "jndiString";
        JndiObjectFactory<String> underTest = new JndiObjectFactory<String>(){

            protected Object lookup(String jndiName, Class requiredType) throws NamingException {
                Assert.assertEquals((Object)"my/jndi/resource", (Object)jndiName);
                Assert.assertEquals(String.class, (Object)requiredType);
                return new String("jndiString");
            }
        };
        underTest.setRequiredType(String.class);
        underTest.setResourceName("my/jndi/resource");
        Assert.assertEquals((Object)"jndiString", (Object)underTest.getInstance());
    }

    @Test
    public void testGetInstanceNoType() throws Exception {
        String name = "my/jndi/resource";
        String returnValue = "jndiString";
        JndiObjectFactory<String> underTest = new JndiObjectFactory<String>(){

            protected Object lookup(String jndiName) throws NamingException {
                Assert.assertEquals((Object)"my/jndi/resource", (Object)jndiName);
                return new String("jndiString");
            }
        };
        underTest.setResourceName("my/jndi/resource");
        Assert.assertEquals((Object)"jndiString", (Object)underTest.getInstance());
    }

    @Test(expected=IllegalStateException.class)
    public void testJndiLookupFailsWithType() throws Exception {
        String name = "my/jndi/resource";
        JndiObjectFactory<String> underTest = new JndiObjectFactory<String>(){

            protected Object lookup(String jndiName, Class requiredType) throws NamingException {
                throw new NamingException("No resource named " + jndiName);
            }
        };
        underTest.setResourceName("my/jndi/resource");
        underTest.setRequiredType(String.class);
        underTest.getInstance();
    }

    @Test(expected=IllegalStateException.class)
    public void testJndiLookupFailsNoType() throws Exception {
        String name = "my/jndi/resource";
        JndiObjectFactory<String> underTest = new JndiObjectFactory<String>(){

            protected Object lookup(String jndiName) throws NamingException {
                throw new NamingException("No resource named " + jndiName);
            }
        };
        underTest.setResourceName("my/jndi/resource");
        underTest.getInstance();
    }
}

