/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.crypto.hash;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.util.GroovyTestCase;
import java.lang.ref.SoftReference;
import junit.framework.TestResult;
import org.apache.shiro.crypto.hash.DefaultHashService;
import org.apache.shiro.crypto.hash.Hash;
import org.apache.shiro.crypto.hash.HashService;
import org.apache.shiro.util.ByteSource;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

public class DefaultHashServiceTest
extends GroovyTestCase
implements GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    public static /* synthetic */ long __timeStamp = 1327037608095L;
    public static /* synthetic */ long __timeStamp__239_neverHappen1327037608095 = 0L;
    private static /* synthetic */ SoftReference $callSiteArray;
    private static /* synthetic */ Class $class$org$apache$shiro$crypto$hash$HashService;
    private static /* synthetic */ Class $class$org$apache$shiro$crypto$hash$HashRequest$Builder;
    private static /* synthetic */ Class $class$org$apache$shiro$crypto$hash$Hash;
    private static /* synthetic */ Class $class$org$apache$shiro$util$ByteSource;
    private static /* synthetic */ Class $class$org$apache$shiro$crypto$SecureRandomNumberGenerator;
    private static /* synthetic */ Class array$$class$byte;
    private static /* synthetic */ Class $class$java$lang$String;
    private static /* synthetic */ Class $class$org$apache$shiro$crypto$RandomNumberGenerator;
    private static /* synthetic */ Class $class$org$apache$shiro$util$ByteSource$Util;
    private static /* synthetic */ Class $class$java$util$Arrays;
    private static /* synthetic */ Class $class$org$apache$shiro$crypto$hash$DefaultHashServiceTest;
    private static /* synthetic */ Class $class$org$easymock$EasyMock;
    private static /* synthetic */ Class $class$org$apache$shiro$crypto$hash$DefaultHashService;

    public DefaultHashServiceTest() {
        MetaClass metaClass;
        CallSite[] callSiteArray = DefaultHashServiceTest.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public void testNullRequest() {
        CallSite[] callSiteArray = DefaultHashServiceTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[0].callStatic(DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$DefaultHashServiceTest(), callSiteArray[1].call(callSiteArray[2].callCurrent((GroovyObject)this), null));
        } else {
            callSiteArray[3].callStatic(DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$DefaultHashServiceTest(), callSiteArray[4].call((Object)this.createService(), null));
        }
    }

    public void testDifferentAlgorithmName() {
        CallSite[] callSiteArray = DefaultHashServiceTest.$getCallSiteArray();
        Object service = callSiteArray[5].callConstructor((Object)DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$DefaultHashService(), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"hashAlgorithmName", "MD5"}));
        Object hash = callSiteArray[6].callCurrent((GroovyObject)this, service, (Object)"test");
        callSiteArray[7].callStatic(DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$DefaultHashServiceTest(), (Object)"MD5", callSiteArray[8].callGetProperty(hash));
    }

    public void testDifferentIterations() {
        CallSite[] callSiteArray = DefaultHashServiceTest.$getCallSiteArray();
        Object service = callSiteArray[9].callConstructor((Object)DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$DefaultHashService(), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"hashIterations", (Integer)DefaultTypeTransformation.box((int)2)}));
        Object hash = callSiteArray[10].callCurrent((GroovyObject)this, service, (Object)"test");
        callSiteArray[11].callStatic(DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$DefaultHashServiceTest(), (Object)((Integer)DefaultTypeTransformation.box((int)2)), callSiteArray[12].callGetProperty(hash));
    }

    public void testDifferentRandomNumberGenerator() {
        CallSite[] callSiteArray = DefaultHashServiceTest.$getCallSiteArray();
        ByteSource randomBytes = (ByteSource)ScriptBytecodeAdapter.castToType((Object)callSiteArray[13].call(callSiteArray[14].callConstructor((Object)DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$SecureRandomNumberGenerator())), (Class)DefaultHashServiceTest.$get$$class$org$apache$shiro$util$ByteSource());
        Object rng = callSiteArray[15].callStatic(DefaultHashServiceTest.$get$$class$org$easymock$EasyMock(), (Object)DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$RandomNumberGenerator());
        callSiteArray[16].call(callSiteArray[17].callStatic(DefaultHashServiceTest.$get$$class$org$easymock$EasyMock(), callSiteArray[18].call(rng)), (Object)randomBytes);
        callSiteArray[19].callStatic(DefaultHashServiceTest.$get$$class$org$easymock$EasyMock(), rng);
        Object service = callSiteArray[20].callConstructor((Object)DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$DefaultHashService(), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"randomNumberGenerator", rng, "generatePublicSalt", (Boolean)DefaultTypeTransformation.box((boolean)true)}));
        callSiteArray[21].callCurrent((GroovyObject)this, service, (Object)"test");
        callSiteArray[22].callStatic(DefaultHashServiceTest.$get$$class$org$easymock$EasyMock(), rng);
    }

    public void testWithRandomlyGeneratedSalt() {
        CallSite[] callSiteArray = DefaultHashServiceTest.$getCallSiteArray();
        Object service = callSiteArray[23].callConstructor((Object)DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$DefaultHashService(), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"generatePublicSalt", (Boolean)DefaultTypeTransformation.box((boolean)true)}));
        Object first = callSiteArray[24].callCurrent((GroovyObject)this, service, (Object)"password");
        Object second = callSiteArray[25].callCurrent((GroovyObject)this, service, (Object)"password");
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[26].callStatic(DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$DefaultHashServiceTest(), (Object)((Boolean)DefaultTypeTransformation.box((boolean)ScriptBytecodeAdapter.compareEqual((Object)first, (Object)second))));
        } else {
            callSiteArray[27].callStatic(DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$DefaultHashServiceTest(), (Object)((Boolean)DefaultTypeTransformation.box((boolean)ScriptBytecodeAdapter.compareEqual((Object)first, (Object)second))));
        }
    }

    public void testRequestWithEmptySource() {
        CallSite[] callSiteArray = DefaultHashServiceTest.$getCallSiteArray();
        Object source = callSiteArray[28].call((Object)DefaultHashServiceTest.$get$$class$org$apache$shiro$util$ByteSource$Util(), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((byte[])ScriptBytecodeAdapter.castToType(null, (Class)DefaultHashServiceTest.$get$array$$class$byte())), (Class)DefaultHashServiceTest.$get$array$$class$byte()));
        Object request = callSiteArray[29].call(callSiteArray[30].call(callSiteArray[31].callConstructor((Object)DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$HashRequest$Builder()), source));
        Object service = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[32].callCurrent((GroovyObject)this);
            service = object;
        } else {
            DefaultHashService defaultHashService;
            service = defaultHashService = this.createService();
        }
        callSiteArray[33].callStatic(DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$DefaultHashServiceTest(), callSiteArray[34].call(service, request));
    }

    public void testOnlyRandomSaltHash() {
        CallSite[] callSiteArray = DefaultHashServiceTest.$getCallSiteArray();
        HashService service = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[35].callCurrent((GroovyObject)this);
            service = (HashService)ScriptBytecodeAdapter.castToType((Object)object, (Class)DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$HashService());
        } else {
            DefaultHashService defaultHashService = this.createService();
            service = (HashService)defaultHashService;
        }
        Hash first = (Hash)ScriptBytecodeAdapter.castToType((Object)callSiteArray[36].callCurrent((GroovyObject)this, (Object)service, (Object)"password"), (Class)DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$Hash());
        Hash second = (Hash)ScriptBytecodeAdapter.castToType((Object)callSiteArray[37].callCurrent((GroovyObject)this, (Object)service, (Object)"password2", callSiteArray[38].callGetProperty((Object)first)), (Class)DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$Hash());
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[39].callStatic(DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$DefaultHashServiceTest(), (Object)((Boolean)DefaultTypeTransformation.box((boolean)ScriptBytecodeAdapter.compareEqual((Object)first, (Object)second))));
        } else {
            callSiteArray[40].callStatic(DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$DefaultHashServiceTest(), (Object)((Boolean)DefaultTypeTransformation.box((boolean)ScriptBytecodeAdapter.compareEqual((Object)first, (Object)second))));
        }
    }

    public void testBothSaltsRandomness() {
        CallSite[] callSiteArray = DefaultHashServiceTest.$getCallSiteArray();
        HashService service = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[41].callCurrent((GroovyObject)this);
            service = (HashService)ScriptBytecodeAdapter.castToType((Object)object, (Class)DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$HashService());
        } else {
            DefaultHashService defaultHashService = this.createServiceWithPrivateSalt();
            service = (HashService)defaultHashService;
        }
        Hash first = (Hash)ScriptBytecodeAdapter.castToType((Object)callSiteArray[42].callCurrent((GroovyObject)this, (Object)service, (Object)"password"), (Class)DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$Hash());
        Hash second = (Hash)ScriptBytecodeAdapter.castToType((Object)callSiteArray[43].callCurrent((GroovyObject)this, (Object)service, (Object)"password"), (Class)DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$Hash());
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[44].callStatic(DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$DefaultHashServiceTest(), (Object)((Boolean)DefaultTypeTransformation.box((boolean)ScriptBytecodeAdapter.compareEqual((Object)first, (Object)second))));
        } else {
            callSiteArray[45].callStatic(DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$DefaultHashServiceTest(), (Object)((Boolean)DefaultTypeTransformation.box((boolean)ScriptBytecodeAdapter.compareEqual((Object)first, (Object)second))));
        }
    }

    public void testBothSaltsReturn() {
        CallSite[] callSiteArray = DefaultHashServiceTest.$getCallSiteArray();
        HashService service = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[46].callCurrent((GroovyObject)this);
            service = (HashService)ScriptBytecodeAdapter.castToType((Object)object, (Class)DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$HashService());
        } else {
            DefaultHashService defaultHashService = this.createServiceWithPrivateSalt();
            service = (HashService)defaultHashService;
        }
        Hash first = (Hash)ScriptBytecodeAdapter.castToType((Object)callSiteArray[47].callCurrent((GroovyObject)this, (Object)service, (Object)"password"), (Class)DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$Hash());
        Hash second = (Hash)ScriptBytecodeAdapter.castToType((Object)callSiteArray[48].callCurrent((GroovyObject)this, (Object)service, (Object)"password", callSiteArray[49].callGetProperty((Object)first)), (Class)DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$Hash());
        callSiteArray[50].callStatic(DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$DefaultHashServiceTest(), (Object)first, (Object)second);
    }

    public void testBothSaltsHash() {
        CallSite[] callSiteArray = DefaultHashServiceTest.$getCallSiteArray();
        HashService service = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[51].callCurrent((GroovyObject)this);
            service = (HashService)ScriptBytecodeAdapter.castToType((Object)object, (Class)DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$HashService());
        } else {
            DefaultHashService defaultHashService = this.createServiceWithPrivateSalt();
            service = (HashService)defaultHashService;
        }
        Hash first = (Hash)ScriptBytecodeAdapter.castToType((Object)callSiteArray[52].callCurrent((GroovyObject)this, (Object)service, (Object)"password"), (Class)DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$Hash());
        Hash second = (Hash)ScriptBytecodeAdapter.castToType((Object)callSiteArray[53].callCurrent((GroovyObject)this, (Object)service, (Object)"password2", callSiteArray[54].callGetProperty((Object)first)), (Class)DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$Hash());
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[55].callStatic(DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$DefaultHashServiceTest(), (Object)((Boolean)DefaultTypeTransformation.box((boolean)ScriptBytecodeAdapter.compareEqual((Object)first, (Object)second))));
        } else {
            callSiteArray[56].callStatic(DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$DefaultHashServiceTest(), (Object)((Boolean)DefaultTypeTransformation.box((boolean)ScriptBytecodeAdapter.compareEqual((Object)first, (Object)second))));
        }
    }

    public void testPrivateSaltChangesResult() {
        CallSite[] callSiteArray = DefaultHashServiceTest.$getCallSiteArray();
        HashService saltedService = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[57].callCurrent((GroovyObject)this);
            saltedService = (HashService)ScriptBytecodeAdapter.castToType((Object)object, (Class)DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$HashService());
        } else {
            DefaultHashService defaultHashService = this.createServiceWithPrivateSalt();
            saltedService = (HashService)defaultHashService;
        }
        HashService service = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[58].callCurrent((GroovyObject)this);
            service = (HashService)ScriptBytecodeAdapter.castToType((Object)object, (Class)DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$HashService());
        } else {
            DefaultHashService defaultHashService = this.createService();
            service = (HashService)defaultHashService;
        }
        Hash first = (Hash)ScriptBytecodeAdapter.castToType((Object)callSiteArray[59].callCurrent((GroovyObject)this, (Object)saltedService, (Object)"password"), (Class)DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$Hash());
        Hash second = (Hash)ScriptBytecodeAdapter.castToType((Object)callSiteArray[60].callCurrent((GroovyObject)this, (Object)service, (Object)"password"), (Class)DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$Hash());
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[61].callStatic(DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$DefaultHashServiceTest(), (Object)((Boolean)DefaultTypeTransformation.box((boolean)ScriptBytecodeAdapter.compareEqual((Object)first, (Object)second))));
        } else {
            callSiteArray[62].callStatic(DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$DefaultHashServiceTest(), (Object)((Boolean)DefaultTypeTransformation.box((boolean)ScriptBytecodeAdapter.compareEqual((Object)first, (Object)second))));
        }
    }

    protected Hash hash(HashService hashService, Object source) {
        CallSite[] callSiteArray = DefaultHashServiceTest.$getCallSiteArray();
        return (Hash)ScriptBytecodeAdapter.castToType((Object)callSiteArray[63].call((Object)hashService, callSiteArray[64].call(callSiteArray[65].call(callSiteArray[66].callConstructor((Object)DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$HashRequest$Builder()), source))), (Class)DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$Hash());
    }

    protected Hash hash(HashService hashService, Object source, Object salt) {
        CallSite[] callSiteArray = DefaultHashServiceTest.$getCallSiteArray();
        return (Hash)ScriptBytecodeAdapter.castToType((Object)callSiteArray[67].call((Object)hashService, callSiteArray[68].call(callSiteArray[69].call(callSiteArray[70].call(callSiteArray[71].callConstructor((Object)DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$HashRequest$Builder()), source), salt))), (Class)DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$Hash());
    }

    private Hash hashPredictable(HashService hashService, Object source) {
        CallSite[] callSiteArray = DefaultHashServiceTest.$getCallSiteArray();
        byte[] salt = new byte[20];
        callSiteArray[72].call((Object)DefaultHashServiceTest.$get$$class$java$util$Arrays(), (Object)salt, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Byte)DefaultTypeTransformation.box((byte)((byte)2))), Byte.TYPE));
        return (Hash)ScriptBytecodeAdapter.castToType((Object)callSiteArray[73].call((Object)hashService, callSiteArray[74].call(callSiteArray[75].call(callSiteArray[76].call(callSiteArray[77].callConstructor((Object)DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$HashRequest$Builder()), source), (Object)salt))), (Class)DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$Hash());
    }

    private DefaultHashService createService() {
        CallSite[] callSiteArray = DefaultHashServiceTest.$getCallSiteArray();
        return (DefaultHashService)ScriptBytecodeAdapter.castToType((Object)callSiteArray[78].callConstructor((Object)DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$DefaultHashService()), (Class)DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$DefaultHashService());
    }

    private DefaultHashService createServiceWithPrivateSalt() {
        CallSite[] callSiteArray = DefaultHashServiceTest.$getCallSiteArray();
        DefaultHashService defaultHashService = (DefaultHashService)ScriptBytecodeAdapter.castToType((Object)callSiteArray[79].callConstructor((Object)DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$DefaultHashService()), (Class)DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$DefaultHashService());
        callSiteArray[80].call((Object)defaultHashService, callSiteArray[81].call(callSiteArray[82].callConstructor((Object)DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$SecureRandomNumberGenerator())));
        return defaultHashService;
    }

    public /* synthetic */ Object this$dist$invoke$4(String name, Object args) {
        CallSite[] callSiteArray = DefaultHashServiceTest.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN((Class)DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$DefaultHashServiceTest(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)DefaultHashServiceTest.$get$$class$java$lang$String())), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$4(String name, Object value) {
        CallSite[] callSiteArray = DefaultHashServiceTest.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectField((Object)object, (Class)DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$DefaultHashServiceTest(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)DefaultHashServiceTest.$get$$class$java$lang$String())));
    }

    public /* synthetic */ Object this$dist$get$4(String name) {
        CallSite[] callSiteArray = DefaultHashServiceTest.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectField((Class)DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$DefaultHashServiceTest(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)DefaultHashServiceTest.$get$$class$java$lang$String())));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$DefaultHashServiceTest()) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static /* synthetic */ void __$swapInit() {
        CallSite[] callSiteArray = DefaultHashServiceTest.$getCallSiteArray();
        $callSiteArray = null;
    }

    static {
        DefaultHashServiceTest.__$swapInit();
    }

    public /* synthetic */ Hash this$5$hashPredictable(HashService hashService, Object object) {
        return this.hashPredictable(hashService, object);
    }

    public /* synthetic */ DefaultHashService this$5$createService() {
        return this.createService();
    }

    public /* synthetic */ DefaultHashService this$5$createServiceWithPrivateSalt() {
        return this.createServiceWithPrivateSalt();
    }

    public /* synthetic */ String super$3$toString() {
        return super.toString();
    }

    public /* synthetic */ String super$4$shouldFailWithCause(Class clazz, Closure closure) {
        return super.shouldFailWithCause(clazz, closure);
    }

    public /* synthetic */ void super$3$tearDown() {
        super.tearDown();
    }

    public /* synthetic */ void super$4$assertScript(String string) {
        super.assertScript(string);
    }

    public /* synthetic */ String super$4$shouldFail(Class clazz, Closure closure) {
        return super.shouldFail(clazz, closure);
    }

    public /* synthetic */ String super$4$fixEOLs(String string) {
        return super.fixEOLs(string);
    }

    public /* synthetic */ void super$3$runTest() {
        super.runTest();
    }

    public /* synthetic */ void super$4$assertInspect(Object object, String string) {
        super.assertInspect(object, string);
    }

    public /* synthetic */ void super$1$wait() {
        super.wait();
    }

    public /* synthetic */ String super$4$getTestClassName() {
        return super.getTestClassName();
    }

    public /* synthetic */ String super$4$shouldFail(Closure closure) {
        return super.shouldFail(closure);
    }

    public /* synthetic */ Class super$1$getClass() {
        return super.getClass();
    }

    public /* synthetic */ void super$4$assertContains(int n, int[] nArray) {
        super.assertContains(n, nArray);
    }

    public /* synthetic */ void super$3$setName(String string) {
        super.setName(string);
    }

    public /* synthetic */ int super$3$countTestCases() {
        return super.countTestCases();
    }

    public /* synthetic */ TestResult super$3$run() {
        return super.run();
    }

    public /* synthetic */ int super$1$hashCode() {
        return super.hashCode();
    }

    public /* synthetic */ String super$4$getName() {
        return super.getName();
    }

    public /* synthetic */ void super$3$run(TestResult testResult) {
        super.run(testResult);
    }

    public /* synthetic */ void super$1$notify() {
        super.notify();
    }

    public /* synthetic */ void super$1$notifyAll() {
        super.notifyAll();
    }

    public /* synthetic */ void super$4$assertContains(char c, char[] cArray) {
        super.assertContains(c, cArray);
    }

    public /* synthetic */ TestResult super$3$createResult() {
        return super.createResult();
    }

    public /* synthetic */ String super$4$getMethodName() {
        return super.getMethodName();
    }

    public /* synthetic */ void super$3$setUp() {
        super.setUp();
    }

    public /* synthetic */ void super$4$assertLength(int n, Object[] objectArray) {
        super.assertLength(n, objectArray);
    }

    public /* synthetic */ void super$4$assertLength(int n, int[] nArray) {
        super.assertLength(n, nArray);
    }

    public /* synthetic */ boolean super$4$notYetImplemented() {
        return super.notYetImplemented();
    }

    public /* synthetic */ Object super$1$clone() {
        return super.clone();
    }

    public /* synthetic */ void super$4$assertToString(Object object, String string) {
        super.assertToString(object, string);
    }

    public /* synthetic */ void super$1$wait(long l, int n) {
        super.wait(l, n);
    }

    public /* synthetic */ void super$1$finalize() {
        super.finalize();
    }

    public /* synthetic */ void super$4$assertLength(int n, char[] cArray) {
        super.assertLength(n, cArray);
    }

    public /* synthetic */ void super$3$runBare() {
        super.runBare();
    }

    public /* synthetic */ void super$1$wait(long l) {
        super.wait(l);
    }

    public /* synthetic */ void super$4$assertArrayEquals(Object[] objectArray, Object[] objectArray2) {
        super.assertArrayEquals(objectArray, objectArray2);
    }

    public /* synthetic */ boolean super$1$equals(Object object) {
        return super.equals(object);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "assertNull";
        stringArray[1] = "computeHash";
        stringArray[2] = "createService";
        stringArray[3] = "assertNull";
        stringArray[4] = "computeHash";
        stringArray[5] = "<$constructor$>";
        stringArray[6] = "hash";
        stringArray[7] = "assertEquals";
        stringArray[8] = "algorithmName";
        stringArray[9] = "<$constructor$>";
        stringArray[10] = "hash";
        stringArray[11] = "assertEquals";
        stringArray[12] = "iterations";
        stringArray[13] = "nextBytes";
        stringArray[14] = "<$constructor$>";
        stringArray[15] = "createMock";
        stringArray[16] = "andReturn";
        stringArray[17] = "expect";
        stringArray[18] = "nextBytes";
        stringArray[19] = "replay";
        stringArray[20] = "<$constructor$>";
        stringArray[21] = "hash";
        stringArray[22] = "verify";
        stringArray[23] = "<$constructor$>";
        stringArray[24] = "hash";
        stringArray[25] = "hash";
        stringArray[26] = "assertFalse";
        stringArray[27] = "assertFalse";
        stringArray[28] = "bytes";
        stringArray[29] = "build";
        stringArray[30] = "setSource";
        stringArray[31] = "<$constructor$>";
        stringArray[32] = "createService";
        stringArray[33] = "assertNull";
        stringArray[34] = "computeHash";
        stringArray[35] = "createService";
        stringArray[36] = "hash";
        stringArray[37] = "hash";
        stringArray[38] = "salt";
        stringArray[39] = "assertFalse";
        stringArray[40] = "assertFalse";
        stringArray[41] = "createServiceWithPrivateSalt";
        stringArray[42] = "hash";
        stringArray[43] = "hash";
        stringArray[44] = "assertFalse";
        stringArray[45] = "assertFalse";
        stringArray[46] = "createServiceWithPrivateSalt";
        stringArray[47] = "hash";
        stringArray[48] = "hash";
        stringArray[49] = "salt";
        stringArray[50] = "assertEquals";
        stringArray[51] = "createServiceWithPrivateSalt";
        stringArray[52] = "hash";
        stringArray[53] = "hash";
        stringArray[54] = "salt";
        stringArray[55] = "assertFalse";
        stringArray[56] = "assertFalse";
        stringArray[57] = "createServiceWithPrivateSalt";
        stringArray[58] = "createService";
        stringArray[59] = "hashPredictable";
        stringArray[60] = "hashPredictable";
        stringArray[61] = "assertFalse";
        stringArray[62] = "assertFalse";
        stringArray[63] = "computeHash";
        stringArray[64] = "build";
        stringArray[65] = "setSource";
        stringArray[66] = "<$constructor$>";
        stringArray[67] = "computeHash";
        stringArray[68] = "build";
        stringArray[69] = "setSalt";
        stringArray[70] = "setSource";
        stringArray[71] = "<$constructor$>";
        stringArray[72] = "fill";
        stringArray[73] = "computeHash";
        stringArray[74] = "build";
        stringArray[75] = "setSalt";
        stringArray[76] = "setSource";
        stringArray[77] = "<$constructor$>";
        stringArray[78] = "<$constructor$>";
        stringArray[79] = "<$constructor$>";
        stringArray[80] = "setPrivateSalt";
        stringArray[81] = "nextBytes";
        stringArray[82] = "<$constructor$>";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[83];
        DefaultHashServiceTest.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(DefaultHashServiceTest.$get$$class$org$apache$shiro$crypto$hash$DefaultHashServiceTest(), stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = DefaultHashServiceTest.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    private static /* synthetic */ Class $get$$class$org$apache$shiro$crypto$hash$HashService() {
        Class clazz = $class$org$apache$shiro$crypto$hash$HashService;
        if (clazz == null) {
            clazz = $class$org$apache$shiro$crypto$hash$HashService = DefaultHashServiceTest.class$("org.apache.shiro.crypto.hash.HashService");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$org$apache$shiro$crypto$hash$HashRequest$Builder() {
        Class clazz = $class$org$apache$shiro$crypto$hash$HashRequest$Builder;
        if (clazz == null) {
            clazz = $class$org$apache$shiro$crypto$hash$HashRequest$Builder = DefaultHashServiceTest.class$("org.apache.shiro.crypto.hash.HashRequest$Builder");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$org$apache$shiro$crypto$hash$Hash() {
        Class clazz = $class$org$apache$shiro$crypto$hash$Hash;
        if (clazz == null) {
            clazz = $class$org$apache$shiro$crypto$hash$Hash = DefaultHashServiceTest.class$("org.apache.shiro.crypto.hash.Hash");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$org$apache$shiro$util$ByteSource() {
        Class clazz = $class$org$apache$shiro$util$ByteSource;
        if (clazz == null) {
            clazz = $class$org$apache$shiro$util$ByteSource = DefaultHashServiceTest.class$("org.apache.shiro.util.ByteSource");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$org$apache$shiro$crypto$SecureRandomNumberGenerator() {
        Class clazz = $class$org$apache$shiro$crypto$SecureRandomNumberGenerator;
        if (clazz == null) {
            clazz = $class$org$apache$shiro$crypto$SecureRandomNumberGenerator = DefaultHashServiceTest.class$("org.apache.shiro.crypto.SecureRandomNumberGenerator");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$array$$class$byte() {
        Class clazz = array$$class$byte;
        if (clazz == null) {
            clazz = array$$class$byte = DefaultHashServiceTest.class$("[B");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$lang$String() {
        Class clazz = $class$java$lang$String;
        if (clazz == null) {
            clazz = $class$java$lang$String = DefaultHashServiceTest.class$("java.lang.String");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$org$apache$shiro$crypto$RandomNumberGenerator() {
        Class clazz = $class$org$apache$shiro$crypto$RandomNumberGenerator;
        if (clazz == null) {
            clazz = $class$org$apache$shiro$crypto$RandomNumberGenerator = DefaultHashServiceTest.class$("org.apache.shiro.crypto.RandomNumberGenerator");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$org$apache$shiro$util$ByteSource$Util() {
        Class clazz = $class$org$apache$shiro$util$ByteSource$Util;
        if (clazz == null) {
            clazz = $class$org$apache$shiro$util$ByteSource$Util = DefaultHashServiceTest.class$("org.apache.shiro.util.ByteSource$Util");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$util$Arrays() {
        Class clazz = $class$java$util$Arrays;
        if (clazz == null) {
            clazz = $class$java$util$Arrays = DefaultHashServiceTest.class$("java.util.Arrays");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$org$apache$shiro$crypto$hash$DefaultHashServiceTest() {
        Class clazz = $class$org$apache$shiro$crypto$hash$DefaultHashServiceTest;
        if (clazz == null) {
            clazz = $class$org$apache$shiro$crypto$hash$DefaultHashServiceTest = DefaultHashServiceTest.class$("org.apache.shiro.crypto.hash.DefaultHashServiceTest");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$org$easymock$EasyMock() {
        Class clazz = $class$org$easymock$EasyMock;
        if (clazz == null) {
            clazz = $class$org$easymock$EasyMock = DefaultHashServiceTest.class$("org.easymock.EasyMock");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$org$apache$shiro$crypto$hash$DefaultHashService() {
        Class clazz = $class$org$apache$shiro$crypto$hash$DefaultHashService;
        if (clazz == null) {
            clazz = $class$org$apache$shiro$crypto$hash$DefaultHashService = DefaultHashServiceTest.class$("org.apache.shiro.crypto.hash.DefaultHashService");
        }
        return clazz;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

