/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.crypto;

import org.apache.shiro.crypto.SecureRandomNumberGenerator;
import org.apache.shiro.util.ByteSource;
import org.junit.Assert;
import org.junit.Test;

public class SecureRandomNumberGeneratorTest {
    @Test
    public void testDefaultNextBytesSize() {
        SecureRandomNumberGenerator rng = new SecureRandomNumberGenerator();
        boolean negativeThrown = false;
        boolean zeroThrown = false;
        try {
            rng.setDefaultNextBytesSize(-1);
        }
        catch (IllegalArgumentException e) {
            negativeThrown = true;
        }
        try {
            rng.setDefaultNextBytesSize(0);
        }
        catch (IllegalArgumentException e) {
            zeroThrown = true;
        }
        Assert.assertTrue((boolean)negativeThrown);
        Assert.assertTrue((boolean)zeroThrown);
        ByteSource bs = rng.nextBytes();
        Assert.assertNotNull((Object)bs);
        Assert.assertNotNull((Object)bs.getBytes());
        Assert.assertEquals((long)16L, (long)bs.getBytes().length);
        rng.setDefaultNextBytesSize(64);
        Assert.assertNotNull((Object)bs);
        bs = rng.nextBytes();
        Assert.assertNotNull((Object)bs.getBytes());
        Assert.assertEquals((long)64L, (long)bs.getBytes().length);
    }

    @Test(expected=NullPointerException.class)
    public void testInvalidSecureRandomProperty() {
        SecureRandomNumberGenerator rng = new SecureRandomNumberGenerator();
        rng.setSecureRandom(null);
    }

    @Test
    public void testNextBytesWithSize() {
        SecureRandomNumberGenerator rng = new SecureRandomNumberGenerator();
        boolean negativeThrown = false;
        boolean zeroThrown = false;
        try {
            rng.nextBytes(-1);
        }
        catch (IllegalArgumentException e) {
            negativeThrown = true;
        }
        try {
            rng.nextBytes(0);
        }
        catch (IllegalArgumentException e) {
            zeroThrown = true;
        }
        Assert.assertTrue((boolean)negativeThrown);
        Assert.assertTrue((boolean)zeroThrown);
        ByteSource bs = rng.nextBytes(8);
        Assert.assertNotNull((Object)bs);
        Assert.assertNotNull((Object)bs.getBytes());
        Assert.assertEquals((long)8L, (long)bs.getBytes().length);
    }
}

