/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import junit.framework.Assert;
import org.apache.shiro.codec.CodecSupport;
import org.apache.shiro.crypto.BlowfishCipherService;
import org.apache.shiro.util.ByteSource;
import org.junit.Test;

public class BlowfishCipherServiceTest {
    private static final String[] PLAINTEXTS = new String[]{"Hello, this is a test.", "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua."};

    @Test
    public void testBlockOperations() {
        BlowfishCipherService blowfish = new BlowfishCipherService();
        byte[] key = blowfish.generateNewKey().getEncoded();
        for (String plain : PLAINTEXTS) {
            byte[] plaintext = CodecSupport.toBytes((String)plain);
            ByteSource ciphertext = blowfish.encrypt(plaintext, key);
            ByteSource decrypted = blowfish.decrypt(ciphertext.getBytes(), key);
            Assert.assertTrue((boolean)Arrays.equals(plaintext, decrypted.getBytes()));
        }
    }

    @Test
    public void testStreamingOperations() {
        BlowfishCipherService cipher = new BlowfishCipherService();
        byte[] key = cipher.generateNewKey().getEncoded();
        for (String plain : PLAINTEXTS) {
            byte[] plaintext = CodecSupport.toBytes((String)plain);
            ByteArrayInputStream plainIn = new ByteArrayInputStream(plaintext);
            ByteArrayOutputStream cipherOut = new ByteArrayOutputStream();
            cipher.encrypt((InputStream)plainIn, (OutputStream)cipherOut, key);
            byte[] ciphertext = cipherOut.toByteArray();
            ByteArrayInputStream cipherIn = new ByteArrayInputStream(ciphertext);
            ByteArrayOutputStream plainOut = new ByteArrayOutputStream();
            cipher.decrypt((InputStream)cipherIn, (OutputStream)plainOut, key);
            byte[] decrypted = plainOut.toByteArray();
            Assert.assertTrue((boolean)Arrays.equals(plaintext, decrypted));
        }
    }
}

