/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.config;

import java.util.Scanner;
import org.apache.shiro.config.Ini;
import org.junit.Assert;
import org.junit.Test;

public class IniTest {
    private static final String NL = "\n";

    @Test
    public void testNoSections() {
        String test = "prop1 = value1\nprop2 = value2";
        Ini ini = new Ini();
        ini.load(test);
        Assert.assertNotNull((Object)ini.getSections());
        Assert.assertEquals((long)1L, (long)ini.getSections().size());
        Ini.Section section = (Ini.Section)ini.getSections().iterator().next();
        Assert.assertEquals((Object)"", (Object)section.getName());
        Assert.assertFalse((boolean)section.isEmpty());
        Assert.assertEquals((long)2L, (long)section.size());
        Assert.assertEquals((Object)"value1", (Object)section.get((Object)"prop1"));
        Assert.assertEquals((Object)"value2", (Object)section.get((Object)"prop2"));
    }

    @Test
    public void testIsContinued() {
        String line = "prop = value ";
        Assert.assertFalse((boolean)Ini.Section.isContinued((String)line));
        line = "prop = value\\";
        Assert.assertTrue((boolean)Ini.Section.isContinued((String)line));
        line = "prop = value\\\\";
        Assert.assertFalse((boolean)Ini.Section.isContinued((String)line));
        line = "prop = value\\\\\\";
        Assert.assertTrue((boolean)Ini.Section.isContinued((String)line));
    }

    @Test
    public void testSplitKeyValue() {
        String test = "Truth Beauty";
        String[] kv = Ini.Section.splitKeyValue((String)test);
        Assert.assertEquals((Object)"Truth", (Object)kv[0]);
        Assert.assertEquals((Object)"Beauty", (Object)kv[1]);
        test = "Truth=Beauty";
        kv = Ini.Section.splitKeyValue((String)test);
        Assert.assertEquals((Object)"Truth", (Object)kv[0]);
        Assert.assertEquals((Object)"Beauty", (Object)kv[1]);
        test = "Truth:Beauty";
        kv = Ini.Section.splitKeyValue((String)test);
        Assert.assertEquals((Object)"Truth", (Object)kv[0]);
        Assert.assertEquals((Object)"Beauty", (Object)kv[1]);
        test = "Truth = Beauty";
        kv = Ini.Section.splitKeyValue((String)test);
        Assert.assertEquals((Object)"Truth", (Object)kv[0]);
        Assert.assertEquals((Object)"Beauty", (Object)kv[1]);
        test = "Truth:  Beauty";
        kv = Ini.Section.splitKeyValue((String)test);
        Assert.assertEquals((Object)"Truth", (Object)kv[0]);
        Assert.assertEquals((Object)"Beauty", (Object)kv[1]);
        test = "Truth  :Beauty";
        kv = Ini.Section.splitKeyValue((String)test);
        Assert.assertEquals((Object)"Truth", (Object)kv[0]);
        Assert.assertEquals((Object)"Beauty", (Object)kv[1]);
        test = "Truth:Beauty        ";
        kv = Ini.Section.splitKeyValue((String)test);
        Assert.assertEquals((Object)"Truth", (Object)kv[0]);
        Assert.assertEquals((Object)"Beauty", (Object)kv[1]);
        test = "    Truth:Beauty    ";
        kv = Ini.Section.splitKeyValue((String)test);
        Assert.assertEquals((Object)"Truth", (Object)kv[0]);
        Assert.assertEquals((Object)"Beauty", (Object)kv[1]);
        test = "Truth        =Beauty";
        kv = Ini.Section.splitKeyValue((String)test);
        Assert.assertEquals((Object)"Truth", (Object)kv[0]);
        Assert.assertEquals((Object)"Beauty", (Object)kv[1]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSplitKeyValueNoValue() {
        String test = "  Truth  ";
        Ini.Section.splitKeyValue((String)test);
    }

    @Test
    public void testOneSection() {
        String sectionName = "main";
        String test = "\n\n  \n    #  comment1 \n ; comment 2\n[" + sectionName + "]" + NL + "prop1 = value1" + NL + "  " + NL + "; comment " + NL + "prop2   value2" + NL + "prop3:value3" + NL + "prop4 : value 4" + NL + "prop5 some long \\" + NL + "      value " + NL + "# comment.";
        Ini ini = new Ini();
        ini.load(new Scanner(test));
        Assert.assertNotNull((Object)ini.getSections());
        Assert.assertEquals((long)1L, (long)ini.getSections().size());
        Ini.Section section = ini.getSection("main");
        Assert.assertNotNull((Object)section);
        Assert.assertEquals((Object)sectionName, (Object)section.getName());
        Assert.assertFalse((boolean)section.isEmpty());
        Assert.assertEquals((long)5L, (long)section.size());
        Assert.assertEquals((Object)"value1", (Object)section.get((Object)"prop1"));
        Assert.assertEquals((Object)"value2", (Object)section.get((Object)"prop2"));
        Assert.assertEquals((Object)"value3", (Object)section.get((Object)"prop3"));
        Assert.assertEquals((Object)"value 4", (Object)section.get((Object)"prop4"));
        Assert.assertEquals((Object)"some long value", (Object)section.get((Object)"prop5"));
    }
}

