/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.authc;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.subject.PrincipalCollection;
import org.junit.Assert;
import org.junit.Test;

public class SimpleAuthenticationInfoTest {
    @Test
    public void testMergeWithEmptyInstances() {
        SimpleAuthenticationInfo aggregate = new SimpleAuthenticationInfo();
        SimpleAuthenticationInfo local = new SimpleAuthenticationInfo();
        aggregate.merge((AuthenticationInfo)local);
    }

    @Test
    public void testMergeWithAggregateNullCredentials() {
        SimpleAuthenticationInfo aggregate = new SimpleAuthenticationInfo();
        SimpleAuthenticationInfo local = new SimpleAuthenticationInfo((Object)"username", (Object)"password", "testRealm");
        aggregate.merge((AuthenticationInfo)local);
    }

    @Test
    public void testMergeWithImmutablePrincipalCollection() {
        SimpleAuthenticationInfo aggregate = new SimpleAuthenticationInfo();
        PrincipalCollection principalCollection = new PrincipalCollection(){

            public List asList() {
                return null;
            }

            public Set asSet() {
                return null;
            }

            public <T> Collection<T> byType(Class<T> type) {
                return null;
            }

            public Collection fromRealm(String realmName) {
                HashSet<String> principals = new HashSet<String>();
                principals.add("testprincipal");
                return principals;
            }

            public Object getPrimaryPrincipal() {
                return null;
            }

            public Set<String> getRealmNames() {
                HashSet<String> realms = new HashSet<String>();
                realms.add("testrealm");
                return realms;
            }

            public boolean isEmpty() {
                return false;
            }

            public <T> T oneByType(Class<T> type) {
                return null;
            }

            public Iterator iterator() {
                return null;
            }
        };
        aggregate.setPrincipals(principalCollection);
        SimpleAuthenticationInfo local = new SimpleAuthenticationInfo((Object)"username", (Object)"password", "testRealm");
        aggregate.merge((AuthenticationInfo)local);
        Assert.assertEquals((long)2L, (long)aggregate.getPrincipals().asList().size());
    }
}

