/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.util;

import org.apache.shiro.util.PatternMatcher;
import org.apache.shiro.util.RegExPatternMatcher;
import org.junit.Assert;
import org.junit.Test;

public class RegExPatternMatcherTest {
    @Test
    public void testSimplePattern() {
        this.assertPatternMatch("a*b", "aaaaaaab");
    }

    @Test
    public void testMatchesWithCarriageReturn() {
        this.assertPatternMatch(".*", "/blah\n");
    }

    @Test
    public void testMatchesWithLineFeed() {
        this.assertPatternMatch(".*", "/blah\r");
    }

    @Test
    public void testCaseInsensitive() {
        RegExPatternMatcher pm = new RegExPatternMatcher();
        pm.setCaseInsensitive(true);
        this.assertPatternMatch("/blah", "/BlaH", (PatternMatcher)pm);
    }

    @Test
    public void testCaseSensitive() {
        this.assertPatternNotMatch("/blah", "/BlaH");
    }

    private void assertPatternMatch(String pattern, String path) {
        this.assertPatternMatch(pattern, path, (PatternMatcher)new RegExPatternMatcher());
    }

    private void assertPatternMatch(String pattern, String path, PatternMatcher pm) {
        Assert.assertTrue((String)("Expected path '" + path + "' to match pattern '" + pattern + "'"), (boolean)pm.matches(pattern, path));
    }

    private void assertPatternNotMatch(String pattern, String path) {
        this.assertPatternNotMatch(pattern, path, (PatternMatcher)new RegExPatternMatcher());
    }

    private void assertPatternNotMatch(String pattern, String path, PatternMatcher pm) {
        Assert.assertFalse((String)("Expected path '" + path + "' to NOT match pattern '" + pattern + "'"), (boolean)pm.matches(pattern, path));
    }
}

