/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.test;

import org.apache.shiro.SecurityUtils;
import org.apache.shiro.config.Ini;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.realm.text.IniRealm;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.LifecycleUtils;
import org.apache.shiro.util.ThreadContext;
import org.junit.After;
import org.junit.Before;

public class SecurityManagerTestSupport {
    protected static SecurityManager createTestSecurityManager() {
        Ini ini = new Ini();
        ini.setSectionProperty("users", "test", "test");
        return new DefaultSecurityManager((Realm)new IniRealm(ini));
    }

    protected void destroy(SecurityManager sm) {
        LifecycleUtils.destroy((Object)sm);
    }

    protected SecurityManager createAndBindTestSecurityManager() {
        SecurityManager sm = SecurityManagerTestSupport.createTestSecurityManager();
        ThreadContext.bind((SecurityManager)sm);
        return sm;
    }

    protected Subject createAndBindTestSubject() {
        SecurityManager sm = ThreadContext.getSecurityManager();
        if (sm == null) {
            this.createAndBindTestSecurityManager();
        }
        return SecurityUtils.getSubject();
    }

    @Before
    public void setup() {
        this.createAndBindTestSubject();
    }

    @After
    public void teardown() {
        ThreadContext.remove();
    }
}

