/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.session.mgt;

import java.io.Serializable;
import java.util.UUID;
import org.apache.shiro.session.ExpiredSessionException;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.SessionListenerAdapter;
import org.apache.shiro.session.mgt.DefaultSessionKey;
import org.apache.shiro.session.mgt.DefaultSessionManager;
import org.apache.shiro.session.mgt.ExecutorServiceSessionValidationScheduler;
import org.apache.shiro.session.mgt.SessionContext;
import org.apache.shiro.session.mgt.SessionFactory;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.session.mgt.SessionValidationScheduler;
import org.apache.shiro.session.mgt.SimpleSession;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.apache.shiro.util.ThreadContext;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultSessionManagerTest {
    DefaultSessionManager sm = null;

    @Before
    public void setup() {
        ThreadContext.remove();
        this.sm = new DefaultSessionManager();
    }

    @After
    public void tearDown() {
        this.sm.destroy();
        ThreadContext.remove();
    }

    public void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Test
    public void testGlobalTimeout() {
        long timeout = 1000L;
        this.sm.setGlobalSessionTimeout(timeout);
        Session session = this.sm.start(null);
        Assert.assertNotNull((Object)session);
        Assert.assertNotNull((Object)session.getId());
        Assert.assertEquals((long)session.getTimeout(), (long)timeout);
    }

    @Test
    public void testSessionListenerStartNotification() {
        final boolean[] started = new boolean[1];
        SessionListenerAdapter listener = new SessionListenerAdapter(){

            public void onStart(Session session) {
                started[0] = true;
            }
        };
        this.sm.getSessionListeners().add(listener);
        this.sm.start(null);
        Assert.assertTrue((boolean)started[0]);
    }

    @Test
    public void testSessionListenerStopNotification() {
        final boolean[] stopped = new boolean[1];
        SessionListenerAdapter listener = new SessionListenerAdapter(){

            public void onStop(Session session) {
                stopped[0] = true;
            }
        };
        this.sm.getSessionListeners().add(listener);
        Session session = this.sm.start(null);
        this.sm.stop((SessionKey)new DefaultSessionKey(session.getId()));
        Assert.assertTrue((boolean)stopped[0]);
    }

    @Test
    public void testSessionListenerStopNotificationWithReadAttribute() {
        final boolean[] stopped = new boolean[1];
        final String[] value = new String[1];
        SessionListenerAdapter listener = new SessionListenerAdapter(){

            public void onStop(Session session) {
                stopped[0] = true;
                value[0] = (String)session.getAttribute((Object)"foo");
            }
        };
        this.sm.getSessionListeners().add(listener);
        Session session = this.sm.start(null);
        session.setAttribute((Object)"foo", (Object)"bar");
        this.sm.stop((SessionKey)new DefaultSessionKey(session.getId()));
        Assert.assertTrue((boolean)stopped[0]);
        Assert.assertEquals((Object)"bar", (Object)value[0]);
    }

    @Test
    public void testSessionListenerExpiredNotification() {
        final boolean[] expired = new boolean[1];
        SessionListenerAdapter listener = new SessionListenerAdapter(){

            public void onExpiration(Session session) {
                expired[0] = true;
            }
        };
        this.sm.getSessionListeners().add(listener);
        this.sm.setGlobalSessionTimeout(100L);
        Session session = this.sm.start(null);
        this.sleep(150L);
        try {
            this.sm.checkValid((SessionKey)new DefaultSessionKey(session.getId()));
            Assert.fail((String)"check should have thrown an exception.");
        }
        catch (InvalidSessionException invalidSessionException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)expired[0]);
    }

    @Test
    public void testSessionDeleteOnExpiration() {
        this.sm.setGlobalSessionTimeout(100L);
        SessionDAO sessionDAO = (SessionDAO)EasyMock.createMock(SessionDAO.class);
        this.sm.setSessionDAO(sessionDAO);
        String sessionId1 = UUID.randomUUID().toString();
        SimpleSession session1 = new SimpleSession();
        session1.setId((Serializable)((Object)sessionId1));
        SimpleSession[] activeSession = new SimpleSession[]{session1};
        this.sm.setSessionFactory(new SessionFactory((Session[])activeSession){
            final /* synthetic */ Session[] val$activeSession;
            {
                this.val$activeSession = sessionArray;
            }

            public Session createSession(SessionContext initData) {
                return this.val$activeSession[0];
            }
        });
        EasyMock.expect((Object)sessionDAO.create((Session)EasyMock.eq((Object)session1))).andReturn((Object)sessionId1);
        sessionDAO.update((Session)EasyMock.eq((Object)session1));
        EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{sessionDAO});
        Session session = this.sm.start(null);
        Assert.assertNotNull((Object)session);
        EasyMock.verify((Object[])new Object[]{sessionDAO});
        EasyMock.reset((Object[])new Object[]{sessionDAO});
        EasyMock.expect((Object)sessionDAO.readSession((Serializable)((Object)sessionId1))).andReturn((Object)session1).anyTimes();
        sessionDAO.update((Session)EasyMock.eq((Object)session1));
        EasyMock.replay((Object[])new Object[]{sessionDAO});
        this.sm.setTimeout((SessionKey)new DefaultSessionKey((Serializable)((Object)sessionId1)), 1L);
        EasyMock.verify((Object[])new Object[]{sessionDAO});
        EasyMock.reset((Object[])new Object[]{sessionDAO});
        this.sleep(20L);
        EasyMock.expect((Object)sessionDAO.readSession((Serializable)((Object)sessionId1))).andReturn((Object)session1);
        sessionDAO.update((Session)EasyMock.eq((Object)session1));
        sessionDAO.delete((Session)session1);
        EasyMock.replay((Object[])new Object[]{sessionDAO});
        try {
            this.sm.getTimeout((SessionKey)new DefaultSessionKey((Serializable)((Object)sessionId1)));
            Assert.fail((String)("Session with id [" + sessionId1 + "] should have expired due to timeout."));
        }
        catch (ExpiredSessionException expiredSessionException) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{sessionDAO});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEnablingOfCustomSessionValidationScheduler() {
        ExecutorServiceSessionValidationScheduler sessionValidationScheduler = new ExecutorServiceSessionValidationScheduler();
        DefaultSessionManager sessionManager = new DefaultSessionManager();
        sessionManager.setSessionValidationScheduler((SessionValidationScheduler)sessionValidationScheduler);
        try {
            Session session = sessionManager.start(null);
            Assert.assertTrue((String)"sessionValidationScheduler was not enabled", (boolean)sessionValidationScheduler.isEnabled());
        }
        finally {
            sessionManager.destroy();
        }
    }

    public static <T extends Session> T eqSessionTimeout(long timeout) {
        EasyMock.reportMatcher((IArgumentMatcher)new SessionTimeoutMatcher(timeout));
        return null;
    }

    private static class SessionTimeoutMatcher
    implements IArgumentMatcher {
        private final long timeout;

        public SessionTimeoutMatcher(long timeout) {
            this.timeout = timeout;
        }

        public void appendTo(StringBuffer buffer) {
            buffer.append("eqSession(timeout=").append(this.timeout).append(")");
        }

        public boolean matches(Object o) {
            return o instanceof Session && ((Session)o).getTimeout() == this.timeout;
        }
    }
}

