/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.realm.ldap;

import java.util.UUID;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.AllowAllCredentialsMatcher;
import org.apache.shiro.realm.ldap.DefaultLdapRealm;
import org.apache.shiro.realm.ldap.JndiLdapContextFactory;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultLdapRealmTest {
    private DefaultLdapRealm realm;

    protected DefaultLdapRealm getNewRealmUnderTest() {
        return new DefaultLdapRealm();
    }

    @Before
    public void setUp() {
        this.realm = this.getNewRealmUnderTest();
    }

    @Test
    public void testDefaultInstance() {
        Assert.assertTrue((boolean)(this.realm.getCredentialsMatcher() instanceof AllowAllCredentialsMatcher));
        Assert.assertEquals(AuthenticationToken.class, (Object)this.realm.getAuthenticationTokenClass());
        Assert.assertTrue((boolean)(this.realm.getContextFactory() instanceof JndiLdapContextFactory));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetUserDnTemplateNull() {
        this.realm.setUserDnTemplate(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetUserDnTemplateEmpty() {
        this.realm.setUserDnTemplate("  ");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetUserDnTemplateWithoutToken() {
        this.realm.setUserDnTemplate("uid=,ou=users,dc=mycompany,dc=com");
    }

    @Test
    public void testUserDnTemplate() {
        String template = "uid={0},ou=users,dc=mycompany,dc=com";
        this.realm.setUserDnTemplate(template);
        Assert.assertEquals((Object)template, (Object)this.realm.getUserDnTemplate());
    }

    @Test
    public void testUserDnTemplateSubstitution() throws NamingException {
        this.realm.setUserDnTemplate("uid={0},ou=users,dc=mycompany,dc=com");
        LdapContextFactory factory = (LdapContextFactory)EasyMock.createMock(LdapContextFactory.class);
        this.realm.setContextFactory(factory);
        String expectedPrincipal = "uid=jsmith,ou=users,dc=mycompany,dc=com";
        EasyMock.expect((Object)factory.getLdapContext(EasyMock.eq((Object)expectedPrincipal), EasyMock.isA(Object.class))).andReturn((Object)((LdapContext)EasyMock.createNiceMock(LdapContext.class)));
        EasyMock.replay((Object[])new Object[]{factory});
        this.realm.getAuthenticationInfo((AuthenticationToken)new UsernamePasswordToken("jsmith", "secret"));
        EasyMock.verify((Object[])new Object[]{factory});
    }

    @Test(expected=org.apache.shiro.authc.AuthenticationException.class)
    public void testGetAuthenticationInfoNamingAuthenticationException() throws NamingException {
        this.realm.setUserDnTemplate("uid={0},ou=users,dc=mycompany,dc=com");
        LdapContextFactory factory = (LdapContextFactory)EasyMock.createMock(LdapContextFactory.class);
        this.realm.setContextFactory(factory);
        EasyMock.expect((Object)factory.getLdapContext(EasyMock.isA(Object.class), EasyMock.isA(Object.class))).andThrow((Throwable)new AuthenticationException("LDAP Authentication failed."));
        EasyMock.replay((Object[])new Object[]{factory});
        this.realm.getAuthenticationInfo((AuthenticationToken)new UsernamePasswordToken("jsmith", "secret"));
    }

    @Test(expected=org.apache.shiro.authc.AuthenticationException.class)
    public void testGetAuthenticationInfoNamingException() throws NamingException {
        this.realm.setUserDnTemplate("uid={0},ou=users,dc=mycompany,dc=com");
        LdapContextFactory factory = (LdapContextFactory)EasyMock.createMock(LdapContextFactory.class);
        this.realm.setContextFactory(factory);
        EasyMock.expect((Object)factory.getLdapContext(EasyMock.isA(Object.class), EasyMock.isA(Object.class))).andThrow((Throwable)new NamingException("Communication error."));
        EasyMock.replay((Object[])new Object[]{factory});
        this.realm.getAuthenticationInfo((AuthenticationToken)new UsernamePasswordToken("jsmith", "secret"));
    }

    @Test
    public void testGetAuthenticationInfoNonSimpleToken() throws NamingException {
        this.realm.setUserDnTemplate("uid={0},ou=users,dc=mycompany,dc=com");
        LdapContextFactory factory = (LdapContextFactory)EasyMock.createMock(LdapContextFactory.class);
        this.realm.setContextFactory(factory);
        final UUID userId = UUID.randomUUID();
        EasyMock.expect((Object)factory.getLdapContext(EasyMock.eq((Object)userId), EasyMock.isA(Object.class))).andReturn((Object)((LdapContext)EasyMock.createNiceMock(LdapContext.class)));
        EasyMock.replay((Object[])new Object[]{factory});
        this.realm.getAuthenticationInfo(new AuthenticationToken(){

            public Object getPrincipal() {
                return userId;
            }

            public Object getCredentials() {
                return "secret";
            }
        });
        EasyMock.verify((Object[])new Object[]{factory});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetUserDnNullArgument() {
        this.realm.getUserDn(null);
    }

    @Test
    public void testGetUserDnWithOutPrefixAndSuffix() {
        this.realm = new DefaultLdapRealm(){

            protected String getUserDnPrefix() {
                return null;
            }

            protected String getUserDnSuffix() {
                return null;
            }
        };
        String principal = "foo";
        String userDn = this.realm.getUserDn(principal);
        Assert.assertEquals((Object)principal, (Object)userDn);
    }
}

