/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.realm.ldap;

import java.util.Hashtable;
import java.util.UUID;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;
import org.apache.shiro.realm.ldap.DefaultLdapContextFactory;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;

public class DefaultLdapContextFactoryTest {
    private DefaultLdapContextFactory factory;

    @Before
    public void setUp() {
        this.factory = new DefaultLdapContextFactory(){

            protected LdapContext createLdapContext(Hashtable env) throws NamingException {
                return (LdapContext)EasyMock.createNiceMock(LdapContext.class);
            }
        };
    }

    @Test(expected=NamingException.class)
    public void testGetLdapContext() throws NamingException {
        this.factory = new DefaultLdapContextFactory();
        String brokenHost = UUID.randomUUID().toString();
        this.factory.setUrl("ldap://" + brokenHost + ":389");
        this.factory.getLdapContext((Object)"foo", (Object)"bar");
    }

    @Test(expected=IllegalStateException.class)
    public void testGetLdapContextWithoutUrl() throws NamingException {
        this.factory.getLdapContext((Object)"foo", (Object)"bar");
    }

    @Test(expected=AuthenticationException.class)
    public void testEmptyStringCredentials() throws NamingException {
        this.factory.setUrl("ldap://localhost:389");
        this.factory.getLdapContext((Object)"jcoder", (Object)"");
    }

    @Test(expected=AuthenticationException.class)
    public void testEmptyCharArrayCredentials() throws NamingException {
        this.factory.setUrl("ldap://localhost:389");
        this.factory.getLdapContext((Object)"jcoder", (Object)new char[0]);
    }

    @Test(expected=AuthenticationException.class)
    public void testEmptyByteArrayCredentials() throws NamingException {
        this.factory.setUrl("ldap://localhost:389");
        this.factory.getLdapContext((Object)"jcoder", (Object)new byte[0]);
    }

    @Test(expected=AuthenticationException.class)
    public void testEmptyNullCredentials() throws NamingException {
        this.factory.setUrl("ldap://localhost:389");
        this.factory.getLdapContext((Object)"jcoder", null);
    }
}

