/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.realm.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.sql.DataSource;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.codec.CodecSupport;
import org.apache.shiro.config.Ini;
import org.apache.shiro.config.IniSecurityManagerFactory;
import org.apache.shiro.crypto.hash.Sha256Hash;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.realm.jdbc.JdbcRealm;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.JdbcUtils;
import org.apache.shiro.util.ThreadContext;
import org.hsqldb.jdbc.JDBCDataSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class JDBCRealmTest {
    protected DefaultSecurityManager securityManager = null;
    protected AuthorizingRealm realm;
    protected final String username = "testUser";
    protected final String plainTextPassword = "testPassword";
    protected final String salt = "testUser";
    protected final String testRole = "testRole";
    protected final String testPermissionString = "testDomain:testTarget:testAction";
    protected HashMap<String, JdbcRealm> realmMap = new HashMap();
    protected HashMap<String, DataSource> dsMap = new HashMap();
    @Rule
    public TestName name = new TestName();

    @Before
    public void setup() {
        ThreadContext.remove();
        Ini config = new Ini();
        config.setSectionProperty("main", "myRealm", "org.apache.shiro.realm.jdbc.JdbcRealm");
        config.setSectionProperty("main", "myRealmCredentialsMatcher", "org.apache.shiro.authc.credential.Sha256CredentialsMatcher");
        config.setSectionProperty("main", "myRealm.credentialsMatcher", "$myRealmCredentialsMatcher");
        config.setSectionProperty("main", "securityManager.sessionManager.sessionValidationSchedulerEnabled", "false");
        IniSecurityManagerFactory factory = new IniSecurityManagerFactory(config);
        this.securityManager = (DefaultSecurityManager)factory.createInstance();
        SecurityUtils.setSecurityManager((SecurityManager)this.securityManager);
        this.createRealm(this.name.getMethodName());
    }

    @After
    public void tearDown() {
        String testName = this.name.getMethodName();
        this.shutDown(testName);
        SecurityUtils.setSecurityManager(null);
        this.securityManager.destroy();
        ThreadContext.remove();
    }

    @Test
    public void testUnSaltedSuccess() throws Exception {
        String testMethodName = this.name.getMethodName();
        JdbcRealm realm = this.realmMap.get(testMethodName);
        this.createDefaultSchema(testMethodName, false);
        realm.setSaltStyle(JdbcRealm.SaltStyle.NO_SALT);
        Subject.Builder builder = new Subject.Builder((SecurityManager)this.securityManager);
        Subject currentUser = builder.buildSubject();
        UsernamePasswordToken token = new UsernamePasswordToken("testUser", "testPassword");
        currentUser.login((AuthenticationToken)token);
        currentUser.logout();
    }

    @Test
    public void testUnSaltedWrongPassword() throws Exception {
        String testMethodName = this.name.getMethodName();
        JdbcRealm realm = this.realmMap.get(testMethodName);
        this.createDefaultSchema(testMethodName, false);
        realm.setSaltStyle(JdbcRealm.SaltStyle.NO_SALT);
        Subject.Builder builder = new Subject.Builder((SecurityManager)this.securityManager);
        Subject currentUser = builder.buildSubject();
        UsernamePasswordToken token = new UsernamePasswordToken("testUser", "passwrd");
        try {
            currentUser.login((AuthenticationToken)token);
        }
        catch (IncorrectCredentialsException incorrectCredentialsException) {
            // empty catch block
        }
    }

    @Test
    public void testUnSaltedMultipleRows() throws Exception {
        String testMethodName = this.name.getMethodName();
        JdbcRealm realm = this.realmMap.get(testMethodName);
        this.createDefaultSchema(testMethodName, false);
        realm.setSaltStyle(JdbcRealm.SaltStyle.NO_SALT);
        Connection conn = this.dsMap.get(testMethodName).getConnection();
        Statement sql = conn.createStatement();
        sql.executeUpdate("insert into users values ('testUser', 'dupe')");
        Subject.Builder builder = new Subject.Builder((SecurityManager)this.securityManager);
        Subject currentUser = builder.buildSubject();
        UsernamePasswordToken token = new UsernamePasswordToken("testUser", "passwrd");
        try {
            currentUser.login((AuthenticationToken)token);
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
    }

    @Test
    public void testSaltColumnSuccess() throws Exception {
        String testMethodName = this.name.getMethodName();
        JdbcRealm realm = this.realmMap.get(testMethodName);
        this.createSaltColumnSchema(testMethodName, false);
        realm.setSaltStyle(JdbcRealm.SaltStyle.COLUMN);
        realm.setSaltIsBase64Encoded(false);
        Subject.Builder builder = new Subject.Builder((SecurityManager)this.securityManager);
        Subject currentUser = builder.buildSubject();
        UsernamePasswordToken token = new UsernamePasswordToken("testUser", "testPassword");
        currentUser.login((AuthenticationToken)token);
        currentUser.logout();
    }

    @Test
    public void testBase64EncodedSaltColumnSuccess() throws Exception {
        String testMethodName = this.name.getMethodName();
        JdbcRealm realm = this.realmMap.get(testMethodName);
        this.createSaltColumnSchema(testMethodName, true);
        realm.setSaltStyle(JdbcRealm.SaltStyle.COLUMN);
        Subject.Builder builder = new Subject.Builder((SecurityManager)this.securityManager);
        Subject currentUser = builder.buildSubject();
        UsernamePasswordToken token = new UsernamePasswordToken("testUser", "testPassword");
        currentUser.login((AuthenticationToken)token);
        currentUser.logout();
    }

    @Test
    public void testSaltColumnWrongPassword() throws Exception {
        String testMethodName = this.name.getMethodName();
        JdbcRealm realm = this.realmMap.get(testMethodName);
        this.createSaltColumnSchema(testMethodName, false);
        realm.setSaltStyle(JdbcRealm.SaltStyle.COLUMN);
        realm.setSaltIsBase64Encoded(false);
        Subject.Builder builder = new Subject.Builder((SecurityManager)this.securityManager);
        Subject currentUser = builder.buildSubject();
        UsernamePasswordToken token = new UsernamePasswordToken("testUser", "passwrd");
        try {
            currentUser.login((AuthenticationToken)token);
        }
        catch (IncorrectCredentialsException incorrectCredentialsException) {
            // empty catch block
        }
    }

    @Test
    public void testBase64SaltColumnWrongPassword() throws Exception {
        String testMethodName = this.name.getMethodName();
        JdbcRealm realm = this.realmMap.get(testMethodName);
        this.createSaltColumnSchema(testMethodName, true);
        realm.setSaltStyle(JdbcRealm.SaltStyle.COLUMN);
        realm.setSaltIsBase64Encoded(false);
        Subject.Builder builder = new Subject.Builder((SecurityManager)this.securityManager);
        Subject currentUser = builder.buildSubject();
        UsernamePasswordToken token = new UsernamePasswordToken("testUser", "passwrd");
        try {
            currentUser.login((AuthenticationToken)token);
        }
        catch (IncorrectCredentialsException incorrectCredentialsException) {
            // empty catch block
        }
    }

    @Test
    public void testExternalSuccess() throws Exception {
        String testMethodName = this.name.getMethodName();
        JdbcRealm realm = this.realmMap.get(testMethodName);
        this.createDefaultSchema(testMethodName, true);
        realm.setSaltStyle(JdbcRealm.SaltStyle.EXTERNAL);
        Subject.Builder builder = new Subject.Builder((SecurityManager)this.securityManager);
        Subject currentUser = builder.buildSubject();
        UsernamePasswordToken token = new UsernamePasswordToken("testUser", "testPassword");
        currentUser.login((AuthenticationToken)token);
        currentUser.logout();
    }

    @Test
    public void testExternalWrongPassword() throws Exception {
        String testMethodName = this.name.getMethodName();
        JdbcRealm realm = this.realmMap.get(testMethodName);
        this.createDefaultSchema(testMethodName, true);
        realm.setSaltStyle(JdbcRealm.SaltStyle.EXTERNAL);
        Subject.Builder builder = new Subject.Builder((SecurityManager)this.securityManager);
        Subject currentUser = builder.buildSubject();
        UsernamePasswordToken token = new UsernamePasswordToken("testUser", "passwrd");
        try {
            currentUser.login((AuthenticationToken)token);
        }
        catch (IncorrectCredentialsException incorrectCredentialsException) {
            // empty catch block
        }
    }

    @Test
    public void testRolePresent() throws Exception {
        String testMethodName = this.name.getMethodName();
        JdbcRealm realm = this.realmMap.get(testMethodName);
        this.createDefaultSchema(testMethodName, false);
        realm.setSaltStyle(JdbcRealm.SaltStyle.NO_SALT);
        Subject.Builder builder = new Subject.Builder((SecurityManager)this.securityManager);
        Subject currentUser = builder.buildSubject();
        UsernamePasswordToken token = new UsernamePasswordToken("testUser", "testPassword");
        currentUser.login((AuthenticationToken)token);
        Assert.assertTrue((boolean)currentUser.hasRole("testRole"));
    }

    @Test
    public void testRoleNotPresent() throws Exception {
        String testMethodName = this.name.getMethodName();
        JdbcRealm realm = this.realmMap.get(testMethodName);
        this.createDefaultSchema(testMethodName, false);
        realm.setSaltStyle(JdbcRealm.SaltStyle.NO_SALT);
        Subject.Builder builder = new Subject.Builder((SecurityManager)this.securityManager);
        Subject currentUser = builder.buildSubject();
        UsernamePasswordToken token = new UsernamePasswordToken("testUser", "testPassword");
        currentUser.login((AuthenticationToken)token);
        Assert.assertFalse((boolean)currentUser.hasRole("Game Overall Director"));
    }

    @Test
    public void testPermissionPresent() throws Exception {
        String testMethodName = this.name.getMethodName();
        JdbcRealm realm = this.realmMap.get(testMethodName);
        this.createDefaultSchema(testMethodName, false);
        realm.setSaltStyle(JdbcRealm.SaltStyle.NO_SALT);
        realm.setPermissionsLookupEnabled(true);
        Subject.Builder builder = new Subject.Builder((SecurityManager)this.securityManager);
        Subject currentUser = builder.buildSubject();
        UsernamePasswordToken token = new UsernamePasswordToken("testUser", "testPassword");
        currentUser.login((AuthenticationToken)token);
        Assert.assertTrue((boolean)currentUser.isPermitted("testDomain:testTarget:testAction"));
    }

    @Test
    public void testPermissionNotPresent() throws Exception {
        String testMethodName = this.name.getMethodName();
        JdbcRealm realm = this.realmMap.get(testMethodName);
        this.createDefaultSchema(testMethodName, false);
        realm.setSaltStyle(JdbcRealm.SaltStyle.NO_SALT);
        realm.setPermissionsLookupEnabled(true);
        Subject.Builder builder = new Subject.Builder((SecurityManager)this.securityManager);
        Subject currentUser = builder.buildSubject();
        UsernamePasswordToken token = new UsernamePasswordToken("testUser", "testPassword");
        currentUser.login((AuthenticationToken)token);
        Assert.assertFalse((boolean)currentUser.isPermitted("testDomain:testTarget:specialAction"));
    }

    protected void createRealm(String testMethodName) {
        JdbcRealm realm = (JdbcRealm)this.securityManager.getRealms().iterator().next();
        this.realmMap.put(testMethodName, realm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutDown(String testName) {
        Connection conn = null;
        Statement sql = null;
        DataSource ds = this.dsMap.get(testName);
        try {
            Connection c = ds.getConnection();
            Statement s = c.createStatement();
            s.executeUpdate("SHUTDOWN");
        }
        catch (SQLException sQLException) {
        }
        finally {
            JdbcUtils.closeStatement(sql);
            JdbcUtils.closeConnection(conn);
            this.dsMap.remove(testName);
            this.realmMap.remove(testName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDefaultSchema(String testName, boolean salted) {
        JDBCDataSource ds = new JDBCDataSource();
        ds.setDatabase("jdbc:hsqldb:mem:" + this.name);
        ds.setUser("SA");
        ds.setPassword("");
        Connection conn = null;
        Statement sql = null;
        try {
            conn = ds.getConnection();
            sql = conn.createStatement();
            sql.executeUpdate("create table users (username varchar(20), password varchar(100))");
            Sha256Hash sha256Hash = salted ? new Sha256Hash((Object)"testPassword", (Object)"testUser") : new Sha256Hash((Object)"testPassword");
            String password = sha256Hash.toHex();
            sql.executeUpdate("insert into users values ('testUser', '" + password + "')");
        }
        catch (SQLException ex) {
            try {
                Assert.fail((String)"Exception creating test database");
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(sql);
                JdbcUtils.closeConnection((Connection)conn);
                throw throwable;
            }
            JdbcUtils.closeStatement((Statement)sql);
            JdbcUtils.closeConnection((Connection)conn);
        }
        JdbcUtils.closeStatement((Statement)sql);
        JdbcUtils.closeConnection((Connection)conn);
        this.createRolesAndPermissions((DataSource)ds);
        this.realmMap.get(testName).setDataSource((DataSource)ds);
        this.dsMap.put(testName, (DataSource)ds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createSaltColumnSchema(String testName, boolean base64EncodeSalt) {
        JDBCDataSource ds = new JDBCDataSource();
        ds.setDatabase("jdbc:hsqldb:mem:" + this.name);
        ds.setUser("SA");
        ds.setPassword("");
        Connection conn = null;
        Statement sql = null;
        try {
            conn = ds.getConnection();
            sql = conn.createStatement();
            sql.executeUpdate("create table users (username varchar(20), password varchar(100), password_salt varchar(20))");
            Sha256Hash sha256Hash = new Sha256Hash((Object)"testPassword", (Object)"testUser");
            String password = sha256Hash.toHex();
            String maybeBase64EncodedSalt = base64EncodeSalt ? Base64.encodeToString((byte[])CodecSupport.toBytes((String)"testUser")) : "testUser";
            sql.executeUpdate("insert into users values ('testUser', '" + password + "', '" + maybeBase64EncodedSalt + "')");
        }
        catch (SQLException ex) {
            try {
                Assert.fail((String)"Exception creating test database");
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(sql);
                JdbcUtils.closeConnection((Connection)conn);
                throw throwable;
            }
            JdbcUtils.closeStatement((Statement)sql);
            JdbcUtils.closeConnection((Connection)conn);
        }
        JdbcUtils.closeStatement((Statement)sql);
        JdbcUtils.closeConnection((Connection)conn);
        this.createRolesAndPermissions((DataSource)ds);
        this.realmMap.get(testName).setDataSource((DataSource)ds);
        this.dsMap.put(testName, (DataSource)ds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createRolesAndPermissions(DataSource ds) {
        Connection conn = null;
        Statement sql = null;
        try {
            conn = ds.getConnection();
            sql = conn.createStatement();
            sql.executeUpdate("create table user_roles (username varchar(20), role_name varchar(20))");
            sql.executeUpdate("insert into user_roles values ('testUser', 'testRole')");
            sql.executeUpdate("create table roles_permissions (role_name varchar(20), permission varchar(40))");
            sql.executeUpdate("insert into roles_permissions values ('testRole', 'testDomain:testTarget:testAction')");
        }
        catch (SQLException ex) {
            try {
                Assert.fail((String)"Exception adding test role and permission");
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(sql);
                JdbcUtils.closeConnection((Connection)conn);
                throw throwable;
            }
            JdbcUtils.closeStatement((Statement)sql);
            JdbcUtils.closeConnection((Connection)conn);
        }
        JdbcUtils.closeStatement((Statement)sql);
        JdbcUtils.closeConnection((Connection)conn);
    }
}

