/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.realm;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.lang.ref.SoftReference;
import java.util.List;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.RememberMeAuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class AuthenticatingRealmTest
implements GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public AuthenticatingRealmTest() {
        MetaClass metaClass;
        CallSite[] callSiteArray = AuthenticatingRealmTest.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Test
    public void testSetName() {
        CallSite[] callSiteArray = AuthenticatingRealmTest.$getCallSiteArray();
        AuthenticatingRealm realm = (AuthenticatingRealm)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callConstructor(TestAuthenticatingRealm.class, (Object)this), AuthenticatingRealm.class);
        String name = "foo";
        String string = name;
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)realm, (String)"name");
        callSiteArray[1].call((Object)realm);
        callSiteArray[2].callStatic(Assert.class, (Object)name, callSiteArray[3].callGetProperty((Object)realm));
        callSiteArray[4].callStatic(Assert.class, callSiteArray[5].call((Object)name, callSiteArray[6].callGetProperty(AuthenticatingRealm.class)), callSiteArray[7].callGetProperty((Object)realm));
        String string2 = "bar";
        ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)realm, (String)"authenticationCacheName");
        callSiteArray[8].callStatic(Assert.class, (Object)name, callSiteArray[9].callGetProperty((Object)realm));
        callSiteArray[10].callStatic(Assert.class, (Object)"bar", callSiteArray[11].callGetProperty((Object)realm));
    }

    @Test
    public void testSupports() {
        CallSite[] callSiteArray = AuthenticatingRealmTest.$getCallSiteArray();
        String password = "foo";
        Object token = callSiteArray[12].callConstructor(UsernamePasswordToken.class, (Object)"username", (Object)password);
        AuthenticatingRealm realm = (AuthenticatingRealm)ScriptBytecodeAdapter.castToType((Object)callSiteArray[13].callConstructor(TestAuthenticatingRealm.class, (Object)this), AuthenticatingRealm.class);
        callSiteArray[14].callStatic(Assert.class, callSiteArray[15].call((Object)realm, token));
    }

    @Test
    public void testSupportsWithCustomAuthenticationTokenClass() {
        CallSite[] callSiteArray = AuthenticatingRealmTest.$getCallSiteArray();
        Object token = callSiteArray[16].callStatic(EasyMock.class, RememberMeAuthenticationToken.class);
        callSiteArray[17].callStatic(EasyMock.class, token);
        AuthenticatingRealm realm = (AuthenticatingRealm)ScriptBytecodeAdapter.castToType((Object)callSiteArray[18].callConstructor(TestAuthenticatingRealm.class, (Object)this), AuthenticatingRealm.class);
        callSiteArray[19].call((Object)realm, RememberMeAuthenticationToken.class);
        callSiteArray[20].callStatic(Assert.class, callSiteArray[21].call((Object)realm, token));
        callSiteArray[22].callStatic(EasyMock.class, token);
    }

    @Test
    public void testNewInstanceWithCacheManager() {
        CallSite[] callSiteArray = AuthenticatingRealmTest.$getCallSiteArray();
        Object cacheManager = callSiteArray[23].callStatic(EasyMock.class, CacheManager.class);
        callSiteArray[24].callStatic(EasyMock.class, cacheManager);
        AuthenticatingRealm realm = (AuthenticatingRealm)ScriptBytecodeAdapter.castToType((Object)callSiteArray[25].callConstructor(TestAuthenticatingRealm.class, (Object)this, cacheManager), AuthenticatingRealm.class);
        callSiteArray[26].callStatic(Assert.class, cacheManager, callSiteArray[27].callGetProperty((Object)realm));
        callSiteArray[28].callStatic(EasyMock.class, cacheManager);
    }

    @Test
    public void testNewInstanceWithCredentialsMatcher() {
        CallSite[] callSiteArray = AuthenticatingRealmTest.$getCallSiteArray();
        Object matcher = callSiteArray[29].callStatic(EasyMock.class, CredentialsMatcher.class);
        callSiteArray[30].callStatic(EasyMock.class, matcher);
        AuthenticatingRealm realm = (AuthenticatingRealm)ScriptBytecodeAdapter.castToType((Object)callSiteArray[31].callConstructor(TestAuthenticatingRealm.class, (Object)this, matcher), AuthenticatingRealm.class);
        callSiteArray[32].callStatic(Assert.class, matcher, callSiteArray[33].callGetProperty((Object)realm));
        callSiteArray[34].callStatic(EasyMock.class, matcher);
    }

    @Test
    public void testSetCache() {
        CallSite[] callSiteArray = AuthenticatingRealmTest.$getCallSiteArray();
        Object cache = callSiteArray[35].callStatic(EasyMock.class, Cache.class);
        callSiteArray[36].callStatic(EasyMock.class, cache);
        AuthenticatingRealm realm = (AuthenticatingRealm)ScriptBytecodeAdapter.castToType((Object)callSiteArray[37].callConstructor(TestAuthenticatingRealm.class, (Object)this), AuthenticatingRealm.class);
        Object object = cache;
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)realm, (String)"authenticationCache");
        callSiteArray[38].callStatic(Assert.class, cache, callSiteArray[39].callGetProperty((Object)realm));
        callSiteArray[40].callStatic(EasyMock.class, cache);
    }

    @Test
    public void testGetAuthenticationInfo() {
        CallSite[] callSiteArray = AuthenticatingRealmTest.$getCallSiteArray();
        String password = "foo";
        Object token = callSiteArray[41].callStatic(EasyMock.class, AuthenticationToken.class);
        Object info = callSiteArray[42].callStatic(EasyMock.class, AuthenticationInfo.class);
        callSiteArray[43].call(callSiteArray[44].call(callSiteArray[45].callStatic(EasyMock.class, callSiteArray[46].call(token)), (Object)password));
        callSiteArray[47].call(callSiteArray[48].call(callSiteArray[49].callStatic(EasyMock.class, callSiteArray[50].call(info)), (Object)password));
        callSiteArray[51].callStatic(EasyMock.class, token, info);
        AuthenticatingRealm realm = (AuthenticatingRealm)ScriptBytecodeAdapter.castToType((Object)callSiteArray[52].callConstructor(TestAuthenticatingRealm.class, (Object)this), AuthenticatingRealm.class);
        Object object = info;
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)realm, (String)"info");
        Object returnedInfo = callSiteArray[53].call((Object)realm, token);
        callSiteArray[54].callStatic(Assert.class, returnedInfo, info);
        callSiteArray[55].callStatic(EasyMock.class, token, info);
    }

    @Test
    public void testGetAuthenticationInfoWithNullReturnValue() {
        CallSite[] callSiteArray = AuthenticatingRealmTest.$getCallSiteArray();
        Object token = callSiteArray[56].callStatic(EasyMock.class, AuthenticationToken.class);
        Object info = callSiteArray[57].callStatic(EasyMock.class, AuthenticationInfo.class);
        callSiteArray[58].callStatic(EasyMock.class, token, info);
        AuthenticatingRealm realm = (AuthenticatingRealm)ScriptBytecodeAdapter.castToType((Object)callSiteArray[59].callConstructor(TestAuthenticatingRealm.class, (Object)this), AuthenticatingRealm.class);
        Object returnedInfo = callSiteArray[60].call((Object)realm, token);
        callSiteArray[61].callStatic(Assert.class, returnedInfo);
        callSiteArray[62].callStatic(EasyMock.class, token, info);
    }

    @Test
    public void testAuthenticationCachingEnabledWithCacheMiss() {
        CallSite[] callSiteArray = AuthenticatingRealmTest.$getCallSiteArray();
        String username = "foo";
        String password = "bar";
        Object cacheManager = callSiteArray[63].callStatic(EasyMock.class, CacheManager.class);
        Object cache = callSiteArray[64].callStatic(EasyMock.class, Cache.class);
        Object token = callSiteArray[65].callStatic(EasyMock.class, AuthenticationToken.class);
        Object info = callSiteArray[66].callStatic(EasyMock.class, AuthenticationInfo.class);
        callSiteArray[67].call(callSiteArray[68].callStatic(EasyMock.class, callSiteArray[69].call(cacheManager, callSiteArray[70].callStatic(EasyMock.class, String.class))), cache);
        callSiteArray[71].call(callSiteArray[72].call(callSiteArray[73].callStatic(EasyMock.class, callSiteArray[74].call(token)), (Object)username));
        callSiteArray[75].call(callSiteArray[76].call(callSiteArray[77].callStatic(EasyMock.class, callSiteArray[78].call(token)), (Object)password));
        callSiteArray[79].call(callSiteArray[80].callStatic(EasyMock.class, callSiteArray[81].call(cache, callSiteArray[82].callStatic(EasyMock.class, (Object)username))), null);
        callSiteArray[83].call(callSiteArray[84].callStatic(EasyMock.class, callSiteArray[85].call(cache, callSiteArray[86].callStatic(EasyMock.class, (Object)username), callSiteArray[87].callStatic(EasyMock.class, info))), null);
        callSiteArray[88].call(callSiteArray[89].callStatic(EasyMock.class, callSiteArray[90].call(info)), (Object)password);
        callSiteArray[91].callStatic(EasyMock.class, cacheManager, cache, token, info);
        AuthenticatingRealm realm = (AuthenticatingRealm)ScriptBytecodeAdapter.castToType((Object)callSiteArray[92].callConstructor(TestAuthenticatingRealm.class, (Object)this), AuthenticatingRealm.class);
        Object object = info;
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)realm, (String)"info");
        Object object2 = cacheManager;
        ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)realm, (String)"cacheManager");
        boolean bl = true;
        ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)realm, (String)"authenticationCachingEnabled");
        Object returnedInfo = callSiteArray[93].call((Object)realm, token);
        callSiteArray[94].callStatic(Assert.class, info, returnedInfo);
        callSiteArray[95].callStatic(EasyMock.class, cacheManager, cache, token, info);
    }

    @Test
    public void testAuthenticationCachingEnabledWithCacheHit() {
        CallSite[] callSiteArray = AuthenticatingRealmTest.$getCallSiteArray();
        String username = "foo";
        String password = "bar";
        Object cacheManager = callSiteArray[96].callStatic(EasyMock.class, CacheManager.class);
        Object cache = callSiteArray[97].callStatic(EasyMock.class, Cache.class);
        Object token = callSiteArray[98].callStatic(EasyMock.class, AuthenticationToken.class);
        Object info = callSiteArray[99].callStatic(EasyMock.class, AuthenticationInfo.class);
        callSiteArray[100].call(callSiteArray[101].callStatic(EasyMock.class, callSiteArray[102].call(cacheManager, callSiteArray[103].callStatic(EasyMock.class, String.class))), cache);
        callSiteArray[104].call(callSiteArray[105].call(callSiteArray[106].callStatic(EasyMock.class, callSiteArray[107].call(token)), (Object)username));
        callSiteArray[108].call(callSiteArray[109].call(callSiteArray[110].callStatic(EasyMock.class, callSiteArray[111].call(token)), (Object)password));
        callSiteArray[112].call(callSiteArray[113].callStatic(EasyMock.class, callSiteArray[114].call(cache, callSiteArray[115].callStatic(EasyMock.class, (Object)username))), info);
        callSiteArray[116].call(callSiteArray[117].callStatic(EasyMock.class, callSiteArray[118].call(info)), (Object)password);
        callSiteArray[119].callStatic(EasyMock.class, cacheManager, cache, token, info);
        AuthenticatingRealm realm = (AuthenticatingRealm)ScriptBytecodeAdapter.castToType((Object)callSiteArray[120].callConstructor(NoLookupAuthenticatingRealm.class, (Object)this), AuthenticatingRealm.class);
        Object object = cacheManager;
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)realm, (String)"cacheManager");
        boolean bl = true;
        ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)realm, (String)"authenticationCachingEnabled");
        Object returnedInfo = callSiteArray[121].call((Object)realm, token);
        callSiteArray[122].callStatic(Assert.class, info, returnedInfo);
        callSiteArray[123].callStatic(EasyMock.class, cacheManager, cache, token, info);
    }

    @Test
    public void testLogoutWithAuthenticationCachingEnabled() {
        CallSite[] callSiteArray = AuthenticatingRealmTest.$getCallSiteArray();
        String realmName = "testRealm";
        Object authcCacheName = callSiteArray[124].call((Object)realmName, callSiteArray[125].callGetProperty(AuthenticatingRealm.class));
        String username = "foo";
        Object cacheManager = callSiteArray[126].callStatic(EasyMock.class, CacheManager.class);
        Object cache = callSiteArray[127].callStatic(EasyMock.class, Cache.class);
        Object token = callSiteArray[128].callStatic(EasyMock.class, AuthenticationToken.class);
        Object info = callSiteArray[129].callStatic(EasyMock.class, AuthenticationInfo.class);
        Object principals = callSiteArray[130].callStatic(EasyMock.class, PrincipalCollection.class);
        List realmPrincipals = ScriptBytecodeAdapter.createList((Object[])new Object[]{username});
        callSiteArray[131].call(callSiteArray[132].call(callSiteArray[133].callStatic(EasyMock.class, callSiteArray[134].call(principals)), (Object)false));
        callSiteArray[135].call(callSiteArray[136].callStatic(EasyMock.class, callSiteArray[137].call(principals, callSiteArray[138].callStatic(EasyMock.class, (Object)realmName))), (Object)realmPrincipals);
        callSiteArray[139].call(callSiteArray[140].callStatic(EasyMock.class, callSiteArray[141].call(cacheManager, callSiteArray[142].callStatic(EasyMock.class, authcCacheName))), cache);
        callSiteArray[143].call(callSiteArray[144].callStatic(EasyMock.class, callSiteArray[145].call(cache, callSiteArray[146].callStatic(EasyMock.class, (Object)username))), info);
        callSiteArray[147].callStatic(EasyMock.class, ArrayUtil.createArray((Object)cacheManager, (Object)cache, (Object)token, (Object)info, (Object)principals));
        AuthenticatingRealm realm = (AuthenticatingRealm)ScriptBytecodeAdapter.castToType((Object)callSiteArray[148].callConstructor(NoLookupAuthenticatingRealm.class, (Object)this), AuthenticatingRealm.class);
        Object object = cacheManager;
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)realm, (String)"cacheManager");
        boolean bl = true;
        ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)realm, (String)"authenticationCachingEnabled");
        String string = realmName;
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)realm, (String)"name");
        callSiteArray[149].call((Object)realm, principals);
        callSiteArray[150].callStatic(EasyMock.class, ArrayUtil.createArray((Object)cacheManager, (Object)cache, (Object)token, (Object)info, (Object)principals));
    }

    @Test
    public void testAssertCredentialsMatchWithNullCredentialsMatcher() {
        CallSite[] callSiteArray = AuthenticatingRealmTest.$getCallSiteArray();
        AuthenticatingRealm realm = (AuthenticatingRealm)ScriptBytecodeAdapter.castToType((Object)callSiteArray[151].callConstructor(TestAuthenticatingRealm.class, (Object)this), AuthenticatingRealm.class);
        Object var3_3 = null;
        ScriptBytecodeAdapter.setProperty(var3_3, null, (Object)realm, (String)"credentialsMatcher");
        try {
            callSiteArray[152].call((Object)realm, null, null);
            callSiteArray[153].callStatic(Assert.class, (Object)"should have thrown an AuthenticationException");
        }
        catch (AuthenticationException e) {
            callSiteArray[154].callStatic(Assert.class, callSiteArray[155].call((Object)e));
            callSiteArray[156].callStatic(Assert.class, callSiteArray[157].call(callSiteArray[158].call((Object)e), (Object)"A CredentialsMatcher must be configured"));
        }
    }

    @Test
    public void testAssertCredentialsMatchFailure() {
        CallSite[] callSiteArray = AuthenticatingRealmTest.$getCallSiteArray();
        Object matcher = callSiteArray[159].callStatic(EasyMock.class, CredentialsMatcher.class);
        Object token = callSiteArray[160].callStatic(EasyMock.class, AuthenticationToken.class);
        Object info = callSiteArray[161].callStatic(EasyMock.class, AuthenticationInfo.class);
        callSiteArray[162].call(callSiteArray[163].callStatic(EasyMock.class, callSiteArray[164].call(matcher, callSiteArray[165].callStatic(EasyMock.class, token), callSiteArray[166].callStatic(EasyMock.class, info))), (Object)false);
        callSiteArray[167].callStatic(EasyMock.class, matcher, token, info);
        AuthenticatingRealm realm = (AuthenticatingRealm)ScriptBytecodeAdapter.castToType((Object)callSiteArray[168].callConstructor(TestAuthenticatingRealm.class, (Object)this), AuthenticatingRealm.class);
        Object object = matcher;
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)realm, (String)"credentialsMatcher");
        try {
            callSiteArray[169].call((Object)realm, token, info);
            callSiteArray[170].callStatic(Assert.class, (Object)"IncorrectCredentialsException should have been thrown.");
        }
        catch (IncorrectCredentialsException expected) {
        }
        callSiteArray[171].callStatic(EasyMock.class, matcher, token, info);
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        CallSite[] callSiteArray = AuthenticatingRealmTest.$getCallSiteArray();
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AuthenticatingRealmTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
        }
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[172].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AuthenticatingRealmTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{callSiteArray[173].call((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (Object)0)});
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[174].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AuthenticatingRealmTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AuthenticatingRealmTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        CallSite[] callSiteArray = AuthenticatingRealmTest.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, AuthenticatingRealmTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        CallSite[] callSiteArray = AuthenticatingRealmTest.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(AuthenticatingRealmTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AuthenticatingRealmTest.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "init";
        stringArray[2] = "assertEquals";
        stringArray[3] = "name";
        stringArray[4] = "assertEquals";
        stringArray[5] = "plus";
        stringArray[6] = "DEFAULT_AUTHENTICATION_CACHE_SUFFIX";
        stringArray[7] = "authenticationCacheName";
        stringArray[8] = "assertEquals";
        stringArray[9] = "name";
        stringArray[10] = "assertEquals";
        stringArray[11] = "authenticationCacheName";
        stringArray[12] = "<$constructor$>";
        stringArray[13] = "<$constructor$>";
        stringArray[14] = "assertTrue";
        stringArray[15] = "supports";
        stringArray[16] = "createStrictMock";
        stringArray[17] = "replay";
        stringArray[18] = "<$constructor$>";
        stringArray[19] = "setAuthenticationTokenClass";
        stringArray[20] = "assertTrue";
        stringArray[21] = "supports";
        stringArray[22] = "verify";
        stringArray[23] = "createStrictMock";
        stringArray[24] = "replay";
        stringArray[25] = "<$constructor$>";
        stringArray[26] = "assertSame";
        stringArray[27] = "cacheManager";
        stringArray[28] = "verify";
        stringArray[29] = "createStrictMock";
        stringArray[30] = "replay";
        stringArray[31] = "<$constructor$>";
        stringArray[32] = "assertSame";
        stringArray[33] = "credentialsMatcher";
        stringArray[34] = "verify";
        stringArray[35] = "createStrictMock";
        stringArray[36] = "replay";
        stringArray[37] = "<$constructor$>";
        stringArray[38] = "assertSame";
        stringArray[39] = "authenticationCache";
        stringArray[40] = "verify";
        stringArray[41] = "createStrictMock";
        stringArray[42] = "createStrictMock";
        stringArray[43] = "anyTimes";
        stringArray[44] = "andReturn";
        stringArray[45] = "expect";
        stringArray[46] = "getCredentials";
        stringArray[47] = "anyTimes";
        stringArray[48] = "andReturn";
        stringArray[49] = "expect";
        stringArray[50] = "getCredentials";
        stringArray[51] = "replay";
        stringArray[52] = "<$constructor$>";
        stringArray[53] = "getAuthenticationInfo";
        stringArray[54] = "assertSame";
        stringArray[55] = "verify";
        stringArray[56] = "createStrictMock";
        stringArray[57] = "createStrictMock";
        stringArray[58] = "replay";
        stringArray[59] = "<$constructor$>";
        stringArray[60] = "getAuthenticationInfo";
        stringArray[61] = "assertNull";
        stringArray[62] = "verify";
        stringArray[63] = "createStrictMock";
        stringArray[64] = "createStrictMock";
        stringArray[65] = "createStrictMock";
        stringArray[66] = "createStrictMock";
        stringArray[67] = "andReturn";
        stringArray[68] = "expect";
        stringArray[69] = "getCache";
        stringArray[70] = "isA";
        stringArray[71] = "anyTimes";
        stringArray[72] = "andReturn";
        stringArray[73] = "expect";
        stringArray[74] = "getPrincipal";
        stringArray[75] = "anyTimes";
        stringArray[76] = "andReturn";
        stringArray[77] = "expect";
        stringArray[78] = "getCredentials";
        stringArray[79] = "andReturn";
        stringArray[80] = "expect";
        stringArray[81] = "get";
        stringArray[82] = "eq";
        stringArray[83] = "andReturn";
        stringArray[84] = "expect";
        stringArray[85] = "put";
        stringArray[86] = "eq";
        stringArray[87] = "same";
        stringArray[88] = "andReturn";
        stringArray[89] = "expect";
        stringArray[90] = "getCredentials";
        stringArray[91] = "replay";
        stringArray[92] = "<$constructor$>";
        stringArray[93] = "getAuthenticationInfo";
        stringArray[94] = "assertSame";
        stringArray[95] = "verify";
        stringArray[96] = "createStrictMock";
        stringArray[97] = "createStrictMock";
        stringArray[98] = "createStrictMock";
        stringArray[99] = "createStrictMock";
        stringArray[100] = "andReturn";
        stringArray[101] = "expect";
        stringArray[102] = "getCache";
        stringArray[103] = "isA";
        stringArray[104] = "anyTimes";
        stringArray[105] = "andReturn";
        stringArray[106] = "expect";
        stringArray[107] = "getPrincipal";
        stringArray[108] = "anyTimes";
        stringArray[109] = "andReturn";
        stringArray[110] = "expect";
        stringArray[111] = "getCredentials";
        stringArray[112] = "andReturn";
        stringArray[113] = "expect";
        stringArray[114] = "get";
        stringArray[115] = "eq";
        stringArray[116] = "andReturn";
        stringArray[117] = "expect";
        stringArray[118] = "getCredentials";
        stringArray[119] = "replay";
        stringArray[120] = "<$constructor$>";
        stringArray[121] = "getAuthenticationInfo";
        stringArray[122] = "assertSame";
        stringArray[123] = "verify";
        stringArray[124] = "plus";
        stringArray[125] = "DEFAULT_AUTHENTICATION_CACHE_SUFFIX";
        stringArray[126] = "createStrictMock";
        stringArray[127] = "createStrictMock";
        stringArray[128] = "createStrictMock";
        stringArray[129] = "createStrictMock";
        stringArray[130] = "createStrictMock";
        stringArray[131] = "anyTimes";
        stringArray[132] = "andReturn";
        stringArray[133] = "expect";
        stringArray[134] = "isEmpty";
        stringArray[135] = "andReturn";
        stringArray[136] = "expect";
        stringArray[137] = "fromRealm";
        stringArray[138] = "eq";
        stringArray[139] = "andReturn";
        stringArray[140] = "expect";
        stringArray[141] = "getCache";
        stringArray[142] = "eq";
        stringArray[143] = "andReturn";
        stringArray[144] = "expect";
        stringArray[145] = "remove";
        stringArray[146] = "eq";
        stringArray[147] = "replay";
        stringArray[148] = "<$constructor$>";
        stringArray[149] = "onLogout";
        stringArray[150] = "verify";
        stringArray[151] = "<$constructor$>";
        stringArray[152] = "assertCredentialsMatch";
        stringArray[153] = "fail";
        stringArray[154] = "assertNotNull";
        stringArray[155] = "getMessage";
        stringArray[156] = "assertTrue";
        stringArray[157] = "contains";
        stringArray[158] = "getMessage";
        stringArray[159] = "createStrictMock";
        stringArray[160] = "createStrictMock";
        stringArray[161] = "createStrictMock";
        stringArray[162] = "andReturn";
        stringArray[163] = "expect";
        stringArray[164] = "doCredentialsMatch";
        stringArray[165] = "same";
        stringArray[166] = "same";
        stringArray[167] = "replay";
        stringArray[168] = "<$constructor$>";
        stringArray[169] = "assertCredentialsMatch";
        stringArray[170] = "fail";
        stringArray[171] = "verify";
        stringArray[172] = "length";
        stringArray[173] = "getAt";
        stringArray[174] = "length";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[175];
        AuthenticatingRealmTest.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(AuthenticatingRealmTest.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = AuthenticatingRealmTest.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    class TestAuthenticatingRealm
    extends AuthenticatingRealm
    implements GroovyObject {
        private AuthenticationInfo info;
        final /* synthetic */ AuthenticatingRealmTest this$0;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ SoftReference $callSiteArray;

        public TestAuthenticatingRealm(AuthenticatingRealmTest $p$) {
            MetaClass metaClass;
            AuthenticatingRealmTest authenticatingRealmTest;
            CallSite[] callSiteArray = TestAuthenticatingRealm.$getCallSiteArray();
            this.this$0 = authenticatingRealmTest = $p$;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public TestAuthenticatingRealm(AuthenticatingRealmTest $p$, CacheManager cacheManager) {
            MetaClass metaClass;
            AuthenticatingRealmTest authenticatingRealmTest;
            CallSite[] callSiteArray = TestAuthenticatingRealm.$getCallSiteArray();
            this.this$0 = authenticatingRealmTest = $p$;
            Object[] objectArray = new Object[]{cacheManager};
            TestAuthenticatingRealm testAuthenticatingRealm = this;
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, AuthenticatingRealm.class)) {
                case -414764352: {
                    Object[] objectArray2 = objectArray;
                    super((CacheManager)ScriptBytecodeAdapter.castToType((Object)objectArray[0], CacheManager.class));
                    break;
                }
                case 39797: {
                    Object[] objectArray2 = objectArray;
                    super();
                    break;
                }
                case 615307561: {
                    Object[] objectArray2 = objectArray;
                    super((CacheManager)ScriptBytecodeAdapter.castToType((Object)objectArray[0], CacheManager.class), (CredentialsMatcher)ScriptBytecodeAdapter.castToType((Object)objectArray[1], CredentialsMatcher.class));
                    break;
                }
                case 1407748126: {
                    Object[] objectArray2 = objectArray;
                    super((CredentialsMatcher)ScriptBytecodeAdapter.castToType((Object)objectArray[0], CredentialsMatcher.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public TestAuthenticatingRealm(AuthenticatingRealmTest $p$, CredentialsMatcher matcher) {
            MetaClass metaClass;
            AuthenticatingRealmTest authenticatingRealmTest;
            CallSite[] callSiteArray = TestAuthenticatingRealm.$getCallSiteArray();
            this.this$0 = authenticatingRealmTest = $p$;
            Object[] objectArray = new Object[]{matcher};
            TestAuthenticatingRealm testAuthenticatingRealm = this;
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, AuthenticatingRealm.class)) {
                case -414764352: {
                    Object[] objectArray2 = objectArray;
                    super((CacheManager)ScriptBytecodeAdapter.castToType((Object)objectArray[0], CacheManager.class));
                    break;
                }
                case 39797: {
                    Object[] objectArray2 = objectArray;
                    super();
                    break;
                }
                case 615307561: {
                    Object[] objectArray2 = objectArray;
                    super((CacheManager)ScriptBytecodeAdapter.castToType((Object)objectArray[0], CacheManager.class), (CredentialsMatcher)ScriptBytecodeAdapter.castToType((Object)objectArray[1], CredentialsMatcher.class));
                    break;
                }
                case 1407748126: {
                    Object[] objectArray2 = objectArray;
                    super((CredentialsMatcher)ScriptBytecodeAdapter.castToType((Object)objectArray[0], CredentialsMatcher.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public TestAuthenticatingRealm(AuthenticatingRealmTest $p$, CacheManager cacheManager, CredentialsMatcher matcher) {
            MetaClass metaClass;
            AuthenticatingRealmTest authenticatingRealmTest;
            CallSite[] callSiteArray = TestAuthenticatingRealm.$getCallSiteArray();
            this.this$0 = authenticatingRealmTest = $p$;
            super(cacheManager, matcher);
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) {
            CallSite[] callSiteArray = TestAuthenticatingRealm.$getCallSiteArray();
            return this.info;
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = TestAuthenticatingRealm.$getCallSiteArray();
            return this.this$0.this$dist$invoke$1(name, args);
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = TestAuthenticatingRealm.$getCallSiteArray();
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(TestAuthenticatingRealm.class, AuthenticatingRealmTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                    return ScriptBytecodeAdapter.invokeMethodN(TestAuthenticatingRealm.class, AuthenticatingRealmTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{callSiteArray[1].call((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (Object)0)});
                }
            } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[2].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                return ScriptBytecodeAdapter.invokeMethodN(TestAuthenticatingRealm.class, AuthenticatingRealmTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(TestAuthenticatingRealm.class, AuthenticatingRealmTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = TestAuthenticatingRealm.$getCallSiteArray();
            this.this$0.this$dist$set$1(name, val);
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = TestAuthenticatingRealm.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AuthenticatingRealmTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = TestAuthenticatingRealm.$getCallSiteArray();
            return this.this$0.this$dist$get$1(name);
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = TestAuthenticatingRealm.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(TestAuthenticatingRealm.class, AuthenticatingRealmTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != TestAuthenticatingRealm.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public AuthenticationInfo getInfo() {
            return this.info;
        }

        @Generated
        public void setInfo(AuthenticationInfo authenticationInfo) {
            this.info = authenticationInfo;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "length";
            stringArray[1] = "getAt";
            stringArray[2] = "length";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[3];
            TestAuthenticatingRealm.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(TestAuthenticatingRealm.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = TestAuthenticatingRealm.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    class NoLookupAuthenticatingRealm
    extends AuthenticatingRealm
    implements GroovyObject {
        final /* synthetic */ AuthenticatingRealmTest this$0;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ SoftReference $callSiteArray;

        @Generated
        public NoLookupAuthenticatingRealm(AuthenticatingRealmTest $p$) {
            MetaClass metaClass;
            AuthenticatingRealmTest authenticatingRealmTest;
            CallSite[] callSiteArray = NoLookupAuthenticatingRealm.$getCallSiteArray();
            this.this$0 = authenticatingRealmTest = $p$;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) {
            CallSite[] callSiteArray = NoLookupAuthenticatingRealm.$getCallSiteArray();
            callSiteArray[0].callStatic(Assert.class, (Object)"This implementation does not allow lookups.");
            return (AuthenticationInfo)ScriptBytecodeAdapter.castToType(null, AuthenticationInfo.class);
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = NoLookupAuthenticatingRealm.$getCallSiteArray();
            return this.this$0.this$dist$invoke$1(name, args);
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = NoLookupAuthenticatingRealm.$getCallSiteArray();
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(NoLookupAuthenticatingRealm.class, AuthenticatingRealmTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[1].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                    return ScriptBytecodeAdapter.invokeMethodN(NoLookupAuthenticatingRealm.class, AuthenticatingRealmTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{callSiteArray[2].call((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (Object)0)});
                }
            } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[3].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                return ScriptBytecodeAdapter.invokeMethodN(NoLookupAuthenticatingRealm.class, AuthenticatingRealmTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(NoLookupAuthenticatingRealm.class, AuthenticatingRealmTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = NoLookupAuthenticatingRealm.$getCallSiteArray();
            this.this$0.this$dist$set$1(name, val);
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = NoLookupAuthenticatingRealm.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AuthenticatingRealmTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = NoLookupAuthenticatingRealm.$getCallSiteArray();
            return this.this$0.this$dist$get$1(name);
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = NoLookupAuthenticatingRealm.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(NoLookupAuthenticatingRealm.class, AuthenticatingRealmTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != NoLookupAuthenticatingRealm.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "fail";
            stringArray[1] = "length";
            stringArray[2] = "getAt";
            stringArray[3] = "length";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[4];
            NoLookupAuthenticatingRealm.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(NoLookupAuthenticatingRealm.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = NoLookupAuthenticatingRealm.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

