/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.mgt;

import java.io.Serializable;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.UnavailableSecurityManagerException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.config.Ini;
import org.apache.shiro.mgt.AbstractSecurityManagerTest;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.realm.text.IniRealm;
import org.apache.shiro.session.ExpiredSessionException;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.support.DelegatingSubject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultSecurityManagerTest
extends AbstractSecurityManagerTest {
    DefaultSecurityManager sm = null;

    @Before
    public void setup() {
        this.sm = new DefaultSecurityManager();
        Ini ini = new Ini();
        Ini.Section section = ini.addSection("users");
        section.put("guest", "guest, guest");
        section.put("lonestarr", "vespa, goodguy");
        this.sm.setRealm((Realm)new IniRealm(ini));
        SecurityUtils.setSecurityManager((SecurityManager)this.sm);
    }

    @Override
    @After
    public void tearDown() {
        SecurityUtils.setSecurityManager(null);
        this.sm.destroy();
        super.tearDown();
    }

    @Test
    public void testDefaultConfig() {
        Subject subject = SecurityUtils.getSubject();
        UsernamePasswordToken token = new UsernamePasswordToken("guest", "guest");
        subject.login((AuthenticationToken)token);
        Assert.assertTrue((boolean)subject.isAuthenticated());
        Assert.assertTrue((boolean)"guest".equals(subject.getPrincipal()));
        Assert.assertTrue((boolean)subject.hasRole("guest"));
        Session session = subject.getSession();
        session.setAttribute((Object)"key", (Object)"value");
        Assert.assertEquals((Object)session.getAttribute((Object)"key"), (Object)"value");
        subject.logout();
        Assert.assertNull((Object)subject.getSession(false));
        Assert.assertNull((Object)subject.getPrincipal());
        Assert.assertNull((Object)subject.getPrincipals());
    }

    @Test
    public void testAutoCreateSessionAfterInvalidation() {
        Subject subject = SecurityUtils.getSubject();
        Session session = subject.getSession();
        Serializable origSessionId = session.getId();
        String key = "foo";
        String value1 = "bar";
        session.setAttribute((Object)key, (Object)value1);
        Assert.assertEquals((Object)value1, (Object)session.getAttribute((Object)key));
        session.setTimeout(50L);
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            session.setTimeout(1800000L);
            Assert.fail((String)"Session should have expired.");
        }
        catch (ExpiredSessionException expiredSessionException) {
            // empty catch block
        }
    }

    @Test
    public void testSubjectReuseAfterLogout() {
        Subject subject = SecurityUtils.getSubject();
        UsernamePasswordToken token = new UsernamePasswordToken("guest", "guest");
        subject.login((AuthenticationToken)token);
        Assert.assertTrue((boolean)subject.isAuthenticated());
        Assert.assertTrue((boolean)"guest".equals(subject.getPrincipal()));
        Assert.assertTrue((boolean)subject.hasRole("guest"));
        Session session = subject.getSession();
        Serializable firstSessionId = session.getId();
        session.setAttribute((Object)"key", (Object)"value");
        Assert.assertEquals((Object)session.getAttribute((Object)"key"), (Object)"value");
        subject.logout();
        Assert.assertNull((Object)subject.getSession(false));
        Assert.assertNull((Object)subject.getPrincipal());
        Assert.assertNull((Object)subject.getPrincipals());
        subject.login((AuthenticationToken)new UsernamePasswordToken("lonestarr", "vespa"));
        Assert.assertTrue((boolean)subject.isAuthenticated());
        Assert.assertTrue((boolean)"lonestarr".equals(subject.getPrincipal()));
        Assert.assertTrue((boolean)subject.hasRole("goodguy"));
        Assert.assertNotNull((Object)subject.getSession());
        Assert.assertFalse((boolean)firstSessionId.equals(subject.getSession().getId()));
        subject.logout();
        Assert.assertNull((Object)subject.getSession(false));
        Assert.assertNull((Object)subject.getPrincipal());
        Assert.assertNull((Object)subject.getPrincipals());
    }

    @Test
    public void testNewSubjectWithoutThreadSecurityManager() {
        SecurityUtils.setSecurityManager(null);
        try {
            SecurityUtils.getSecurityManager();
        }
        catch (UnavailableSecurityManagerException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("No SecurityManager accessible"));
        }
        DelegatingSubject subject = (DelegatingSubject)new Subject.Builder((SecurityManager)this.sm).buildSubject();
        UsernamePasswordToken token = new UsernamePasswordToken("guest", "guest");
        subject.login((AuthenticationToken)token);
        Assert.assertEquals((Object)this.sm, (Object)subject.getSecurityManager());
    }
}

