/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.config;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.lang.ref.SoftReference;
import java.util.Collection;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.MapCache;
import org.apache.shiro.config.HashMapCacheManager;
import org.apache.shiro.config.Ini;
import org.apache.shiro.config.IniSecurityManagerFactory;
import org.apache.shiro.config.MockPermissionResolver;
import org.apache.shiro.crypto.hash.Sha256Hash;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.realm.text.IniRealm;
import org.apache.shiro.realm.text.PropertiesRealm;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.AbstractSessionManager;
import org.apache.shiro.session.mgt.DefaultSessionManager;
import org.apache.shiro.session.mgt.eis.CachingSessionDAO;
import org.apache.shiro.session.mgt.eis.EnterpriseCacheSessionDAO;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.apache.shiro.subject.Subject;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.junit.Assert;
import org.junit.Test;

public class IniSecurityManagerFactoryTest
implements GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public IniSecurityManagerFactoryTest() {
        MetaClass metaClass;
        CallSite[] callSiteArray = IniSecurityManagerFactoryTest.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Test
    public void testGetInstanceWithoutIni() {
        CallSite[] callSiteArray = IniSecurityManagerFactoryTest.$getCallSiteArray();
        IniSecurityManagerFactory factory = (IniSecurityManagerFactory)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callConstructor(IniSecurityManagerFactory.class), IniSecurityManagerFactory.class);
        SecurityManager sm = (SecurityManager)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].call((Object)factory), SecurityManager.class);
        callSiteArray[2].callStatic(Assert.class, (Object)sm);
        callSiteArray[3].callStatic(Assert.class, (Object)(sm instanceof DefaultSecurityManager));
    }

    @Test
    public void testGetInstanceWithResourcePath() {
        CallSite[] callSiteArray = IniSecurityManagerFactoryTest.$getCallSiteArray();
        String path = "classpath:org/apache/shiro/config/IniSecurityManagerFactoryTest.ini";
        IniSecurityManagerFactory factory = (IniSecurityManagerFactory)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].callConstructor(IniSecurityManagerFactory.class, (Object)path), IniSecurityManagerFactory.class);
        SecurityManager sm = (SecurityManager)ScriptBytecodeAdapter.castToType((Object)callSiteArray[5].call((Object)factory), SecurityManager.class);
        callSiteArray[6].callStatic(Assert.class, (Object)sm);
        callSiteArray[7].callStatic(Assert.class, (Object)(sm instanceof DefaultSecurityManager));
    }

    @Test
    public void testGetInstanceWithEmptyIni() {
        CallSite[] callSiteArray = IniSecurityManagerFactoryTest.$getCallSiteArray();
        Ini ini = (Ini)ScriptBytecodeAdapter.castToType((Object)callSiteArray[8].callConstructor(Ini.class), Ini.class);
        IniSecurityManagerFactory factory = (IniSecurityManagerFactory)ScriptBytecodeAdapter.castToType((Object)callSiteArray[9].callConstructor(IniSecurityManagerFactory.class, (Object)ini), IniSecurityManagerFactory.class);
        SecurityManager sm = (SecurityManager)ScriptBytecodeAdapter.castToType((Object)callSiteArray[10].call((Object)factory), SecurityManager.class);
        callSiteArray[11].callStatic(Assert.class, (Object)sm);
        callSiteArray[12].callStatic(Assert.class, (Object)(sm instanceof DefaultSecurityManager));
    }

    @Test
    public void testGetInstanceWithSimpleIni() {
        CallSite[] callSiteArray = IniSecurityManagerFactoryTest.$getCallSiteArray();
        Ini ini = (Ini)ScriptBytecodeAdapter.castToType((Object)callSiteArray[13].callConstructor(Ini.class), Ini.class);
        callSiteArray[14].call((Object)ini, callSiteArray[15].callGetProperty(IniSecurityManagerFactory.class), (Object)"securityManager.sessionManager.globalSessionTimeout", (Object)"5000");
        IniSecurityManagerFactory factory = (IniSecurityManagerFactory)ScriptBytecodeAdapter.castToType((Object)callSiteArray[16].callConstructor(IniSecurityManagerFactory.class, (Object)ini), IniSecurityManagerFactory.class);
        SecurityManager sm = (SecurityManager)ScriptBytecodeAdapter.castToType((Object)callSiteArray[17].call((Object)factory), SecurityManager.class);
        callSiteArray[18].callStatic(Assert.class, (Object)sm);
        callSiteArray[19].callStatic(Assert.class, (Object)(sm instanceof DefaultSecurityManager));
        callSiteArray[20].callStatic(Assert.class, (Object)5000, callSiteArray[21].call((Object)((AbstractSessionManager)ScriptBytecodeAdapter.castToType((Object)callSiteArray[22].call((Object)((DefaultSecurityManager)ScriptBytecodeAdapter.castToType((Object)sm, DefaultSecurityManager.class))), AbstractSessionManager.class))));
    }

    @Test
    public void testGetInstanceWithConfiguredRealm() {
        CallSite[] callSiteArray = IniSecurityManagerFactoryTest.$getCallSiteArray();
        Ini ini = (Ini)ScriptBytecodeAdapter.castToType((Object)callSiteArray[23].callConstructor(Ini.class), Ini.class);
        Ini.Section section = (Ini.Section)ScriptBytecodeAdapter.castToType((Object)callSiteArray[24].call((Object)ini, callSiteArray[25].callGetProperty(IniSecurityManagerFactory.class)), Ini.Section.class);
        callSiteArray[26].call((Object)section, (Object)"propsRealm", callSiteArray[27].call(PropertiesRealm.class));
        callSiteArray[28].call((Object)section, (Object)"propsRealm.resourcePath", (Object)"classpath:org/apache/shiro/config/IniSecurityManagerFactoryTest.propsRealm.properties");
        IniSecurityManagerFactory factory = (IniSecurityManagerFactory)ScriptBytecodeAdapter.castToType((Object)callSiteArray[29].callConstructor(IniSecurityManagerFactory.class, (Object)ini), IniSecurityManagerFactory.class);
        SecurityManager sm = (SecurityManager)ScriptBytecodeAdapter.castToType((Object)callSiteArray[30].call((Object)factory), SecurityManager.class);
        callSiteArray[31].callStatic(Assert.class, (Object)sm);
        callSiteArray[32].callStatic(Assert.class, (Object)(sm instanceof DefaultSecurityManager));
        Collection realms = (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[33].call((Object)((DefaultSecurityManager)ScriptBytecodeAdapter.castToType((Object)sm, DefaultSecurityManager.class))), Collection.class);
        callSiteArray[34].callStatic(Assert.class, (Object)1, callSiteArray[35].call((Object)realms));
        Realm realm = (Realm)ScriptBytecodeAdapter.castToType((Object)callSiteArray[36].call(callSiteArray[37].call((Object)realms)), Realm.class);
        callSiteArray[38].callStatic(Assert.class, (Object)(realm instanceof PropertiesRealm));
    }

    @Test
    public void testGetInstanceWithAutomaticallyCreatedIniRealm() {
        CallSite[] callSiteArray = IniSecurityManagerFactoryTest.$getCallSiteArray();
        Ini ini = (Ini)ScriptBytecodeAdapter.castToType((Object)callSiteArray[39].callConstructor(Ini.class), Ini.class);
        Ini.Section section = (Ini.Section)ScriptBytecodeAdapter.castToType((Object)callSiteArray[40].call((Object)ini, callSiteArray[41].callGetProperty(IniRealm.class)), Ini.Section.class);
        callSiteArray[42].call((Object)section, (Object)"admin", (Object)"admin");
        IniSecurityManagerFactory factory = (IniSecurityManagerFactory)ScriptBytecodeAdapter.castToType((Object)callSiteArray[43].callConstructor(IniSecurityManagerFactory.class, (Object)ini), IniSecurityManagerFactory.class);
        SecurityManager sm = (SecurityManager)ScriptBytecodeAdapter.castToType((Object)callSiteArray[44].call((Object)factory), SecurityManager.class);
        callSiteArray[45].callStatic(Assert.class, (Object)sm);
        callSiteArray[46].callStatic(Assert.class, (Object)(sm instanceof DefaultSecurityManager));
        Collection realms = (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[47].call((Object)((DefaultSecurityManager)ScriptBytecodeAdapter.castToType((Object)sm, DefaultSecurityManager.class))), Collection.class);
        callSiteArray[48].callStatic(Assert.class, (Object)1, callSiteArray[49].call((Object)realms));
        Realm realm = (Realm)ScriptBytecodeAdapter.castToType((Object)callSiteArray[50].call(callSiteArray[51].call((Object)realms)), Realm.class);
        callSiteArray[52].callStatic(Assert.class, (Object)(realm instanceof IniRealm));
        callSiteArray[53].callStatic(Assert.class, callSiteArray[54].call((Object)((IniRealm)ScriptBytecodeAdapter.castToType((Object)realm, IniRealm.class)), (Object)"admin"));
    }

    @Test
    public void testImplicitIniRealmWithAdditionalRealmConfiguration() {
        CallSite[] callSiteArray = IniSecurityManagerFactoryTest.$getCallSiteArray();
        Ini ini = (Ini)ScriptBytecodeAdapter.castToType((Object)callSiteArray[55].callConstructor(Ini.class), Ini.class);
        Ini.Section main = (Ini.Section)ScriptBytecodeAdapter.castToType((Object)callSiteArray[56].call((Object)ini, (Object)"main"), Ini.Section.class);
        callSiteArray[57].call((Object)main, (Object)"credentialsMatcher", (Object)"org.apache.shiro.authc.credential.Sha256CredentialsMatcher");
        callSiteArray[58].call((Object)main, (Object)"iniRealm.credentialsMatcher", (Object)"$credentialsMatcher");
        Ini.Section users = (Ini.Section)ScriptBytecodeAdapter.castToType((Object)callSiteArray[59].call((Object)ini, callSiteArray[60].callGetProperty(IniRealm.class)), Ini.Section.class);
        callSiteArray[61].call((Object)users, (Object)"admin", callSiteArray[62].call(callSiteArray[63].callConstructor(Sha256Hash.class, (Object)"secret")));
        IniSecurityManagerFactory factory = (IniSecurityManagerFactory)ScriptBytecodeAdapter.castToType((Object)callSiteArray[64].callConstructor(IniSecurityManagerFactory.class, (Object)ini), IniSecurityManagerFactory.class);
        SecurityManager sm = (SecurityManager)ScriptBytecodeAdapter.castToType((Object)callSiteArray[65].call((Object)factory), SecurityManager.class);
        Subject subject = (Subject)ScriptBytecodeAdapter.castToType((Object)callSiteArray[66].call(callSiteArray[67].callConstructor(Subject.Builder.class, (Object)sm)), Subject.class);
        callSiteArray[68].call((Object)subject, (Object)new Runnable(this){
            final /* synthetic */ IniSecurityManagerFactoryTest this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                MetaClass metaClass;
                IniSecurityManagerFactoryTest iniSecurityManagerFactoryTest;
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                this.this$0 = iniSecurityManagerFactoryTest = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public void run() {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                callSiteArray[0].call(callSiteArray[1].call(SecurityUtils.class), callSiteArray[2].callConstructor(UsernamePasswordToken.class, (Object)"admin", (Object)"secret"));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return this.this$0.this$dist$invoke$1(name, args);
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                if (!(args instanceof Object[])) {
                    return ScriptBytecodeAdapter.invokeMethodN(1.class, IniSecurityManagerFactoryTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
                }
                if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[3].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                        return ScriptBytecodeAdapter.invokeMethodN(1.class, IniSecurityManagerFactoryTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{callSiteArray[4].call((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (Object)0)});
                    }
                } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[5].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                    return ScriptBytecodeAdapter.invokeMethodN(1.class, IniSecurityManagerFactoryTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
                }
                return ScriptBytecodeAdapter.invokeMethodN(1.class, IniSecurityManagerFactoryTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                this.this$0.this$dist$set$1(name, val);
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, IniSecurityManagerFactoryTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return this.this$0.this$dist$get$1(name);
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.getProperty(1.class, IniSecurityManagerFactoryTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            @Generated
            @Internal
            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            @Generated
            @Internal
            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "login";
                stringArray[1] = "getSubject";
                stringArray[2] = "<$constructor$>";
                stringArray[3] = "length";
                stringArray[4] = "getAt";
                stringArray[5] = "length";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
        callSiteArray[69].callStatic(Assert.class, callSiteArray[70].call(callSiteArray[71].call((Object)subject), (Object)"admin"));
    }

    @Test
    public void testImplicitIniRealmWithConfiguredPermissionResolver() {
        CallSite[] callSiteArray = IniSecurityManagerFactoryTest.$getCallSiteArray();
        Object ini = callSiteArray[72].callConstructor(Ini.class);
        callSiteArray[73].call(ini, (Object)"\n            [main]\n            # The MockPermissionResolver is a peer class to this test class.\n            permissionResolver = org.apache.shiro.config.MockPermissionResolver\n            iniRealm.permissionResolver = $permissionResolver\n\n            [users]\n            jsmith = secret, author\n\n            [roles]\n            author = book:write\n        ");
        IniSecurityManagerFactory factory = (IniSecurityManagerFactory)ScriptBytecodeAdapter.castToType((Object)callSiteArray[74].callConstructor(IniSecurityManagerFactory.class, ini), IniSecurityManagerFactory.class);
        SecurityManager sm = (SecurityManager)ScriptBytecodeAdapter.castToType((Object)callSiteArray[75].callGetProperty((Object)factory), SecurityManager.class);
        Object realm = callSiteArray[76].call(callSiteArray[77].callGetProperty((Object)sm), (Object)0);
        callSiteArray[78].callStatic(Assert.class, realm);
        Object permResolver = callSiteArray[79].callGetProperty(realm);
        callSiteArray[80].callStatic(Assert.class, (Object)(permResolver instanceof MockPermissionResolver));
        callSiteArray[81].callStatic(Assert.class, callSiteArray[82].callGetProperty(permResolver));
    }

    @Test
    public void testCacheManagerConfigOrderOfOperations() {
        CallSite[] callSiteArray = IniSecurityManagerFactoryTest.$getCallSiteArray();
        Ini ini = (Ini)ScriptBytecodeAdapter.castToType((Object)callSiteArray[83].callConstructor(Ini.class), Ini.class);
        Ini.Section main = (Ini.Section)ScriptBytecodeAdapter.castToType((Object)callSiteArray[84].call((Object)ini, callSiteArray[85].callGetProperty(IniSecurityManagerFactory.class)), Ini.Section.class);
        callSiteArray[86].call((Object)main, (Object)"cacheManager", (Object)"org.apache.shiro.config.HashMapCacheManager");
        callSiteArray[87].call((Object)main, (Object)"sessionDAO", (Object)"org.apache.shiro.session.mgt.eis.EnterpriseCacheSessionDAO");
        callSiteArray[88].call((Object)main, (Object)"securityManager.sessionManager.sessionDAO", (Object)"$sessionDAO");
        callSiteArray[89].call((Object)main, (Object)"securityManager.cacheManager", (Object)"$cacheManager");
        callSiteArray[90].call((Object)ini, callSiteArray[91].callGetProperty(IniRealm.class), (Object)"admin", (Object)"admin");
        IniSecurityManagerFactory factory = (IniSecurityManagerFactory)ScriptBytecodeAdapter.castToType((Object)callSiteArray[92].callConstructor(IniSecurityManagerFactory.class, (Object)ini), IniSecurityManagerFactory.class);
        SecurityManager sm = (SecurityManager)ScriptBytecodeAdapter.castToType((Object)callSiteArray[93].call((Object)factory), SecurityManager.class);
        Subject subject = (Subject)ScriptBytecodeAdapter.castToType((Object)callSiteArray[94].call(callSiteArray[95].callConstructor(Subject.Builder.class, (Object)sm)), Subject.class);
        callSiteArray[96].call((Object)subject, callSiteArray[97].callConstructor(UsernamePasswordToken.class, (Object)"admin", (Object)"admin"));
        Session session = (Session)ScriptBytecodeAdapter.castToType((Object)callSiteArray[98].call((Object)subject), Session.class);
        callSiteArray[99].call((Object)session, (Object)"hello", (Object)"world");
        SessionDAO sessionDAO = (SessionDAO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[100].call((Object)((DefaultSessionManager)ScriptBytecodeAdapter.castToType((Object)callSiteArray[101].call((Object)((DefaultSecurityManager)ScriptBytecodeAdapter.castToType((Object)sm, DefaultSecurityManager.class))), DefaultSessionManager.class))), SessionDAO.class);
        callSiteArray[102].callStatic(Assert.class, (Object)(sessionDAO instanceof EnterpriseCacheSessionDAO));
        CachingSessionDAO cachingSessionDAO = (CachingSessionDAO)ScriptBytecodeAdapter.castToType((Object)sessionDAO, CachingSessionDAO.class);
        Cache activeSessionsCache = (Cache)ScriptBytecodeAdapter.castToType((Object)callSiteArray[103].call((Object)cachingSessionDAO), Cache.class);
        callSiteArray[104].callStatic(Assert.class, (Object)(activeSessionsCache instanceof MapCache));
        MapCache mapCache = (MapCache)ScriptBytecodeAdapter.castToType((Object)activeSessionsCache, MapCache.class);
        callSiteArray[105].callStatic(Assert.class, (Object)(mapCache instanceof HashMapCacheManager.HashMapCache));
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        CallSite[] callSiteArray = IniSecurityManagerFactoryTest.$getCallSiteArray();
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(IniSecurityManagerFactoryTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
        }
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[106].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                return ScriptBytecodeAdapter.invokeMethodOnCurrentN(IniSecurityManagerFactoryTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{callSiteArray[107].call((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (Object)0)});
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[108].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(IniSecurityManagerFactoryTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(IniSecurityManagerFactoryTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        CallSite[] callSiteArray = IniSecurityManagerFactoryTest.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, IniSecurityManagerFactoryTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        CallSite[] callSiteArray = IniSecurityManagerFactoryTest.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(IniSecurityManagerFactoryTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != IniSecurityManagerFactoryTest.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "getInstance";
        stringArray[2] = "assertNotNull";
        stringArray[3] = "assertTrue";
        stringArray[4] = "<$constructor$>";
        stringArray[5] = "getInstance";
        stringArray[6] = "assertNotNull";
        stringArray[7] = "assertTrue";
        stringArray[8] = "<$constructor$>";
        stringArray[9] = "<$constructor$>";
        stringArray[10] = "getInstance";
        stringArray[11] = "assertNotNull";
        stringArray[12] = "assertTrue";
        stringArray[13] = "<$constructor$>";
        stringArray[14] = "setSectionProperty";
        stringArray[15] = "MAIN_SECTION_NAME";
        stringArray[16] = "<$constructor$>";
        stringArray[17] = "getInstance";
        stringArray[18] = "assertNotNull";
        stringArray[19] = "assertTrue";
        stringArray[20] = "assertEquals";
        stringArray[21] = "getGlobalSessionTimeout";
        stringArray[22] = "getSessionManager";
        stringArray[23] = "<$constructor$>";
        stringArray[24] = "addSection";
        stringArray[25] = "MAIN_SECTION_NAME";
        stringArray[26] = "put";
        stringArray[27] = "getName";
        stringArray[28] = "put";
        stringArray[29] = "<$constructor$>";
        stringArray[30] = "getInstance";
        stringArray[31] = "assertNotNull";
        stringArray[32] = "assertTrue";
        stringArray[33] = "getRealms";
        stringArray[34] = "assertEquals";
        stringArray[35] = "size";
        stringArray[36] = "next";
        stringArray[37] = "iterator";
        stringArray[38] = "assertTrue";
        stringArray[39] = "<$constructor$>";
        stringArray[40] = "addSection";
        stringArray[41] = "USERS_SECTION_NAME";
        stringArray[42] = "put";
        stringArray[43] = "<$constructor$>";
        stringArray[44] = "getInstance";
        stringArray[45] = "assertNotNull";
        stringArray[46] = "assertTrue";
        stringArray[47] = "getRealms";
        stringArray[48] = "assertEquals";
        stringArray[49] = "size";
        stringArray[50] = "next";
        stringArray[51] = "iterator";
        stringArray[52] = "assertTrue";
        stringArray[53] = "assertTrue";
        stringArray[54] = "accountExists";
        stringArray[55] = "<$constructor$>";
        stringArray[56] = "addSection";
        stringArray[57] = "put";
        stringArray[58] = "put";
        stringArray[59] = "addSection";
        stringArray[60] = "USERS_SECTION_NAME";
        stringArray[61] = "put";
        stringArray[62] = "toString";
        stringArray[63] = "<$constructor$>";
        stringArray[64] = "<$constructor$>";
        stringArray[65] = "getInstance";
        stringArray[66] = "buildSubject";
        stringArray[67] = "<$constructor$>";
        stringArray[68] = "execute";
        stringArray[69] = "assertTrue";
        stringArray[70] = "equals";
        stringArray[71] = "getPrincipal";
        stringArray[72] = "<$constructor$>";
        stringArray[73] = "load";
        stringArray[74] = "<$constructor$>";
        stringArray[75] = "instance";
        stringArray[76] = "getAt";
        stringArray[77] = "realms";
        stringArray[78] = "assertNotNull";
        stringArray[79] = "permissionResolver";
        stringArray[80] = "assertTrue";
        stringArray[81] = "assertTrue";
        stringArray[82] = "invoked";
        stringArray[83] = "<$constructor$>";
        stringArray[84] = "addSection";
        stringArray[85] = "MAIN_SECTION_NAME";
        stringArray[86] = "put";
        stringArray[87] = "put";
        stringArray[88] = "put";
        stringArray[89] = "put";
        stringArray[90] = "setSectionProperty";
        stringArray[91] = "USERS_SECTION_NAME";
        stringArray[92] = "<$constructor$>";
        stringArray[93] = "getInstance";
        stringArray[94] = "buildSubject";
        stringArray[95] = "<$constructor$>";
        stringArray[96] = "login";
        stringArray[97] = "<$constructor$>";
        stringArray[98] = "getSession";
        stringArray[99] = "setAttribute";
        stringArray[100] = "getSessionDAO";
        stringArray[101] = "getSessionManager";
        stringArray[102] = "assertTrue";
        stringArray[103] = "getActiveSessionsCache";
        stringArray[104] = "assertTrue";
        stringArray[105] = "assertTrue";
        stringArray[106] = "length";
        stringArray[107] = "getAt";
        stringArray[108] = "length";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[109];
        IniSecurityManagerFactoryTest.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(IniSecurityManagerFactoryTest.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = IniSecurityManagerFactoryTest.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

