/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.authz.permission;

import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.permission.WildcardPermission;
import org.junit.Assert;
import org.junit.Test;

public class WildcardPermissionTest {
    @Test(expected=IllegalArgumentException.class)
    public void testNull() {
        new WildcardPermission(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmpty() {
        new WildcardPermission("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBlank() {
        new WildcardPermission("   ");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOnlyDelimiters() {
        new WildcardPermission("::,,::,:");
    }

    @Test
    public void testNamed() {
        WildcardPermission p1 = new WildcardPermission("something");
        WildcardPermission p2 = new WildcardPermission("something");
        Assert.assertTrue((boolean)p1.implies((Permission)p2));
        Assert.assertTrue((boolean)p2.implies((Permission)p1));
        p1 = new WildcardPermission("something");
        p2 = new WildcardPermission("SOMETHING");
        Assert.assertTrue((boolean)p1.implies((Permission)p2));
        Assert.assertTrue((boolean)p2.implies((Permission)p1));
        p1 = new WildcardPermission("something");
        p2 = new WildcardPermission("else");
        Assert.assertFalse((boolean)p1.implies((Permission)p2));
        Assert.assertFalse((boolean)p2.implies((Permission)p1));
        p1 = new WildcardPermission("BLAHBLAH", false);
        p2 = new WildcardPermission("BLAHBLAH", false);
        Assert.assertTrue((boolean)p1.implies((Permission)p2));
        Assert.assertTrue((boolean)p2.implies((Permission)p1));
        p1 = new WildcardPermission("BLAHBLAH", false);
        p2 = new WildcardPermission("bLAHBLAH", false);
        Assert.assertTrue((boolean)p1.implies((Permission)p2));
        Assert.assertTrue((boolean)p2.implies((Permission)p1));
        p1 = new WildcardPermission("BLAHBLAH", false);
        p2 = new WildcardPermission("whatwhat", false);
        Assert.assertFalse((boolean)p1.implies((Permission)p2));
        Assert.assertFalse((boolean)p2.implies((Permission)p1));
    }

    @Test
    public void testLists() {
        WildcardPermission p1 = new WildcardPermission("one,two");
        WildcardPermission p2 = new WildcardPermission("one");
        Assert.assertTrue((boolean)p1.implies((Permission)p2));
        Assert.assertFalse((boolean)p2.implies((Permission)p1));
        p1 = new WildcardPermission("one,two,three");
        p2 = new WildcardPermission("one,three");
        Assert.assertTrue((boolean)p1.implies((Permission)p2));
        Assert.assertFalse((boolean)p2.implies((Permission)p1));
        p1 = new WildcardPermission("one,two:one,two,three");
        p2 = new WildcardPermission("one:three");
        WildcardPermission p3 = new WildcardPermission("one:two,three");
        Assert.assertTrue((boolean)p1.implies((Permission)p2));
        Assert.assertFalse((boolean)p2.implies((Permission)p1));
        Assert.assertTrue((boolean)p1.implies((Permission)p3));
        Assert.assertFalse((boolean)p2.implies((Permission)p3));
        Assert.assertTrue((boolean)p3.implies((Permission)p2));
        p1 = new WildcardPermission("one,two,three:one,two,three:one,two");
        p2 = new WildcardPermission("one:three:two");
        Assert.assertTrue((boolean)p1.implies((Permission)p2));
        Assert.assertFalse((boolean)p2.implies((Permission)p1));
        p1 = new WildcardPermission("one");
        p2 = new WildcardPermission("one:two,three,four");
        p3 = new WildcardPermission("one:two,three,four:five:six:seven");
        Assert.assertTrue((boolean)p1.implies((Permission)p2));
        Assert.assertTrue((boolean)p1.implies((Permission)p3));
        Assert.assertFalse((boolean)p2.implies((Permission)p1));
        Assert.assertFalse((boolean)p3.implies((Permission)p1));
        Assert.assertTrue((boolean)p2.implies((Permission)p3));
    }

    @Test
    public void testListDifferentOrder() {
        WildcardPermission p6 = new WildcardPermission("one,two:three,four");
        WildcardPermission p6DiffOrder = new WildcardPermission("two,one:four,three");
        Assert.assertTrue((boolean)p6.equals((Object)p6DiffOrder));
    }

    @Test
    public void testWildcards() {
        WildcardPermission p1 = new WildcardPermission("*");
        WildcardPermission p2 = new WildcardPermission("one");
        WildcardPermission p3 = new WildcardPermission("one:two");
        WildcardPermission p4 = new WildcardPermission("one,two:three,four");
        WildcardPermission p5 = new WildcardPermission("one,two:three,four,five:six:seven,eight");
        Assert.assertTrue((boolean)p1.implies((Permission)p2));
        Assert.assertTrue((boolean)p1.implies((Permission)p3));
        Assert.assertTrue((boolean)p1.implies((Permission)p4));
        Assert.assertTrue((boolean)p1.implies((Permission)p5));
        p1 = new WildcardPermission("newsletter:*");
        p2 = new WildcardPermission("newsletter:read");
        p3 = new WildcardPermission("newsletter:read,write");
        p4 = new WildcardPermission("newsletter:*");
        p5 = new WildcardPermission("newsletter:*:*");
        WildcardPermission p6 = new WildcardPermission("newsletter:*:read");
        WildcardPermission p7 = new WildcardPermission("newsletter:write:*");
        WildcardPermission p8 = new WildcardPermission("newsletter:read,write:*");
        WildcardPermission p9 = new WildcardPermission("newsletter");
        Assert.assertTrue((boolean)p1.implies((Permission)p2));
        Assert.assertTrue((boolean)p1.implies((Permission)p3));
        Assert.assertTrue((boolean)p1.implies((Permission)p4));
        Assert.assertTrue((boolean)p1.implies((Permission)p5));
        Assert.assertTrue((boolean)p1.implies((Permission)p6));
        Assert.assertTrue((boolean)p1.implies((Permission)p7));
        Assert.assertTrue((boolean)p1.implies((Permission)p8));
        Assert.assertTrue((boolean)p1.implies((Permission)p9));
        p1 = new WildcardPermission("newsletter:*:*");
        Assert.assertTrue((boolean)p1.implies((Permission)p2));
        Assert.assertTrue((boolean)p1.implies((Permission)p3));
        Assert.assertTrue((boolean)p1.implies((Permission)p4));
        Assert.assertTrue((boolean)p1.implies((Permission)p5));
        Assert.assertTrue((boolean)p1.implies((Permission)p6));
        Assert.assertTrue((boolean)p1.implies((Permission)p7));
        Assert.assertTrue((boolean)p1.implies((Permission)p8));
        Assert.assertTrue((boolean)p1.implies((Permission)p9));
        p1 = new WildcardPermission("newsletter:*:*:*");
        Assert.assertTrue((boolean)p1.implies((Permission)p2));
        Assert.assertTrue((boolean)p1.implies((Permission)p3));
        Assert.assertTrue((boolean)p1.implies((Permission)p4));
        Assert.assertTrue((boolean)p1.implies((Permission)p5));
        Assert.assertTrue((boolean)p1.implies((Permission)p6));
        Assert.assertTrue((boolean)p1.implies((Permission)p7));
        Assert.assertTrue((boolean)p1.implies((Permission)p8));
        Assert.assertTrue((boolean)p1.implies((Permission)p9));
        p1 = new WildcardPermission("newsletter");
        Assert.assertTrue((boolean)p1.implies((Permission)p2));
        Assert.assertTrue((boolean)p1.implies((Permission)p3));
        Assert.assertTrue((boolean)p1.implies((Permission)p4));
        Assert.assertTrue((boolean)p1.implies((Permission)p5));
        Assert.assertTrue((boolean)p1.implies((Permission)p6));
        Assert.assertTrue((boolean)p1.implies((Permission)p7));
        Assert.assertTrue((boolean)p1.implies((Permission)p8));
        Assert.assertTrue((boolean)p1.implies((Permission)p9));
        p1 = new WildcardPermission("newsletter:*:read");
        p2 = new WildcardPermission("newsletter:123:read");
        p3 = new WildcardPermission("newsletter:123,456:read,write");
        p4 = new WildcardPermission("newsletter:read");
        p5 = new WildcardPermission("newsletter:read,write");
        p6 = new WildcardPermission("newsletter:123:read:write");
        Assert.assertTrue((boolean)p1.implies((Permission)p2));
        Assert.assertFalse((boolean)p1.implies((Permission)p3));
        Assert.assertFalse((boolean)p1.implies((Permission)p4));
        Assert.assertFalse((boolean)p1.implies((Permission)p5));
        Assert.assertTrue((boolean)p1.implies((Permission)p6));
        p1 = new WildcardPermission("newsletter:*:read:*");
        Assert.assertTrue((boolean)p1.implies((Permission)p2));
        Assert.assertTrue((boolean)p1.implies((Permission)p6));
    }

    @Test
    public void testToString() {
        WildcardPermission p1 = new WildcardPermission("*");
        WildcardPermission p2 = new WildcardPermission("one");
        WildcardPermission p3 = new WildcardPermission("one:two");
        WildcardPermission p4 = new WildcardPermission("one,two:three,four");
        WildcardPermission p5 = new WildcardPermission("one,two:three,four,five:six:seven,eight");
        Assert.assertTrue((boolean)"*".equals(p1.toString()));
        Assert.assertTrue((boolean)p1.equals((Object)new WildcardPermission(p1.toString())));
        Assert.assertTrue((boolean)"one".equals(p2.toString()));
        Assert.assertTrue((boolean)p2.equals((Object)new WildcardPermission(p2.toString())));
        Assert.assertTrue((boolean)"one:two".equals(p3.toString()));
        Assert.assertTrue((boolean)p3.equals((Object)new WildcardPermission(p3.toString())));
        Assert.assertTrue((boolean)"one,two:three,four".equals(p4.toString()));
        Assert.assertTrue((boolean)p4.equals((Object)new WildcardPermission(p4.toString())));
        Assert.assertTrue((boolean)"one,two:three,four,five:six:seven,eight".equals(p5.toString()));
        Assert.assertTrue((boolean)p5.equals((Object)new WildcardPermission(p5.toString())));
    }

    @Test
    public void testWildcardLeftTermination() {
        WildcardPermission p1 = new WildcardPermission("one");
        WildcardPermission p2 = new WildcardPermission("one:*");
        WildcardPermission p3 = new WildcardPermission("one:*:*");
        WildcardPermission p4 = new WildcardPermission("one:read");
        Assert.assertTrue((boolean)p1.implies((Permission)p2));
        Assert.assertTrue((boolean)p1.implies((Permission)p3));
        Assert.assertTrue((boolean)p1.implies((Permission)p4));
        Assert.assertTrue((boolean)p2.implies((Permission)p1));
        Assert.assertTrue((boolean)p2.implies((Permission)p3));
        Assert.assertTrue((boolean)p2.implies((Permission)p4));
        Assert.assertTrue((boolean)p3.implies((Permission)p1));
        Assert.assertTrue((boolean)p3.implies((Permission)p2));
        Assert.assertTrue((boolean)p3.implies((Permission)p4));
        Assert.assertFalse((boolean)p4.implies((Permission)p1));
        Assert.assertFalse((boolean)p4.implies((Permission)p2));
        Assert.assertFalse((boolean)p4.implies((Permission)p3));
    }
}

