/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.authz.permission;

import org.apache.shiro.authz.permission.WildcardPermission;
import org.apache.shiro.authz.permission.WildcardPermissionResolver;
import org.junit.Assert;
import org.junit.Test;

public class WildcardPermissionResolverTest {
    @Test
    public void testDefaultIsNonCaseSensitive() {
        WildcardPermissionResolver resolver = new WildcardPermissionResolver();
        Assert.assertFalse((String)"Default sensitivity should be false", (boolean)resolver.isCaseSensitive());
        WildcardPermission permission = (WildcardPermission)resolver.resolvePermission("Foo:*");
        Assert.assertEquals((String)"string should be lowercase", (Object)"foo:*", (Object)permission.toString());
    }

    @Test
    public void testCaseSensitive() {
        WildcardPermissionResolver resolver = new WildcardPermissionResolver(true);
        Assert.assertTrue((String)"Sensitivity should be true", (boolean)resolver.isCaseSensitive());
        WildcardPermission permission = (WildcardPermission)resolver.resolvePermission("Foo:*");
        Assert.assertEquals((String)"string should be mixed case", (Object)"Foo:*", (Object)permission.toString());
    }

    @Test
    public void testCaseInsensitive() {
        WildcardPermissionResolver resolver = new WildcardPermissionResolver(false);
        Assert.assertFalse((String)"Sensitivity should be false", (boolean)resolver.isCaseSensitive());
        WildcardPermission permission = (WildcardPermission)resolver.resolvePermission("Foo:*");
        Assert.assertEquals((String)"string should be lowercase", (Object)"foo:*", (Object)permission.toString());
    }

    @Test
    public void testCaseSensitiveToggle() {
        WildcardPermissionResolver resolver = new WildcardPermissionResolver();
        Assert.assertFalse((String)"Default sensitivity should be false", (boolean)resolver.isCaseSensitive());
        resolver.setCaseSensitive(true);
        Assert.assertTrue((String)"Sensitivity should be true", (boolean)resolver.isCaseSensitive());
        resolver.setCaseSensitive(false);
        Assert.assertFalse((String)"Sensitivity should be false", (boolean)resolver.isCaseSensitive());
    }
}

