/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.authz.permission;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.shiro.authz.permission.DomainPermission;
import org.junit.Assert;
import org.junit.Test;

public class DomainPermissionTest {
    @Test
    public void testDefaultConstructor() {
        DomainPermission p = new DomainPermission();
        Assert.assertTrue((boolean)"domain".equals(p.getDomain()));
        Set set = p.getActions();
        Assert.assertNull((Object)set);
        set = p.getTargets();
        Assert.assertNull((Object)set);
        List parts = p.getParts();
        Assert.assertEquals((String)"Number of parts", (long)1L, (long)parts.size());
        set = (Set)parts.get(0);
        Assert.assertEquals((long)1L, (long)set.size());
        String entry = (String)set.iterator().next();
        Assert.assertEquals((Object)"domain", (Object)entry);
    }

    @Test
    public void testActionsConstructorWithSingleAction() {
        DomainPermission p = new DomainPermission("action1");
        Assert.assertEquals((Object)"domain", (Object)p.getDomain());
        Set set = p.getActions();
        Assert.assertNotNull((Object)set);
        Assert.assertEquals((long)1L, (long)set.size());
        Iterator iterator = set.iterator();
        String entry = (String)iterator.next();
        Assert.assertEquals((Object)"action1", (Object)entry);
        set = p.getTargets();
        Assert.assertNull((Object)set);
        List parts = p.getParts();
        Assert.assertEquals((long)2L, (long)parts.size());
        set = (Set)parts.get(0);
        Assert.assertEquals((long)1L, (long)set.size());
        iterator = set.iterator();
        entry = (String)iterator.next();
        Assert.assertEquals((Object)"domain", (Object)entry);
        set = (Set)parts.get(1);
        Assert.assertEquals((long)1L, (long)set.size());
        iterator = set.iterator();
        entry = (String)iterator.next();
        Assert.assertEquals((Object)"action1", (Object)entry);
    }

    @Test
    public void testActionsConstructorWithMultipleActions() {
        DomainPermission p = new DomainPermission("action1,action2,action3");
        Assert.assertEquals((Object)"domain", (Object)p.getDomain());
        Set set = p.getActions();
        Assert.assertNotNull((Object)set);
        Assert.assertEquals((long)3L, (long)set.size());
        Iterator iterator = set.iterator();
        String entry = (String)iterator.next();
        Assert.assertEquals((Object)"action1", (Object)entry);
        entry = (String)iterator.next();
        Assert.assertEquals((Object)"action2", (Object)entry);
        entry = (String)iterator.next();
        Assert.assertEquals((Object)"action3", (Object)entry);
        set = p.getTargets();
        Assert.assertNull((Object)set);
        List parts = p.getParts();
        Assert.assertEquals((long)2L, (long)parts.size());
        set = (Set)parts.get(0);
        Assert.assertEquals((long)1L, (long)set.size());
        iterator = set.iterator();
        entry = (String)iterator.next();
        Assert.assertEquals((Object)"domain", (Object)entry);
        set = (Set)parts.get(1);
        Assert.assertEquals((long)3L, (long)set.size());
        iterator = set.iterator();
        entry = (String)iterator.next();
        Assert.assertEquals((Object)"action1", (Object)entry);
        entry = (String)iterator.next();
        Assert.assertEquals((Object)"action2", (Object)entry);
        entry = (String)iterator.next();
        Assert.assertEquals((Object)"action3", (Object)entry);
    }

    @Test
    public void testActionsTargetsConstructorWithSingleActionAndTarget() {
        DomainPermission p = new DomainPermission("action1", "target1");
        Assert.assertEquals((Object)"domain", (Object)p.getDomain());
        Set set = p.getActions();
        Assert.assertNotNull((Object)set);
        Assert.assertEquals((long)1L, (long)set.size());
        Iterator iterator = set.iterator();
        String entry = (String)iterator.next();
        Assert.assertEquals((Object)"action1", (Object)entry);
        set = p.getTargets();
        Assert.assertNotNull((Object)set);
        Assert.assertEquals((long)1L, (long)set.size());
        iterator = set.iterator();
        entry = (String)iterator.next();
        Assert.assertEquals((Object)"target1", (Object)entry);
        List parts = p.getParts();
        Assert.assertEquals((long)3L, (long)parts.size());
        set = (Set)parts.get(0);
        Assert.assertEquals((long)1L, (long)set.size());
        iterator = set.iterator();
        entry = (String)iterator.next();
        Assert.assertEquals((Object)"domain", (Object)entry);
        set = (Set)parts.get(1);
        Assert.assertEquals((long)1L, (long)set.size());
        iterator = set.iterator();
        entry = (String)iterator.next();
        Assert.assertEquals((Object)"action1", (Object)entry);
        set = (Set)parts.get(2);
        Assert.assertEquals((long)1L, (long)set.size());
        iterator = set.iterator();
        entry = (String)iterator.next();
        Assert.assertEquals((Object)"target1", (Object)entry);
    }

    @Test
    public void testActionsTargetsConstructorWithMultipleActionsAndTargets() {
        DomainPermission p = new DomainPermission("action1,action2,action3", "target1,target2,target3");
        Assert.assertEquals((Object)"domain", (Object)p.getDomain());
        Set set = p.getActions();
        Assert.assertNotNull((Object)set);
        Assert.assertEquals((long)3L, (long)set.size());
        Iterator iterator = set.iterator();
        String entry = (String)iterator.next();
        Assert.assertEquals((Object)"action1", (Object)entry);
        entry = (String)iterator.next();
        Assert.assertEquals((Object)"action2", (Object)entry);
        entry = (String)iterator.next();
        Assert.assertEquals((Object)"action3", (Object)entry);
        set = p.getTargets();
        Assert.assertNotNull((Object)set);
        Assert.assertEquals((long)3L, (long)set.size());
        iterator = set.iterator();
        entry = (String)iterator.next();
        Assert.assertEquals((Object)"target1", (Object)entry);
        entry = (String)iterator.next();
        Assert.assertEquals((Object)"target2", (Object)entry);
        entry = (String)iterator.next();
        Assert.assertEquals((Object)"target3", (Object)entry);
        List parts = p.getParts();
        Assert.assertEquals((long)3L, (long)parts.size());
        set = (Set)parts.get(0);
        Assert.assertEquals((long)1L, (long)set.size());
        iterator = set.iterator();
        entry = (String)iterator.next();
        Assert.assertEquals((Object)"domain", (Object)entry);
        set = (Set)parts.get(1);
        Assert.assertEquals((long)3L, (long)set.size());
        iterator = set.iterator();
        entry = (String)iterator.next();
        Assert.assertEquals((Object)"action1", (Object)entry);
        entry = (String)iterator.next();
        Assert.assertEquals((Object)"action2", (Object)entry);
        entry = (String)iterator.next();
        Assert.assertEquals((Object)"action3", (Object)entry);
        set = (Set)parts.get(2);
        Assert.assertEquals((long)3L, (long)set.size());
        iterator = set.iterator();
        entry = (String)iterator.next();
        Assert.assertEquals((Object)"target1", (Object)entry);
        entry = (String)iterator.next();
        Assert.assertEquals((Object)"target2", (Object)entry);
        entry = (String)iterator.next();
        Assert.assertEquals((Object)"target3", (Object)entry);
    }
}

