/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.authc.pam;

import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.MergableAuthenticationInfo;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.pam.FirstSuccessfulStrategy;
import org.apache.shiro.authc.pam.ShortCircuitIterationException;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FirstSuccessfulStrategyTest {
    private FirstSuccessfulStrategy strategy;

    @Before
    public void setUp() {
        this.strategy = new FirstSuccessfulStrategy();
        this.strategy.setStopAfterFirstSuccess(true);
    }

    @Test
    public void beforeAllAttempts() {
        AuthenticationInfo authenticationInfo = this.strategy.beforeAllAttempts(null, null);
        Assert.assertNull((Object)authenticationInfo);
    }

    @Test
    public void testMergeWithValidAggregateInfo() {
        MergableAuthenticationInfo aggregate = new MergableAuthenticationInfo(){

            public void merge(AuthenticationInfo info) {
            }

            public PrincipalCollection getPrincipals() {
                return new SimplePrincipalCollection((Object)"principals", "realmName");
            }

            public Object getCredentials() {
                return null;
            }
        };
        AuthenticationInfo mergeResult = this.strategy.merge((AuthenticationInfo)new SimpleAuthenticationInfo(), (AuthenticationInfo)aggregate);
        Assert.assertEquals((Object)aggregate, (Object)mergeResult);
    }

    @Test
    public void testMergeWithInvalidAggregateInfo() {
        MergableAuthenticationInfo aggregate = new MergableAuthenticationInfo(){

            public void merge(AuthenticationInfo info) {
            }

            public PrincipalCollection getPrincipals() {
                return new SimplePrincipalCollection();
            }

            public Object getCredentials() {
                return null;
            }
        };
        SimpleAuthenticationInfo authInfo = new SimpleAuthenticationInfo();
        AuthenticationInfo mergeResult = this.strategy.merge((AuthenticationInfo)authInfo, (AuthenticationInfo)aggregate);
        Assert.assertEquals((Object)authInfo, (Object)mergeResult);
        AuthenticationInfo info = this.strategy.beforeAllAttempts(null, null);
        Assert.assertNull((Object)info);
    }

    @Test
    public void testBeforeAttemptNull() {
        Assert.assertNull((Object)this.strategy.beforeAttempt(null, null, null));
    }

    @Test
    public void testBeforeAttemptEmptyPrincipal() {
        SimpleAuthenticationInfo aggregate = new SimpleAuthenticationInfo();
        Assert.assertEquals((Object)this.strategy.beforeAttempt(null, null, (AuthenticationInfo)aggregate), (Object)aggregate);
    }

    @Test
    public void testBeforeAttemptEmptyList() {
        SimplePrincipalCollection principalCollection = new SimplePrincipalCollection();
        SimpleAuthenticationInfo aggregate = new SimpleAuthenticationInfo((PrincipalCollection)principalCollection, null);
        Assert.assertEquals((Object)this.strategy.beforeAttempt(null, null, (AuthenticationInfo)aggregate), (Object)aggregate);
    }

    @Test(expected=ShortCircuitIterationException.class)
    public void testBeforeAttemptStopAfterFirstSuccess() {
        SimpleAuthenticationInfo aggregate = new SimpleAuthenticationInfo((Object)"principal", null, "a-realm-name");
        this.strategy.beforeAttempt(null, null, (AuthenticationInfo)aggregate);
    }
}

