/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.authc.pam;

import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.pam.AllSuccessfulStrategy;
import org.apache.shiro.authc.pam.UnsupportedTokenException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.realm.SimpleAccountRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AllSuccessfulStrategyTest {
    private AllSuccessfulStrategy strategy;

    @Before
    public void setUp() {
        this.strategy = new AllSuccessfulStrategy();
    }

    @Test
    public void beforeAllAttempts() {
        AuthenticationInfo info = this.strategy.beforeAllAttempts(null, null);
        Assert.assertNotNull((Object)info);
    }

    @Test
    public void beforeAttemptSupportingToken() {
        new SimpleAccountRealm();
    }

    @Test(expected=UnsupportedTokenException.class)
    public void beforeAttemptRealmDoesntSupportToken() {
        AuthorizingRealm notSupportingRealm = new AuthorizingRealm(){

            public boolean supports(AuthenticationToken token) {
                return false;
            }

            protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
                return null;
            }

            protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principal) {
                return null;
            }
        };
        this.strategy.beforeAttempt((Realm)notSupportingRealm, null, null);
    }
}

