/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.authc.credential;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.lang.ref.SoftReference;
import java.util.Locale;
import org.apache.shiro.authc.credential.DefaultPasswordService;
import org.apache.shiro.authc.credential.PasswordService;
import org.apache.shiro.crypto.SecureRandomNumberGenerator;
import org.apache.shiro.crypto.hash.Hash;
import org.apache.shiro.crypto.hash.HashRequest;
import org.apache.shiro.crypto.hash.HashService;
import org.apache.shiro.crypto.hash.Sha1Hash;
import org.apache.shiro.crypto.hash.Sha256Hash;
import org.apache.shiro.crypto.hash.Sha512Hash;
import org.apache.shiro.crypto.hash.format.HashFormatFactory;
import org.apache.shiro.crypto.hash.format.HexFormat;
import org.apache.shiro.crypto.hash.format.Shiro1CryptFormat;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class DefaultPasswordServiceTest
implements GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public DefaultPasswordServiceTest() {
        MetaClass metaClass;
        CallSite[] callSiteArray = DefaultPasswordServiceTest.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Test
    public void testEncryptPasswordWithNullArgument() {
        CallSite[] callSiteArray = DefaultPasswordServiceTest.$getCallSiteArray();
        Object service = callSiteArray[0].callConstructor(DefaultPasswordService.class);
        callSiteArray[1].callStatic(Assert.class, callSiteArray[2].call(service, null));
    }

    @Test
    public void testHashPasswordWithNullArgument() {
        CallSite[] callSiteArray = DefaultPasswordServiceTest.$getCallSiteArray();
        Object service = callSiteArray[3].callConstructor(DefaultPasswordService.class);
        callSiteArray[4].callStatic(Assert.class, callSiteArray[5].call(service, null));
    }

    @Test
    public void testEncryptPasswordDefault() {
        CallSite[] callSiteArray = DefaultPasswordServiceTest.$getCallSiteArray();
        Object service = callSiteArray[6].callConstructor(DefaultPasswordService.class);
        Object encrypted = callSiteArray[7].call(service, (Object)"12345");
        callSiteArray[8].callStatic(Assert.class, callSiteArray[9].call(service, (Object)"12345", encrypted));
    }

    @Test
    public void testEncryptPasswordWithInvalidMatch() {
        CallSite[] callSiteArray = DefaultPasswordServiceTest.$getCallSiteArray();
        Object service = callSiteArray[10].callConstructor(DefaultPasswordService.class);
        Object encrypted = callSiteArray[11].call(service, (Object)"ABCDEF");
        callSiteArray[12].callStatic(Assert.class, callSiteArray[13].call(service, (Object)"ABC", encrypted));
    }

    @Test
    public void testBackwardsCompatibility() {
        CallSite[] callSiteArray = DefaultPasswordServiceTest.$getCallSiteArray();
        Object service = callSiteArray[14].callConstructor(DefaultPasswordService.class);
        Object encrypted = callSiteArray[15].call(service, (Object)"12345");
        String submitted = "12345";
        callSiteArray[16].callStatic(Assert.class, callSiteArray[17].call(service, (Object)submitted, encrypted));
        String string = "MD5";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)callSiteArray[18].callGetProperty(service), (String)"hashAlgorithmName");
        int n = 250000;
        ScriptBytecodeAdapter.setProperty((Object)n, null, (Object)callSiteArray[19].callGetProperty(service), (String)"hashIterations");
        Object encrypted2 = callSiteArray[20].call(service, (Object)submitted);
        callSiteArray[21].callStatic(Assert.class, (Object)ScriptBytecodeAdapter.compareEqual((Object)encrypted, (Object)encrypted2));
        callSiteArray[22].callStatic(Assert.class, callSiteArray[23].call(service, (Object)submitted, encrypted2));
    }

    @Test
    public void testHashFormatWarned() {
        CallSite[] callSiteArray = DefaultPasswordServiceTest.$getCallSiteArray();
        Object service = callSiteArray[24].callConstructor(DefaultPasswordService.class);
        Object object = callSiteArray[25].callConstructor(HexFormat.class);
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)service, (String)"hashFormat");
        callSiteArray[26].callStatic(Assert.class, (Object)(callSiteArray[27].callGetProperty(service) instanceof HexFormat));
        callSiteArray[28].call(service, (Object)"test");
        callSiteArray[29].callStatic(Assert.class, callSiteArray[30].callGetProperty(service));
    }

    @Test
    public void testPasswordsMatchWithNullOrEmpty() {
        CallSite[] callSiteArray = DefaultPasswordServiceTest.$getCallSiteArray();
        Object service = callSiteArray[31].callConstructor(DefaultPasswordService.class);
        callSiteArray[32].callStatic(Assert.class, callSiteArray[33].call(service, null, (Object)ScriptBytecodeAdapter.createPojoWrapper(null, String.class)));
        callSiteArray[34].callStatic(Assert.class, callSiteArray[35].call(service, null, (Object)ScriptBytecodeAdapter.createPojoWrapper(null, Hash.class)));
        callSiteArray[36].callStatic(Assert.class, callSiteArray[37].call(service, (Object)"", (Object)ScriptBytecodeAdapter.createPojoWrapper(null, String.class)));
        callSiteArray[38].callStatic(Assert.class, callSiteArray[39].call(service, null, (Object)""));
        callSiteArray[40].callStatic(Assert.class, callSiteArray[41].call(service, null, (Object)"12345"));
        callSiteArray[42].callStatic(Assert.class, callSiteArray[43].call(service, null, callSiteArray[44].callConstructor(Sha1Hash.class, (Object)"test")));
    }

    @Test
    public void testCustomHashService() {
        CallSite[] callSiteArray = DefaultPasswordServiceTest.$getCallSiteArray();
        Object hashService = callSiteArray[45].callStatic(EasyMock.class, HashService.class);
        Object hash = callSiteArray[46].callConstructor(Sha256Hash.class, (Object)"test", callSiteArray[47].call(callSiteArray[48].callConstructor(SecureRandomNumberGenerator.class)), (Object)100);
        callSiteArray[49].call(callSiteArray[50].callStatic(EasyMock.class, callSiteArray[51].call(hashService, callSiteArray[52].callStatic(EasyMock.class, HashRequest.class))), hash);
        callSiteArray[53].callStatic(EasyMock.class, hashService);
        Object service = callSiteArray[54].callConstructor(DefaultPasswordService.class);
        Object object = hashService;
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)service, (String)"hashService");
        Object returnedHash = callSiteArray[55].call(service, (Object)"test");
        callSiteArray[56].callStatic(Assert.class, callSiteArray[57].call(callSiteArray[58].callConstructor(Shiro1CryptFormat.class), hash), returnedHash);
        callSiteArray[59].callStatic(EasyMock.class, hashService);
    }

    @Test
    public void testCustomHashFormatFactory() {
        CallSite[] callSiteArray = DefaultPasswordServiceTest.$getCallSiteArray();
        Object factory = callSiteArray[60].callStatic(EasyMock.class, HashFormatFactory.class);
        Object hash = callSiteArray[61].callConstructor(Sha512Hash.class, (Object)"test", callSiteArray[62].call(callSiteArray[63].callConstructor(SecureRandomNumberGenerator.class)), (Object)100);
        String saved = ShortTypeHandling.castToString((Object)callSiteArray[64].call(callSiteArray[65].callConstructor(Shiro1CryptFormat.class), hash));
        callSiteArray[66].call(callSiteArray[67].callStatic(EasyMock.class, callSiteArray[68].call(factory, callSiteArray[69].callStatic(EasyMock.class, (Object)saved))), callSiteArray[70].callConstructor(Shiro1CryptFormat.class));
        callSiteArray[71].callStatic(EasyMock.class, factory);
        Object service = callSiteArray[72].callConstructor(DefaultPasswordService.class);
        Object object = factory;
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)service, (String)"hashFormatFactory");
        callSiteArray[73].callStatic(Assert.class, factory, callSiteArray[74].callGetProperty(service));
        callSiteArray[75].callStatic(Assert.class, callSiteArray[76].call(service, (Object)"test", (Object)saved));
        callSiteArray[77].callStatic(EasyMock.class, factory);
    }

    @Test
    public void testStringComparisonWhenNotUsingAParsableHashFormat() {
        CallSite[] callSiteArray = DefaultPasswordServiceTest.$getCallSiteArray();
        Object service = callSiteArray[78].callConstructor(DefaultPasswordService.class);
        Object object = callSiteArray[79].callConstructor(HexFormat.class);
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)service, (String)"hashFormat");
        boolean bl = false;
        ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)callSiteArray[80].callGetProperty(service), (String)"generatePublicSalt");
        Object formatted = callSiteArray[81].call(service, (Object)"12345");
        callSiteArray[82].callStatic(Assert.class, callSiteArray[83].call(service, (Object)"12345", formatted));
    }

    @Test
    public void testTurkishLocal() {
        CallSite[] callSiteArray = DefaultPasswordServiceTest.$getCallSiteArray();
        Locale locale = (Locale)ScriptBytecodeAdapter.castToType((Object)callSiteArray[84].call(Locale.class), Locale.class);
        callSiteArray[85].call(Locale.class, callSiteArray[86].callConstructor(Locale.class, (Object)"tr", (Object)"TR"));
        try {
            PasswordService passwordService = (PasswordService)ScriptBytecodeAdapter.castToType((Object)callSiteArray[87].callConstructor(DefaultPasswordService.class), PasswordService.class);
            String password = "333";
            String enc = ShortTypeHandling.castToString((Object)callSiteArray[88].call((Object)passwordService, (Object)password));
            callSiteArray[89].callStatic(Assert.class, callSiteArray[90].call((Object)passwordService, (Object)password, (Object)enc));
        }
        catch (Throwable throwable) {
            callSiteArray[92].call(Locale.class, (Object)locale);
            throw throwable;
        }
        callSiteArray[91].call(Locale.class, (Object)locale);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DefaultPasswordServiceTest.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "assertNull";
        stringArray[2] = "encryptPassword";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "assertNull";
        stringArray[5] = "hashPassword";
        stringArray[6] = "<$constructor$>";
        stringArray[7] = "encryptPassword";
        stringArray[8] = "assertTrue";
        stringArray[9] = "passwordsMatch";
        stringArray[10] = "<$constructor$>";
        stringArray[11] = "encryptPassword";
        stringArray[12] = "assertFalse";
        stringArray[13] = "passwordsMatch";
        stringArray[14] = "<$constructor$>";
        stringArray[15] = "encryptPassword";
        stringArray[16] = "assertTrue";
        stringArray[17] = "passwordsMatch";
        stringArray[18] = "hashService";
        stringArray[19] = "hashService";
        stringArray[20] = "encryptPassword";
        stringArray[21] = "assertFalse";
        stringArray[22] = "assertTrue";
        stringArray[23] = "passwordsMatch";
        stringArray[24] = "<$constructor$>";
        stringArray[25] = "<$constructor$>";
        stringArray[26] = "assertTrue";
        stringArray[27] = "hashFormat";
        stringArray[28] = "encryptPassword";
        stringArray[29] = "assertTrue";
        stringArray[30] = "hashFormatWarned";
        stringArray[31] = "<$constructor$>";
        stringArray[32] = "assertTrue";
        stringArray[33] = "passwordsMatch";
        stringArray[34] = "assertTrue";
        stringArray[35] = "passwordsMatch";
        stringArray[36] = "assertTrue";
        stringArray[37] = "passwordsMatch";
        stringArray[38] = "assertTrue";
        stringArray[39] = "passwordsMatch";
        stringArray[40] = "assertFalse";
        stringArray[41] = "passwordsMatch";
        stringArray[42] = "assertFalse";
        stringArray[43] = "passwordsMatch";
        stringArray[44] = "<$constructor$>";
        stringArray[45] = "createMock";
        stringArray[46] = "<$constructor$>";
        stringArray[47] = "nextBytes";
        stringArray[48] = "<$constructor$>";
        stringArray[49] = "andReturn";
        stringArray[50] = "expect";
        stringArray[51] = "computeHash";
        stringArray[52] = "isA";
        stringArray[53] = "replay";
        stringArray[54] = "<$constructor$>";
        stringArray[55] = "encryptPassword";
        stringArray[56] = "assertEquals";
        stringArray[57] = "format";
        stringArray[58] = "<$constructor$>";
        stringArray[59] = "verify";
        stringArray[60] = "createMock";
        stringArray[61] = "<$constructor$>";
        stringArray[62] = "nextBytes";
        stringArray[63] = "<$constructor$>";
        stringArray[64] = "format";
        stringArray[65] = "<$constructor$>";
        stringArray[66] = "andReturn";
        stringArray[67] = "expect";
        stringArray[68] = "getInstance";
        stringArray[69] = "eq";
        stringArray[70] = "<$constructor$>";
        stringArray[71] = "replay";
        stringArray[72] = "<$constructor$>";
        stringArray[73] = "assertSame";
        stringArray[74] = "hashFormatFactory";
        stringArray[75] = "assertTrue";
        stringArray[76] = "passwordsMatch";
        stringArray[77] = "verify";
        stringArray[78] = "<$constructor$>";
        stringArray[79] = "<$constructor$>";
        stringArray[80] = "hashService";
        stringArray[81] = "encryptPassword";
        stringArray[82] = "assertTrue";
        stringArray[83] = "passwordsMatch";
        stringArray[84] = "getDefault";
        stringArray[85] = "setDefault";
        stringArray[86] = "<$constructor$>";
        stringArray[87] = "<$constructor$>";
        stringArray[88] = "encryptPassword";
        stringArray[89] = "assertTrue";
        stringArray[90] = "passwordsMatch";
        stringArray[91] = "setDefault";
        stringArray[92] = "setDefault";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[93];
        DefaultPasswordServiceTest.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(DefaultPasswordServiceTest.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = DefaultPasswordServiceTest.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

