/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.testing.web;

import com.gargoylesoftware.htmlunit.WebClient;
import com.github.mjeanroy.junit.servers.commons.Strings;
import com.github.mjeanroy.junit.servers.jetty.EmbeddedJetty;
import com.github.mjeanroy.junit.servers.jetty.EmbeddedJettyConfiguration;
import java.io.File;
import java.io.FilenameFilter;
import java.io.UnsupportedEncodingException;
import org.apache.shiro.codec.Base64;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.resource.FileResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;

public abstract class AbstractContainerIT {
    protected static EmbeddedJetty jetty;
    protected final WebClient webClient = new WebClient();

    @BeforeClass
    public static void startContainer() throws Exception {
        EmbeddedJettyConfiguration config = ((EmbeddedJettyConfiguration.Builder)EmbeddedJettyConfiguration.builder().withWebapp(AbstractContainerIT.getWarDir())).build();
        jetty = new EmbeddedJetty(config){

            protected WebAppContext createdWebAppContext() throws Exception {
                String path = ((EmbeddedJettyConfiguration)this.configuration).getPath();
                String webapp = ((EmbeddedJettyConfiguration)this.configuration).getWebapp();
                String classpath = ((EmbeddedJettyConfiguration)this.configuration).getClasspath();
                WebAppContext ctx = new WebAppContext();
                ctx.setClassLoader(Thread.currentThread().getContextClassLoader());
                ctx.setContextPath(path);
                ctx.setBaseResource(Resource.newResource((String)webapp));
                ctx.setConfigurations(new Configuration[]{new WebInfConfiguration(), new WebXmlConfiguration(), new AnnotationConfiguration(), new JettyWebXmlConfiguration(), new MetaInfConfiguration(), new FragmentConfiguration()});
                if (Strings.isNotBlank((String)classpath)) {
                    File classes = new File(classpath);
                    FileResource containerResources = new FileResource(classes.toURI());
                    ctx.getMetaData().addContainerResource((Resource)containerResources);
                }
                Server server = this.getDelegate();
                ctx.setParentLoaderPriority(true);
                ctx.setWar(webapp);
                ctx.setServer(server);
                server.setHandler((Handler)ctx);
                return ctx;
            }
        };
        jetty.start();
        Assert.assertTrue((boolean)jetty.isStarted());
    }

    protected static String getBaseUri() {
        return "http://localhost:" + jetty.getPort() + "/";
    }

    protected static String getWarDir() {
        File[] warFiles = new File("target").listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".war");
            }
        });
        Assert.assertEquals((String)"Expected only one war file in target directory, run 'mvn clean' and try again", (long)1L, (long)warFiles.length);
        return warFiles[0].getAbsolutePath().replaceFirst("\\.war$", "");
    }

    protected static String getBasicAuthorizationHeaderValue(String username, String password) throws UnsupportedEncodingException {
        String authorizationHeader = username + ":" + password;
        byte[] valueBytes = authorizationHeader.getBytes("UTF-8");
        authorizationHeader = new String(Base64.encode((byte[])valueBytes));
        return "Basic " + authorizationHeader;
    }

    @Before
    public void beforeTest() {
        this.webClient.getOptions().setThrowExceptionOnFailingStatusCode(true);
    }

    @AfterClass
    public static void stopContainer() {
        if (jetty != null) {
            jetty.stop();
        }
    }
}

