/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.samples.guice;

import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import javax.inject.Singleton;
import javax.servlet.ServletContext;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.config.ConfigurationException;
import org.apache.shiro.config.Ini;
import org.apache.shiro.guice.web.ShiroWebModule;
import org.apache.shiro.mgt.RememberMeManager;
import org.apache.shiro.realm.text.IniRealm;
import org.apache.shiro.web.mgt.CookieRememberMeManager;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.mgt.WebSecurityManager;

/*
 * Exception performing whole class analysis ignored.
 */
public class SampleShiroServletModule
extends ShiroWebModule {
    private final ServletContext servletContext;

    public SampleShiroServletModule(ServletContext servletContext) {
        super(servletContext);
        this.servletContext = servletContext;
    }

    protected void configureShiroWeb() {
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"shiro.loginUrl")).to("/login.jsp");
        try {
            this.bindRealm().toConstructor(IniRealm.class.getConstructor(Ini.class));
        }
        catch (NoSuchMethodException e) {
            this.addError("Could not locate proper constructor for IniRealm.", new Object[]{e});
        }
        this.addFilterChain("/login.jsp", AUTHC);
        this.addFilterChain("/logout", LOGOUT);
        this.addFilterChain("/account/**", AUTHC);
        this.addFilterChain("/remoting/**", new Key[]{AUTHC, SampleShiroServletModule.config((Key)ROLES, (String)"b2bClient"), SampleShiroServletModule.config((Key)PERMS, (String)"remote:invoke:lan,wan")});
    }

    @Provides
    @Singleton
    Ini loadShiroIni() throws MalformedURLException {
        URL iniUrl = this.servletContext.getResource("/WEB-INF/shiro.ini");
        return Ini.fromResourcePath((String)("url:" + iniUrl.toExternalForm()));
    }

    protected void bindWebSecurityManager(AnnotatedBindingBuilder<? super WebSecurityManager> bind) {
        try {
            String cipherKey = this.loadShiroIni().getSectionProperty("main", "securityManager.rememberMeManager.cipherKey");
            DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
            CookieRememberMeManager rememberMeManager = new CookieRememberMeManager();
            rememberMeManager.setCipherKey(Base64.decode((String)cipherKey));
            securityManager.setRememberMeManager((RememberMeManager)rememberMeManager);
            bind.toInstance((Object)securityManager);
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("securityManager.rememberMeManager.cipherKey must be set in shiro.ini.");
        }
    }
}

