/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.crypto.support.hashes.bcrypt;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import org.apache.shiro.crypto.support.hashes.bcrypt.OpenBSDBase64;
import org.apache.shiro.lang.util.SimpleByteSource;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BCryptHashTest
implements GroovyObject {
    private static final String TEST_PASSWORD = "secret#shiro,password;Jo8opech";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ Class $class$org$apache$shiro$crypto$support$hashes$bcrypt$BCryptHash;

    @Generated
    public BCryptHashTest() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Test
    public void testCreateHashGenerateSaltIterations() {
        CallSite testPasswordChars = IndyInterface.bootstrap("init", "<init>", 0, SimpleByteSource.class, TEST_PASSWORD);
        CallSite bCryptHash = IndyInterface.bootstrap("invoke", "generate", 0, BCryptHashTest.$get$$class$org$apache$shiro$crypto$support$hashes$bcrypt$BCryptHash(), testPasswordChars);
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assertions.class, IndyInterface.bootstrap("getProperty", "DEFAULT_COST", 0, BCryptHashTest.$get$$class$org$apache$shiro$crypto$support$hashes$bcrypt$BCryptHash()), IndyInterface.bootstrap("getProperty", "cost", 0, bCryptHash));
    }

    @Test
    public void testCreateHashGivenSalt() {
        CallSite testPasswordChars = IndyInterface.bootstrap("init", "<init>", 0, SimpleByteSource.class, TEST_PASSWORD);
        CallSite salt = IndyInterface.bootstrap("init", "<init>", 0, SimpleByteSource.class, IndyInterface.bootstrap("invoke", "generateSeed", 0, IndyInterface.bootstrap("init", "<init>", 0, SecureRandom.class), 16));
        Integer cost = 6;
        CallSite bCryptHash = IndyInterface.bootstrap("invoke", "generate", 0, BCryptHashTest.$get$$class$org$apache$shiro$crypto$support$hashes$bcrypt$BCryptHash(), testPasswordChars, salt, cost);
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assertions.class, cost, IndyInterface.bootstrap("getProperty", "cost", 0, bCryptHash));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assertions.class, ScriptBytecodeAdapter.createPojoWrapper((Object)((Integer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "pow", 0, Math.class, 2, cost), Integer.class))), Integer.TYPE), IndyInterface.bootstrap("getProperty", "iterations", 0, bCryptHash));
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assertions.class, salt, IndyInterface.bootstrap("getProperty", "salt", 0, bCryptHash));
    }

    @Test
    public void toBase64EqualsInput() {
        String salt = "7rOjsAf2U/AKKqpMpCIn6e";
        CallSite saltBytes = IndyInterface.bootstrap("init", "<init>", 0, SimpleByteSource.class, IndyInterface.bootstrap("invoke", "decode", 0, IndyInterface.bootstrap("init", "<init>", 0, OpenBSDBase64.Default.class), IndyInterface.bootstrap("invoke", "getBytes", 0, salt, IndyInterface.bootstrap("getProperty", "ISO_8859_1", 0, StandardCharsets.class))));
        CallSite testPwBytes = IndyInterface.bootstrap("init", "<init>", 0, SimpleByteSource.class, TEST_PASSWORD);
        CallSite expectedHashString = IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "$2y$10$", salt), "tuOXyQ86tp2Tn9xv6FyXl2T0QYc3.G.");
        CallSite bCryptHash = IndyInterface.bootstrap("invoke", "generate", 0, BCryptHashTest.$get$$class$org$apache$shiro$crypto$support$hashes$bcrypt$BCryptHash(), "2y", testPwBytes, saltBytes, 10);
        IndyInterface.bootstrap("invoke", "assertEquals", 0, Assertions.class, expectedHashString, IndyInterface.bootstrap("invoke", "formatToCryptString", 0, bCryptHash));
    }

    @Test
    public void testMatchesPassword() {
        String expectedHashString = "$2y$10$7rOjsAf2U/AKKqpMpCIn6etuOXyQ86tp2Tn9xv6FyXl2T0QYc3.G.";
        CallSite bCryptHash = IndyInterface.bootstrap("invoke", "fromString", 0, BCryptHashTest.$get$$class$org$apache$shiro$crypto$support$hashes$bcrypt$BCryptHash(), expectedHashString);
        CallSite testPwBytes = IndyInterface.bootstrap("init", "<init>", 0, SimpleByteSource.class, TEST_PASSWORD);
        CallSite matchesPassword = IndyInterface.bootstrap("invoke", "matchesPassword", 0, bCryptHash, testPwBytes);
        IndyInterface.bootstrap("invoke", "assertTrue", 0, Assertions.class, matchesPassword);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != BCryptHashTest.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    private static /* synthetic */ Class $get$$class$org$apache$shiro$crypto$support$hashes$bcrypt$BCryptHash() {
        Class clazz = $class$org$apache$shiro$crypto$support$hashes$bcrypt$BCryptHash;
        if (clazz == null) {
            clazz = $class$org$apache$shiro$crypto$support$hashes$bcrypt$BCryptHash = BCryptHashTest.class$("org.apache.shiro.crypto.support.hashes.bcrypt.BCryptHash");
        }
        return clazz;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

