/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.sample.spi;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.testing.FakeGadgetToken;
import org.apache.shindig.protocol.DataCollection;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.protocol.model.FilterOperation;
import org.apache.shindig.protocol.model.SortOrder;
import org.apache.shindig.social.SocialApiTestsGuiceModule;
import org.apache.shindig.social.opensocial.model.Activity;
import org.apache.shindig.social.opensocial.model.ActivityEntry;
import org.apache.shindig.social.opensocial.model.Person;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.apache.shindig.social.sample.spi.JsonDbOpensocialService;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JsonDbOpensocialServiceTest
extends Assert {
    private JsonDbOpensocialService db;
    private static final UserId CANON_USER = new UserId(UserId.Type.userId, "canonical");
    private static final UserId JOHN_DOE = new UserId(UserId.Type.userId, "john.doe");
    private static final UserId JANE_DOE = new UserId(UserId.Type.userId, "jane.doe");
    private static final GroupId SELF_GROUP = new GroupId(GroupId.Type.self, null);
    private static final String APP_ID = "1";
    private static final String CANONICAL_USER_ID = "canonical";
    private SecurityToken token = new FakeGadgetToken();

    @Before
    public void setUp() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new SocialApiTestsGuiceModule()});
        this.db = (JsonDbOpensocialService)injector.getInstance(JsonDbOpensocialService.class);
    }

    @Test
    public void testGetPersonDefaultFields() throws Exception {
        Person person = (Person)this.db.getPerson(CANON_USER, Person.Field.DEFAULT_FIELDS, this.token).get();
        JsonDbOpensocialServiceTest.assertNotNull((String)"Canonical user not found", (Object)person);
        JsonDbOpensocialServiceTest.assertNotNull((String)"Canonical user has no id", (Object)person.getId());
        JsonDbOpensocialServiceTest.assertNotNull((String)"Canonical user has no name", (Object)person.getName());
        JsonDbOpensocialServiceTest.assertNotNull((String)"Canonical user has no thumbnail", (Object)person.getThumbnailUrl());
    }

    @Test
    public void testGetPersonAllFields() throws Exception {
        Person person = (Person)this.db.getPerson(CANON_USER, Person.Field.ALL_FIELDS, this.token).get();
        JsonDbOpensocialServiceTest.assertNotNull((String)"Canonical user not found", (Object)person);
    }

    @Test
    public void testGetPersonAllAppData() throws Exception {
        Person person = (Person)this.db.getPerson(CANON_USER, (Set)ImmutableSet.of((Object)"id", (Object)"appData"), this.token).get();
        JsonDbOpensocialServiceTest.assertNotNull((String)"Canonical user not found", (Object)person);
        JsonDbOpensocialServiceTest.assertEquals((String)"Canonical user has wrong id", (Object)CANONICAL_USER_ID, (Object)person.getId());
        JsonDbOpensocialServiceTest.assertEquals((String)"Canonical user has wrong app data", (Object)ImmutableMap.of((Object)"count", (Object)"2", (Object)"size", (Object)"100"), (Object)person.getAppData());
    }

    @Test
    public void testGetPersonOneAppDataField() throws Exception {
        Person person = (Person)this.db.getPerson(CANON_USER, (Set)ImmutableSet.of((Object)"id", (Object)"appData.size"), this.token).get();
        JsonDbOpensocialServiceTest.assertNotNull((String)"Canonical user not found", (Object)person);
        JsonDbOpensocialServiceTest.assertEquals((String)"Canonical user has wrong id", (Object)CANONICAL_USER_ID, (Object)person.getId());
        JsonDbOpensocialServiceTest.assertEquals((String)"Canonical user has wrong app data", (Object)ImmutableMap.of((Object)"size", (Object)"100"), (Object)person.getAppData());
    }

    @Test
    public void testGetPersonMultipleAppDataFields() throws Exception {
        Person person = (Person)this.db.getPerson(CANON_USER, (Set)ImmutableSet.of((Object)"id", (Object)"appData.size", (Object)"appData.count", (Object)"appData.bogus"), this.token).get();
        JsonDbOpensocialServiceTest.assertNotNull((String)"Canonical user not found", (Object)person);
        JsonDbOpensocialServiceTest.assertEquals((String)"Canonical user has wrong id", (Object)CANONICAL_USER_ID, (Object)person.getId());
        JsonDbOpensocialServiceTest.assertEquals((String)"Canonical user has wrong app data", (Object)ImmutableMap.of((Object)"count", (Object)"2", (Object)"size", (Object)"100"), (Object)person.getAppData());
    }

    @Test
    public void testGetExpectedFriends() throws Exception {
        CollectionOptions options = new CollectionOptions();
        options.setSortBy("topFriends");
        options.setSortOrder(SortOrder.ascending);
        options.setFilter(null);
        options.setFilterOperation(FilterOperation.contains);
        options.setFilterValue("");
        options.setFirst(0);
        options.setMax(20);
        RestfulCollection responseItem = (RestfulCollection)this.db.getPeople((Set)ImmutableSet.of((Object)CANON_USER), new GroupId(GroupId.Type.friends, null), options, Collections.emptySet(), this.token).get();
        JsonDbOpensocialServiceTest.assertNotNull((Object)responseItem);
        JsonDbOpensocialServiceTest.assertEquals((long)4L, (long)responseItem.getTotalResults());
        JsonDbOpensocialServiceTest.assertEquals((Object)"john.doe", (Object)((Person)responseItem.getEntry().get(0)).getId());
        JsonDbOpensocialServiceTest.assertEquals((Object)"jane.doe", (Object)((Person)responseItem.getEntry().get(1)).getId());
    }

    @Test
    public void testGetExpectedUsersForPlural() throws Exception {
        CollectionOptions options = new CollectionOptions();
        options.setSortBy("topFriends");
        options.setSortOrder(SortOrder.ascending);
        options.setFilter(null);
        options.setFilterOperation(FilterOperation.contains);
        options.setFilterValue("");
        options.setFirst(0);
        options.setMax(20);
        RestfulCollection responseItem = (RestfulCollection)this.db.getPeople((Set)ImmutableSet.of((Object)JOHN_DOE, (Object)JANE_DOE), new GroupId(GroupId.Type.friends, null), options, Collections.emptySet(), this.token).get();
        JsonDbOpensocialServiceTest.assertNotNull((Object)responseItem);
        JsonDbOpensocialServiceTest.assertEquals((long)4L, (long)responseItem.getTotalResults());
        JsonDbOpensocialServiceTest.assertEquals((Object)"john.doe", (Object)((Person)responseItem.getEntry().get(0)).getId());
        JsonDbOpensocialServiceTest.assertEquals((Object)"jane.doe", (Object)((Person)responseItem.getEntry().get(1)).getId());
    }

    @Test
    public void testGetExpectedActivities() throws Exception {
        RestfulCollection responseItem = (RestfulCollection)this.db.getActivities((Set)ImmutableSet.of((Object)CANON_USER), SELF_GROUP, APP_ID, Collections.emptySet(), null, (SecurityToken)new FakeGadgetToken()).get();
        JsonDbOpensocialServiceTest.assertSame((Object)2, (Object)responseItem.getTotalResults());
    }

    @Test
    public void testGetExpectedActivitiesForPlural() throws Exception {
        RestfulCollection responseItem = (RestfulCollection)this.db.getActivities((Set)ImmutableSet.of((Object)CANON_USER, (Object)JOHN_DOE), SELF_GROUP, APP_ID, Collections.emptySet(), null, (SecurityToken)new FakeGadgetToken()).get();
        JsonDbOpensocialServiceTest.assertSame((Object)3, (Object)responseItem.getTotalResults());
    }

    @Test
    public void testGetExpectedActivity() throws Exception {
        Activity activity = (Activity)this.db.getActivity(CANON_USER, SELF_GROUP, APP_ID, (Set)ImmutableSet.of((Object)"appId", (Object)"body", (Object)"mediaItems"), APP_ID, (SecurityToken)new FakeGadgetToken()).get();
        JsonDbOpensocialServiceTest.assertNotNull((Object)activity);
        JsonDbOpensocialServiceTest.assertNotNull((Object)activity.getBody());
        JsonDbOpensocialServiceTest.assertNull((Object)activity.getBodyId());
    }

    @Test
    public void testDeleteExpectedActivity() throws Exception {
        this.db.deleteActivities(CANON_USER, SELF_GROUP, APP_ID, (Set)ImmutableSet.of((Object)APP_ID), (SecurityToken)new FakeGadgetToken());
        try {
            this.db.getActivity(CANON_USER, SELF_GROUP, APP_ID, (Set)ImmutableSet.of((Object)"appId", (Object)"body", (Object)"mediaItems"), APP_ID, (SecurityToken)new FakeGadgetToken()).get();
            JsonDbOpensocialServiceTest.fail();
        }
        catch (ProtocolException sse) {
            JsonDbOpensocialServiceTest.assertEquals((long)400L, (long)sse.getCode());
        }
    }

    @Test
    public void testGetExpectedAppData() throws Exception {
        DataCollection responseItem = (DataCollection)this.db.getPersonData((Set)ImmutableSet.of((Object)CANON_USER), SELF_GROUP, APP_ID, Collections.emptySet(), (SecurityToken)new FakeGadgetToken()).get();
        JsonDbOpensocialServiceTest.assertFalse((boolean)responseItem.getEntry().isEmpty());
        JsonDbOpensocialServiceTest.assertFalse((boolean)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).isEmpty());
        JsonDbOpensocialServiceTest.assertSame((Object)2, (Object)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).size());
        JsonDbOpensocialServiceTest.assertTrue((boolean)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).containsKey("count"));
        JsonDbOpensocialServiceTest.assertTrue((boolean)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).containsKey("size"));
    }

    @Test
    public void testGetExpectedAppDataForPlural() throws Exception {
        DataCollection responseItem = (DataCollection)this.db.getPersonData((Set)ImmutableSet.of((Object)CANON_USER, (Object)JOHN_DOE), SELF_GROUP, APP_ID, Collections.emptySet(), (SecurityToken)new FakeGadgetToken()).get();
        JsonDbOpensocialServiceTest.assertFalse((boolean)responseItem.getEntry().isEmpty());
        JsonDbOpensocialServiceTest.assertFalse((boolean)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).isEmpty());
        JsonDbOpensocialServiceTest.assertSame((Object)2, (Object)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).size());
        JsonDbOpensocialServiceTest.assertTrue((boolean)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).containsKey("count"));
        JsonDbOpensocialServiceTest.assertTrue((boolean)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).containsKey("size"));
        JsonDbOpensocialServiceTest.assertFalse((boolean)((Map)responseItem.getEntry().get(JOHN_DOE.getUserId())).isEmpty());
        JsonDbOpensocialServiceTest.assertSame((Object)1, (Object)((Map)responseItem.getEntry().get(JOHN_DOE.getUserId())).size());
        JsonDbOpensocialServiceTest.assertTrue((boolean)((Map)responseItem.getEntry().get(JOHN_DOE.getUserId())).containsKey("count"));
    }

    @Test
    public void testDeleteExpectedAppData() throws Exception {
        this.db.deletePersonData(CANON_USER, SELF_GROUP, APP_ID, (Set)ImmutableSet.of((Object)"count"), (SecurityToken)new FakeGadgetToken());
        DataCollection responseItem = (DataCollection)this.db.getPersonData((Set)ImmutableSet.of((Object)CANON_USER), SELF_GROUP, APP_ID, Collections.emptySet(), (SecurityToken)new FakeGadgetToken()).get();
        JsonDbOpensocialServiceTest.assertFalse((boolean)responseItem.getEntry().isEmpty());
        JsonDbOpensocialServiceTest.assertFalse((boolean)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).isEmpty());
        JsonDbOpensocialServiceTest.assertSame((Object)1, (Object)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).size());
        JsonDbOpensocialServiceTest.assertFalse((boolean)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).containsKey("count"));
        JsonDbOpensocialServiceTest.assertTrue((boolean)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).containsKey("size"));
    }

    @Test
    public void testUpdateExpectedAppData() throws Exception {
        this.db.updatePersonData(CANON_USER, SELF_GROUP, APP_ID, null, (Map)ImmutableMap.of((Object)"count", (Object)"10", (Object)"newvalue", (Object)"20"), (SecurityToken)new FakeGadgetToken());
        DataCollection responseItem = (DataCollection)this.db.getPersonData((Set)ImmutableSet.of((Object)CANON_USER), SELF_GROUP, APP_ID, Collections.emptySet(), (SecurityToken)new FakeGadgetToken()).get();
        JsonDbOpensocialServiceTest.assertFalse((boolean)responseItem.getEntry().isEmpty());
        JsonDbOpensocialServiceTest.assertFalse((boolean)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).isEmpty());
        JsonDbOpensocialServiceTest.assertSame((Object)3, (Object)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).size());
        JsonDbOpensocialServiceTest.assertTrue((boolean)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).containsKey("count"));
        JsonDbOpensocialServiceTest.assertEquals((Object)"10", ((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).get("count"));
        JsonDbOpensocialServiceTest.assertTrue((boolean)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).containsKey("newvalue"));
        JsonDbOpensocialServiceTest.assertEquals((Object)"20", ((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).get("newvalue"));
    }

    @Test
    public void testGetExpectedActivityEntries() throws Exception {
        RestfulCollection responseItem = (RestfulCollection)this.db.getActivityEntries((Set)ImmutableSet.of((Object)JOHN_DOE), SELF_GROUP, APP_ID, Collections.emptySet(), null, (SecurityToken)new FakeGadgetToken()).get();
        JsonDbOpensocialServiceTest.assertSame((Object)2, (Object)responseItem.getTotalResults());
    }

    @Test
    public void testGetExpectedActivityEntriesForPlural() throws Exception {
        RestfulCollection responseItem = (RestfulCollection)this.db.getActivityEntries((Set)ImmutableSet.of((Object)CANON_USER, (Object)JOHN_DOE), SELF_GROUP, APP_ID, Collections.emptySet(), null, (SecurityToken)new FakeGadgetToken()).get();
        JsonDbOpensocialServiceTest.assertSame((Object)2, (Object)responseItem.getTotalResults());
    }

    @Test
    public void testGetExpectedActivityEntry() throws Exception {
        ActivityEntry entry = (ActivityEntry)this.db.getActivityEntry(JOHN_DOE, SELF_GROUP, APP_ID, (Set)ImmutableSet.of((Object)"title"), "activity2", (SecurityToken)new FakeGadgetToken()).get();
        JsonDbOpensocialServiceTest.assertNotNull((Object)entry);
        JsonDbOpensocialServiceTest.assertNotNull((Object)entry.getTitle());
        JsonDbOpensocialServiceTest.assertNull((Object)entry.getPublished());
    }

    @Test
    public void testDeleteExpectedActivityEntry() throws Exception {
        this.db.deleteActivityEntries(JOHN_DOE, SELF_GROUP, APP_ID, (Set)ImmutableSet.of((Object)APP_ID), (SecurityToken)new FakeGadgetToken());
        try {
            this.db.getActivityEntry(JOHN_DOE, SELF_GROUP, APP_ID, (Set)ImmutableSet.of((Object)"body"), APP_ID, (SecurityToken)new FakeGadgetToken()).get();
            JsonDbOpensocialServiceTest.fail();
        }
        catch (ProtocolException sse) {
            JsonDbOpensocialServiceTest.assertEquals((long)400L, (long)sse.getCode());
        }
    }

    @Test
    public void testViewerCanUpdatePerson() throws Exception {
        JSONArray people = this.db.getDb().getJSONArray("people");
        JSONObject jsonPerson = new JSONObject();
        jsonPerson.put("id", (Object)"updatePerson");
        people.put(people.length(), (Object)jsonPerson);
        FakeGadgetToken updateToken = new FakeGadgetToken("appId", "appUrl", "domain", "updatePerson", "trustedJson", "updatePerson", "20");
        UserId userId = new UserId(UserId.Type.userId, "updatePerson");
        Person person = (Person)this.db.getPerson(userId, Person.Field.ALL_FIELDS, this.token).get();
        JsonDbOpensocialServiceTest.assertNotNull((String)"User 'updatePerson' not found", (Object)person);
        person.setThumbnailUrl("http://newthumbnail.url");
        this.db.updatePerson(userId, person, (SecurityToken)updateToken);
        person = (Person)this.db.getPerson(userId, Person.Field.ALL_FIELDS, this.token).get();
        JsonDbOpensocialServiceTest.assertNotNull((String)"User 'updatePerson' not found", (Object)person);
        JsonDbOpensocialServiceTest.assertEquals((Object)"http://newthumbnail.url", (Object)person.getThumbnailUrl());
    }

    @Test
    public void testViewerNotAllowedUpdatePerson() throws Exception {
        JSONArray people = this.db.getDb().getJSONArray("people");
        JSONObject jsonPerson = new JSONObject();
        jsonPerson.put("id", (Object)"updatePerson");
        people.put(people.length(), (Object)jsonPerson);
        FakeGadgetToken updateToken = new FakeGadgetToken("appId", "appUrl", "domain", "viewer", "trustedJson", "viewer", "20");
        UserId userId = new UserId(UserId.Type.userId, "updatePerson");
        Person person = (Person)this.db.getPerson(userId, Person.Field.ALL_FIELDS, this.token).get();
        person.setThumbnailUrl("http://newthumbnail.url");
        try {
            this.db.updatePerson(userId, person, (SecurityToken)updateToken);
            JsonDbOpensocialServiceTest.fail();
        }
        catch (ProtocolException sse) {
            JsonDbOpensocialServiceTest.assertEquals((long)403L, (long)sse.getCode());
        }
    }
}

