/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.shindig.common.util.CharsetUtil;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class XSDValidator {
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String XMLDEC = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    private static final String classname = XSDValidator.class.getName();
    private static final Logger LOG = Logger.getLogger(classname, "org.apache.shindig.common.logging.i18n.resource");

    public static String validate(String xml, InputStream schema) {
        return XSDValidator.validate(new ByteArrayInputStream(CharsetUtil.getUtf8Bytes((String)xml)), schema);
    }

    public static String validate(InputStream xml, InputStream schema) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        StringBuilder errors = new StringBuilder();
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance(W3C_XML_SCHEMA);
            Schema s = schemaFactory.newSchema(new StreamSource(schema));
            Validator validator = s.newValidator();
            final LSResourceResolver lsr = validator.getResourceResolver();
            validator.setResourceResolver(new LSResourceResolver(){

                @Override
                public LSInput resolveResource(String arg0, String arg1, String arg2, String arg3, String arg4) {
                    if (LOG.isLoggable(Level.INFO)) {
                        LOG.logp(Level.INFO, classname, "resolveResource", "resolveResource", new Object[]{arg0, arg1, arg2, arg3, arg4});
                    }
                    return lsr.resolveResource(arg0, arg1, arg2, arg3, arg4);
                }
            });
            validator.validate(new StreamSource(xml));
        }
        catch (IOException e) {
        }
        catch (SAXException e) {
            errors.append(e.getMessage()).append('\n');
        }
        return errors.toString();
    }

    public static String insertSchema(String xml, String schemaStatement, boolean removeContainer) {
        if (xml == null || xml.trim().length() == 0) {
            return xml;
        }
        int start = 0;
        if (xml.startsWith("<?")) {
            start = xml.indexOf(62) + 1;
            int gt = xml.indexOf(62, start);
            if (gt > 0) {
                return xml.substring(0, gt) + schemaStatement + xml.substring(gt);
            }
        } else {
            int gt = xml.indexOf(62, start);
            if (gt > 0) {
                return XMLDEC + xml.substring(0, gt) + schemaStatement + xml.substring(gt);
            }
        }
        return xml;
    }

    public static String validate(String xmlFragment, String schemaStatement, String schemaResource, boolean removeContainer) {
        String errors;
        String xml = XSDValidator.insertSchema(xmlFragment, schemaStatement, removeContainer);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Validating " + xml);
        }
        if (!"".equals(errors = XSDValidator.validate(xml, XSDValidator.class.getResourceAsStream(schemaResource))) && LOG.isLoggable(Level.SEVERE)) {
            LOG.logp(Level.SEVERE, classname, "resolveResource", "failedToValidate", new Object[]{xml});
        }
        if (!"".equals(errors)) {
            throw new Error("XML document does not validate \n" + errors + '\n' + xml);
        }
        return xml;
    }

    public static String validateOpenSocial(String xmlFragment) {
        String errors;
        String XMLSCHEMA = " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n xsi:schemaLocation=\"http://ns.opensocial.org/2008/opensocial classpath:opensocial.xsd\" ";
        String xml = XSDValidator.insertSchema(xmlFragment, XMLSCHEMA, true);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Validating " + xml);
        }
        if (!"".equals(errors = XSDValidator.validate(xml, XSDValidator.class.getResourceAsStream("opensocial.xsd"))) && LOG.isLoggable(Level.SEVERE)) {
            LOG.logp(Level.SEVERE, classname, "resolveResource", "failedToValidate", new Object[]{xml});
        }
        if (!"".equals(errors)) {
            throw new Error("XML document does not validate \n" + errors + '\n' + xml);
        }
        return xml;
    }
}

