/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.shindig.common.xml.XmlException;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.protocol.conversion.BeanXStreamConverter;
import org.apache.shindig.protocol.conversion.xstream.XStreamConfiguration;
import org.apache.shindig.social.SocialApiTestsGuiceModule;
import org.apache.shindig.social.core.model.ActivityImpl;
import org.apache.shindig.social.core.model.AddressImpl;
import org.apache.shindig.social.core.model.ListFieldImpl;
import org.apache.shindig.social.core.model.MediaItemImpl;
import org.apache.shindig.social.core.model.NameImpl;
import org.apache.shindig.social.core.model.PersonImpl;
import org.apache.shindig.social.core.util.xstream.XStream081Configuration;
import org.apache.shindig.social.opensocial.model.Activity;
import org.apache.shindig.social.opensocial.model.Address;
import org.apache.shindig.social.opensocial.model.ListField;
import org.apache.shindig.social.opensocial.model.MediaItem;
import org.apache.shindig.social.opensocial.model.Name;
import org.apache.shindig.social.opensocial.model.Person;
import org.apache.shindig.social.opensocial.util.XSDValidator;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BeanXStreamConverterTest
extends Assert {
    private static final String XMLSCHEMA = " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n xsi:schemaLocation=\"http://ns.opensocial.org/2008/opensocial classpath:opensocial.xsd\" ";
    private Person johnDoe;
    private Activity activity;
    private BeanXStreamConverter beanXmlConverter;

    @Before
    public void setUp() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new SocialApiTestsGuiceModule()});
        this.johnDoe = new PersonImpl("johnDoeId", "Johnny", (Name)new NameImpl("John Doe"));
        this.johnDoe.setPhoneNumbers((List)Lists.newArrayList((Object[])new ListField[]{new ListFieldImpl("home", "+33H000000000"), new ListFieldImpl("mobile", "+33M000000000"), new ListFieldImpl("work", "+33W000000000")}));
        this.johnDoe.setAddresses((List)Lists.newArrayList((Object[])new Address[]{new AddressImpl("My home address")}));
        this.johnDoe.setEmails((List)Lists.newArrayList((Object[])new ListField[]{new ListFieldImpl("work", "john.doe@work.bar"), new ListFieldImpl("home", "john.doe@home.bar")}));
        this.activity = new ActivityImpl("activityId", this.johnDoe.getId());
        this.activity.setUrl("http://foo.com/");
        this.activity.setMediaItems((List)Lists.newArrayList((Object[])new MediaItem[]{new MediaItemImpl("image/jpg", MediaItem.Type.IMAGE, "http://foo.bar")}));
        this.beanXmlConverter = new BeanXStreamConverter((XStreamConfiguration)new XStream081Configuration(injector));
    }

    @Test
    public void testToXmlOnSimpleClass() throws Exception {
        SimplePerson cassie = new SimplePerson("5", "robot");
        String xml = this.beanXmlConverter.convertToString((Object)cassie);
        Element element = XmlUtil.parse((String)xml);
        Node id = element.getElementsByTagName("id").item(0);
        Node name = element.getElementsByTagName("name").item(0);
        BeanXStreamConverterTest.assertEquals((Object)"5", (Object)id.getTextContent());
        BeanXStreamConverterTest.assertEquals((Object)"robot", (Object)name.getTextContent());
    }

    @Test
    public void testPersonToXml() throws Exception {
        String xml = XSDValidator.validateOpenSocial(this.beanXmlConverter.convertToString((Object)this.johnDoe));
        Element element = XmlUtil.parse((String)xml);
        Node id = element.getElementsByTagName("id").item(0);
        BeanXStreamConverterTest.assertEquals((Object)this.johnDoe.getId(), (Object)id.getTextContent());
    }

    @Test
    public void testActivityToXml() throws Exception {
        String xml = XSDValidator.validateOpenSocial(this.beanXmlConverter.convertToString((Object)this.activity));
        Element element = XmlUtil.parse((String)xml);
        Node id = element.getElementsByTagName("id").item(0);
        BeanXStreamConverterTest.assertEquals((Object)this.activity.getId(), (Object)id.getTextContent());
    }

    @Test
    public void testMapsToXml() throws Exception {
        TreeMap map = Maps.newTreeMap();
        HashMap item1Map = Maps.newHashMap();
        item1Map.put("value", "1");
        map.put("item1", item1Map);
        HashMap item2Map = Maps.newHashMap();
        item2Map.put("value", "2");
        map.put("item2", item2Map);
        String xml = this.beanXmlConverter.convertToString((Object)map);
        XmlUtil.parse((String)xml);
        String expectedXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<response xmlns=\"http://ns.opensocial.org/2008/opensocial\"><map>  <entry><key>item1</key><value><entry><key>value</key><value>1</value></entry></value></entry>   <entry><key>item2</key><value><entry><key>value</key><value>2</value></entry></value></entry> </map></response>";
        BeanXStreamConverterTest.assertEquals((Object)StringUtils.deleteWhitespace((String)expectedXml), (Object)StringUtils.deleteWhitespace((String)xml));
    }

    @Test
    public void testMapToXml() throws XmlException {
        LinkedHashMap m = Maps.newLinkedHashMap();
        m.put("key1", "value1");
        m.put("key2", "value2");
        String xml = this.beanXmlConverter.convertToString((Object)m);
        XmlUtil.parse((String)xml);
        String expectedXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<response xmlns=\"http://ns.opensocial.org/2008/opensocial\"><map>  <entry><key>key1</key><value>value1</value></entry>   <entry><key>key2</key><value>value2</value></entry> </map></response>";
        BeanXStreamConverterTest.assertEquals((Object)StringUtils.deleteWhitespace((String)expectedXml), (Object)StringUtils.deleteWhitespace((String)xml));
    }

    @Test
    public void testEmptyList() throws XmlException {
        ArrayList empty = Lists.newArrayList();
        String xml = this.beanXmlConverter.convertToString((Object)empty);
        XmlUtil.parse((String)xml);
        String expectedXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<response xmlns=\"http://ns.opensocial.org/2008/opensocial\"><list/></response>";
        BeanXStreamConverterTest.assertEquals((Object)StringUtils.deleteWhitespace((String)expectedXml), (Object)StringUtils.deleteWhitespace((String)xml));
        ArrayList emptyLists = Lists.newArrayList();
        ArrayList emptyList = Lists.newArrayList();
        emptyLists.add(emptyList);
        emptyLists.add(emptyList);
        emptyLists.add(emptyList);
        xml = this.beanXmlConverter.convertToString((Object)emptyLists);
        XmlUtil.parse((String)xml);
        expectedXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<response xmlns=\"http://ns.opensocial.org/2008/opensocial\"><list.container>  <list/>  <list/>  <list/></list.container></response>";
        BeanXStreamConverterTest.assertEquals((Object)StringUtils.deleteWhitespace((String)expectedXml), (Object)StringUtils.deleteWhitespace((String)xml));
    }

    @Test
    public void testElementNamesInList() throws Exception {
        ArrayList activities = Lists.newArrayList();
        activities.add(this.activity);
        activities.add(this.activity);
        activities.add(this.activity);
        String xml = XSDValidator.validateOpenSocial(this.beanXmlConverter.convertToString((Object)activities));
        XmlUtil.parse((String)xml);
        String expectedXml = "<response xmlns=\"http://ns.opensocial.org/2008/opensocial\"><list.container>  <activity xmlns=\"http://ns.opensocial.org/2008/opensocial\">    <id>activityId</id>    <mediaItems>        <mimeType>image/jpg</mimeType>        <type>IMAGE</type>        <url>http://foo.bar</url>    </mediaItems>    <url>http://foo.com/</url>    <userId>johnDoeId</userId>  </activity>  <activity xmlns=\"http://ns.opensocial.org/2008/opensocial\">    <id>activityId</id>    <mediaItems>        <mimeType>image/jpg</mimeType>        <type>IMAGE</type>        <url>http://foo.bar</url>    </mediaItems>    <url>http://foo.com/</url>    <userId>johnDoeId</userId>  </activity>  <activity xmlns=\"http://ns.opensocial.org/2008/opensocial\">    <id>activityId</id>    <mediaItems>        <mimeType>image/jpg</mimeType>        <type>IMAGE</type>        <url>http://foo.bar</url>    </mediaItems>    <url>http://foo.com/</url>    <userId>johnDoeId</userId>  </activity></list.container></response>";
        expectedXml = XSDValidator.insertSchema(expectedXml, XMLSCHEMA, true);
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLAssert.assertXMLEqual((String)expectedXml, (String)xml);
    }

    @Test
    public void testPerson1() throws Exception {
        String xml = this.loadXML("testxml/person1.xml");
        this.beanXmlConverter.convertToObject(xml, Person.class);
    }

    @Test
    public void testActivity1() throws Exception {
        String xml = this.loadXML("testxml/activity1.xml");
        this.beanXmlConverter.convertToObject(xml, Activity.class);
    }

    @Test
    public void testAppdata1() throws Exception {
        String xml = this.loadXML("testxml/appdata1.xml");
        this.beanXmlConverter.convertToObject(xml, Map.class);
    }

    @Test
    @Ignore(value="TODO")
    public void testGroup1() throws XmlException {
    }

    private String loadXML(String resource) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(resource)));
        StringBuilder sb = new StringBuilder();
        String line = in.readLine();
        while (line != null) {
            sb.append(line);
            line = in.readLine();
        }
        in.close();
        return sb.toString();
    }

    public static class SimplePerson {
        private String id;
        private String name;

        public SimplePerson(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }
}

