/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.EasyMockTestCase;
import org.apache.shindig.common.testing.FakeGadgetToken;
import org.apache.shindig.common.util.ImmediateFuture;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.config.JsonContainerConfig;
import org.apache.shindig.expressions.Expressions;
import org.apache.shindig.protocol.DefaultHandlerRegistry;
import org.apache.shindig.protocol.HandlerExecutionListener;
import org.apache.shindig.protocol.HandlerRegistry;
import org.apache.shindig.protocol.RestHandler;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.protocol.conversion.BeanConverter;
import org.apache.shindig.protocol.conversion.BeanJsonConverter;
import org.apache.shindig.protocol.model.FilterOperation;
import org.apache.shindig.protocol.model.SortOrder;
import org.apache.shindig.social.core.model.PersonImpl;
import org.apache.shindig.social.opensocial.model.Person;
import org.apache.shindig.social.opensocial.service.PersonHandler;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.PersonService;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.easymock.EasyMock;
import org.json.JSONObject;
import org.junit.Before;
import org.junit.Test;

public class PersonHandlerTest
extends EasyMockTestCase {
    private PersonService personService;
    private PersonHandler handler;
    private FakeGadgetToken token;
    protected HandlerRegistry registry;
    private BeanJsonConverter converter;
    private static final Set<String> DEFAULT_FIELDS = ImmutableSet.of((Object)Person.Field.ID.toString(), (Object)Person.Field.NAME.toString(), (Object)Person.Field.THUMBNAIL_URL.toString());
    private static final Set<UserId> JOHN_DOE = ImmutableSet.of((Object)new UserId(UserId.Type.userId, "john.doe"));
    private static CollectionOptions DEFAULT_OPTIONS = new CollectionOptions();
    protected ContainerConfig containerConfig;

    @Before
    public void setUp() throws Exception {
        this.token = new FakeGadgetToken();
        this.converter = (BeanJsonConverter)this.mock(BeanJsonConverter.class);
        this.personService = (PersonService)this.mock(PersonService.class);
        JSONObject config = new JSONObject("{default:{'gadgets.container': ['default'],'gadgets.features':{opensocial:{supportedFields: {person: ['id', {name: 'familyName'}]}}}}}");
        this.containerConfig = new JsonContainerConfig(config, Expressions.forTesting());
        this.handler = new PersonHandler(this.personService, this.containerConfig);
        this.registry = new DefaultHandlerRegistry(null, this.converter, (HandlerExecutionListener)new HandlerExecutionListener.NoOpHandler());
        this.registry.addHandlers((Set)ImmutableSet.of((Object)this.handler));
    }

    @Test
    public void testHandleGetAllNoParams() throws Exception {
        String path = "/people/john.doe/@all";
        RestHandler operation = this.registry.getRestHandler(path, "GET");
        ImmutableList personList = ImmutableList.of();
        RestfulCollection data = new RestfulCollection((List)personList);
        EasyMock.expect((Object)this.personService.getPeople((Set)EasyMock.eq(JOHN_DOE), (GroupId)EasyMock.eq((Object)new GroupId(GroupId.Type.all, null)), (CollectionOptions)EasyMock.eq((Object)DEFAULT_OPTIONS), (Set)EasyMock.eq(DEFAULT_FIELDS), (SecurityToken)EasyMock.eq((Object)this.token))).andReturn((Object)ImmediateFuture.newInstance((Object)data));
        this.replay();
        PersonHandlerTest.assertEquals((Object)data, operation.execute((Map)Maps.newHashMap(), null, (SecurityToken)this.token, (BeanConverter)this.converter).get());
        this.verify();
    }

    @Test
    public void testHandleGetFriendsNoParams() throws Exception {
        String path = "/people/john.doe/@friends";
        RestHandler operation = this.registry.getRestHandler(path, "GET");
        ImmutableList personList = ImmutableList.of();
        RestfulCollection data = new RestfulCollection((List)personList);
        EasyMock.expect((Object)this.personService.getPeople((Set)EasyMock.eq(JOHN_DOE), (GroupId)EasyMock.eq((Object)new GroupId(GroupId.Type.friends, null)), (CollectionOptions)EasyMock.eq((Object)DEFAULT_OPTIONS), (Set)EasyMock.eq(DEFAULT_FIELDS), (SecurityToken)EasyMock.eq((Object)this.token))).andReturn((Object)ImmediateFuture.newInstance((Object)data));
        this.replay();
        PersonHandlerTest.assertEquals((Object)data, operation.execute((Map)Maps.newHashMap(), null, (SecurityToken)this.token, (BeanConverter)this.converter).get());
        this.verify();
    }

    @Test
    public void testHandleGetFriendsWithParams() throws Exception {
        String path = "/people/john.doe/@friends";
        RestHandler operation = this.registry.getRestHandler(path, "GET");
        CollectionOptions options = new CollectionOptions();
        options.setSortBy(Person.Field.NAME.toString());
        options.setSortOrder(SortOrder.descending);
        options.setFilter("topFriends");
        options.setFilterOperation(FilterOperation.present);
        options.setFilterValue("cassie");
        options.setFirst(5);
        options.setMax(10);
        HashMap params = Maps.newHashMap();
        params.put("sortBy", new String[]{options.getSortBy()});
        params.put("sortOrder", new String[]{options.getSortOrder().toString()});
        params.put("filterBy", new String[]{options.getFilter()});
        params.put("filterOp", new String[]{options.getFilterOperation().toString()});
        params.put("filterValue", new String[]{options.getFilterValue()});
        params.put("startIndex", new String[]{"5"});
        params.put("count", new String[]{"10"});
        params.put("fields", new String[]{"money,fame,fortune"});
        ImmutableList people = ImmutableList.of();
        RestfulCollection data = new RestfulCollection((List)people);
        EasyMock.expect((Object)this.personService.getPeople((Set)EasyMock.eq(JOHN_DOE), (GroupId)EasyMock.eq((Object)new GroupId(GroupId.Type.friends, null)), (CollectionOptions)EasyMock.eq((Object)options), (Set)EasyMock.eq((Object)ImmutableSortedSet.of((Comparable)((Object)"money"), (Comparable)((Object)"fame"), (Comparable)((Object)"fortune"))), (SecurityToken)EasyMock.eq((Object)this.token))).andReturn((Object)ImmediateFuture.newInstance((Object)data));
        this.replay();
        PersonHandlerTest.assertEquals((Object)data, operation.execute((Map)params, null, (SecurityToken)this.token, (BeanConverter)this.converter).get());
        this.verify();
    }

    @Test
    public void testHandleGetFriendById() throws Exception {
        String path = "/people/john.doe/@friends/jane.doe";
        RestHandler operation = this.registry.getRestHandler(path, "GET");
        PersonImpl person = new PersonImpl();
        ArrayList people = Lists.newArrayList((Object[])new Person[]{person});
        RestfulCollection data = new RestfulCollection((List)people);
        EasyMock.expect((Object)this.personService.getPeople((Set)EasyMock.eq((Object)ImmutableSet.of((Object)new UserId(UserId.Type.userId, "jane.doe"))), (GroupId)EasyMock.eq((Object)new GroupId(GroupId.Type.self, null)), (CollectionOptions)EasyMock.eq((Object)DEFAULT_OPTIONS), (Set)EasyMock.eq(DEFAULT_FIELDS), (SecurityToken)EasyMock.eq((Object)this.token))).andReturn((Object)ImmediateFuture.newInstance((Object)data));
        this.replay();
        PersonHandlerTest.assertEquals((Object)person, operation.execute((Map)Maps.newHashMap(), null, (SecurityToken)this.token, (BeanConverter)this.converter).get());
        this.verify();
    }

    @Test
    public void testHandleGetSelf() throws Exception {
        String path = "/people/john.doe/@self";
        RestHandler operation = this.registry.getRestHandler(path, "GET");
        PersonImpl data = new PersonImpl();
        EasyMock.expect((Object)this.personService.getPerson((UserId)EasyMock.eq((Object)JOHN_DOE.iterator().next()), (Set)EasyMock.eq(DEFAULT_FIELDS), (SecurityToken)EasyMock.eq((Object)this.token))).andReturn((Object)ImmediateFuture.newInstance((Object)data));
        this.replay();
        PersonHandlerTest.assertEquals((Object)data, operation.execute((Map)Maps.newHashMap(), null, (SecurityToken)this.token, (BeanConverter)this.converter).get());
        this.verify();
    }

    @Test
    public void testHandleGetPlural() throws Exception {
        String path = "/people/john.doe,jane.doe/@self";
        RestHandler operation = this.registry.getRestHandler(path, "GET");
        ImmutableList people = ImmutableList.of();
        RestfulCollection data = new RestfulCollection((List)people);
        LinkedHashSet userIdSet = Sets.newLinkedHashSet(JOHN_DOE);
        userIdSet.add(new UserId(UserId.Type.userId, "jane.doe"));
        EasyMock.expect((Object)this.personService.getPeople((Set)EasyMock.eq((Object)userIdSet), (GroupId)EasyMock.eq((Object)new GroupId(GroupId.Type.self, null)), (CollectionOptions)EasyMock.eq((Object)DEFAULT_OPTIONS), (Set)EasyMock.eq(DEFAULT_FIELDS), (SecurityToken)EasyMock.eq((Object)this.token))).andReturn((Object)ImmediateFuture.newInstance((Object)data));
        this.replay();
        PersonHandlerTest.assertEquals((Object)data, operation.execute((Map)Maps.newHashMap(), null, (SecurityToken)this.token, (BeanConverter)this.converter).get());
        this.verify();
    }

    @Test
    public void testHandlePut() throws Exception {
        String jsonPerson = "{person: {aboutMe: 'A person'}}";
        String path = "/people/john.doe/@self";
        RestHandler operation = this.registry.getRestHandler(path, "PUT");
        PersonImpl person = new PersonImpl();
        EasyMock.expect((Object)this.converter.convertToObject((String)EasyMock.eq((Object)jsonPerson), (Class)EasyMock.eq(Person.class))).andReturn((Object)person);
        EasyMock.expect((Object)this.personService.updatePerson((UserId)EasyMock.eq((Object)JOHN_DOE.iterator().next()), (Person)EasyMock.eq((Object)person), (SecurityToken)EasyMock.eq((Object)this.token))).andReturn((Object)ImmediateFuture.newInstance((Object)person));
        this.replay();
        PersonHandlerTest.assertEquals((Object)person, operation.execute((Map)Maps.newHashMap(), (Reader)new StringReader(jsonPerson), (SecurityToken)this.token, (BeanConverter)this.converter).get());
        this.verify();
    }

    @Test
    public void testHandleGetSupportedFields() throws Exception {
        String path = "/people/@supportedFields";
        RestHandler operation = this.registry.getRestHandler(path, "GET");
        this.replay();
        List received = (List)operation.execute((Map)Maps.newHashMap(), null, (SecurityToken)this.token, (BeanConverter)this.converter).get();
        PersonHandlerTest.assertEquals((long)2L, (long)received.size());
        PersonHandlerTest.assertEquals((Object)"id", (Object)received.get(0).toString());
        Map map = (Map)received.get(1);
        PersonHandlerTest.assertEquals((Object)"familyName", (Object)map.get("name").toString());
        this.verify();
    }

    static {
        DEFAULT_OPTIONS.setSortBy("topFriends");
        DEFAULT_OPTIONS.setSortOrder(SortOrder.ascending);
        DEFAULT_OPTIONS.setFilter(null);
        DEFAULT_OPTIONS.setFilterOperation(FilterOperation.contains);
        DEFAULT_OPTIONS.setFilterValue("");
        DEFAULT_OPTIONS.setFirst(0);
        DEFAULT_OPTIONS.setMax(20);
    }
}

