/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.testing.FakeGadgetToken;
import org.apache.shindig.common.util.ImmediateFuture;
import org.apache.shindig.protocol.DefaultHandlerRegistry;
import org.apache.shindig.protocol.HandlerExecutionListener;
import org.apache.shindig.protocol.HandlerRegistry;
import org.apache.shindig.protocol.RestHandler;
import org.apache.shindig.protocol.conversion.BeanConverter;
import org.apache.shindig.protocol.conversion.BeanJsonConverter;
import org.apache.shindig.social.core.model.MessageImpl;
import org.apache.shindig.social.opensocial.model.Message;
import org.apache.shindig.social.opensocial.service.MessageHandler;
import org.apache.shindig.social.opensocial.spi.MessageService;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class MessageHandlerTest
extends Assert {
    private MessageService messageService;
    private MessageHandler handler;
    private BeanJsonConverter converter;
    private FakeGadgetToken token;
    private UserId sender;
    private List<String> recipients;
    protected HandlerRegistry registry;

    @Before
    public void setUp() throws Exception {
        this.token = new FakeGadgetToken();
        this.messageService = (MessageService)EasyMock.createMock(MessageService.class);
        this.messageService = (MessageService)EasyMock.createMock(MessageService.class);
        this.converter = (BeanJsonConverter)EasyMock.createMock(BeanJsonConverter.class);
        this.sender = new UserId(UserId.Type.userId, "message.sender");
        this.recipients = ImmutableList.of((Object)"second.recipient", (Object)"first.recipient");
        this.handler = new MessageHandler(this.messageService);
        this.registry = new DefaultHandlerRegistry(null, this.converter, (HandlerExecutionListener)new HandlerExecutionListener.NoOpHandler());
        this.registry.addHandlers((Set)ImmutableSet.of((Object)this.handler));
    }

    @Test
    @Ignore
    public void testPostMessage() throws Exception {
        MessageImpl message = new MessageImpl("A message body", "A title", Message.Type.PRIVATE_MESSAGE);
        message.setRecipients(this.recipients);
        EasyMock.expect((Object)this.converter.convertToObject(null, Message.class)).andReturn((Object)message);
        EasyMock.expect((Object)this.messageService.createMessage(this.sender, "messageHandlerTest", "@outbox", (Message)message, (SecurityToken)this.token)).andReturn((Object)ImmediateFuture.newInstance((Object)null));
        EasyMock.replay((Object[])new Object[]{this.messageService, this.converter});
        RestHandler operation = this.registry.getRestHandler("/messages/" + this.sender.getUserId() + "/@outbox", "POST");
        ImmutableMap params = ImmutableMap.of((Object)"appId", (Object)new String[]{"messageHandlerTest"});
        operation.execute((Map)params, null, (SecurityToken)this.token, (BeanConverter)this.converter).get();
        EasyMock.verify((Object[])new Object[]{this.converter, this.messageService});
    }
}

