/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.EasyMockTestCase;
import org.apache.shindig.common.testing.FakeGadgetToken;
import org.apache.shindig.common.util.ImmediateFuture;
import org.apache.shindig.protocol.DataCollection;
import org.apache.shindig.protocol.DefaultHandlerRegistry;
import org.apache.shindig.protocol.HandlerExecutionListener;
import org.apache.shindig.protocol.HandlerRegistry;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RestHandler;
import org.apache.shindig.protocol.conversion.BeanConverter;
import org.apache.shindig.protocol.conversion.BeanJsonConverter;
import org.apache.shindig.social.opensocial.service.AppDataHandler;
import org.apache.shindig.social.opensocial.spi.AppDataService;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;

public class AppDataHandlerTest
extends EasyMockTestCase {
    private BeanJsonConverter converter;
    private AppDataService appDataService;
    private FakeGadgetToken token;
    protected HandlerRegistry registry;
    private static final Set<UserId> JOHN_DOE = Collections.unmodifiableSet(ImmutableSet.of((Object)new UserId(UserId.Type.userId, "john.doe")));

    @Before
    public void setUp() throws Exception {
        this.token = new FakeGadgetToken();
        this.converter = (BeanJsonConverter)this.mock(BeanJsonConverter.class);
        this.appDataService = (AppDataService)this.mock(AppDataService.class);
        AppDataHandler handler = new AppDataHandler(this.appDataService);
        this.registry = new DefaultHandlerRegistry(null, this.converter, (HandlerExecutionListener)new HandlerExecutionListener.NoOpHandler());
        this.registry.addHandlers((Set)ImmutableSet.of((Object)handler));
    }

    private void assertHandleGetForGroup(GroupId.Type group) throws Exception {
        String path = "/appdata/john.doe/@" + group.toString() + "/appId";
        RestHandler operation = this.registry.getRestHandler(path, "GET");
        DataCollection data = new DataCollection(null);
        EasyMock.expect((Object)this.appDataService.getPersonData((Set)EasyMock.eq(JOHN_DOE), (GroupId)EasyMock.eq((Object)new GroupId(group, null)), (String)EasyMock.eq((Object)"appId"), (Set)EasyMock.eq((Object)ImmutableSet.of()), (SecurityToken)EasyMock.eq((Object)this.token))).andReturn((Object)ImmediateFuture.newInstance((Object)data));
        this.replay();
        AppDataHandlerTest.assertEquals((Object)data, operation.execute((Map)Maps.newHashMap(), null, (SecurityToken)this.token, (BeanConverter)this.converter).get());
        this.verify();
    }

    @Test
    public void testHandleGetAll() throws Exception {
        this.assertHandleGetForGroup(GroupId.Type.all);
    }

    @Test
    public void testHandleGetFriends() throws Exception {
        this.assertHandleGetForGroup(GroupId.Type.friends);
    }

    @Test
    public void testHandleGetSelf() throws Exception {
        this.assertHandleGetForGroup(GroupId.Type.self);
    }

    @Test
    public void testHandleGetPlural() throws Exception {
        String path = "/appdata/john.doe,jane.doe/@self/appId";
        RestHandler operation = this.registry.getRestHandler(path, "GET");
        DataCollection data = new DataCollection(null);
        LinkedHashSet userIdSet = Sets.newLinkedHashSet(JOHN_DOE);
        userIdSet.add(new UserId(UserId.Type.userId, "jane.doe"));
        EasyMock.expect((Object)this.appDataService.getPersonData((Set)EasyMock.eq((Object)userIdSet), (GroupId)EasyMock.eq((Object)new GroupId(GroupId.Type.self, null)), (String)EasyMock.eq((Object)"appId"), (Set)EasyMock.eq((Object)ImmutableSet.of()), (SecurityToken)EasyMock.eq((Object)this.token))).andReturn((Object)ImmediateFuture.newInstance((Object)data));
        this.replay();
        AppDataHandlerTest.assertEquals((Object)data, operation.execute((Map)Maps.newHashMap(), null, (SecurityToken)this.token, (BeanConverter)this.converter).get());
        this.verify();
    }

    @Test
    public void testHandleGetWithoutFields() throws Exception {
        String path = "/appdata/john.doe/@friends/appId";
        RestHandler operation = this.registry.getRestHandler(path, "GET");
        HashMap params = Maps.newHashMap();
        params.put("fields", new String[]{"pandas"});
        DataCollection data = new DataCollection(null);
        EasyMock.expect((Object)this.appDataService.getPersonData((Set)EasyMock.eq(JOHN_DOE), (GroupId)EasyMock.eq((Object)new GroupId(GroupId.Type.friends, null)), (String)EasyMock.eq((Object)"appId"), (Set)EasyMock.eq((Object)ImmutableSet.of((Object)"pandas")), (SecurityToken)EasyMock.eq((Object)this.token))).andReturn((Object)ImmediateFuture.newInstance((Object)data));
        this.replay();
        AppDataHandlerTest.assertEquals((Object)data, operation.execute((Map)params, null, (SecurityToken)this.token, (BeanConverter)this.converter).get());
        this.verify();
    }

    private Future<?> setupPostData(String method) throws ProtocolException {
        String path = "/appdata/john.doe/@self/appId";
        RestHandler operation = this.registry.getRestHandler(path, method);
        String jsonAppData = "{pandas: 'are fuzzy'}";
        HashMap params = Maps.newHashMap();
        params.put("fields", new String[]{"pandas"});
        HashMap values = Maps.newHashMap();
        EasyMock.expect((Object)this.converter.convertToObject((String)EasyMock.eq((Object)jsonAppData), (Class)EasyMock.eq(Map.class))).andReturn((Object)values);
        EasyMock.expect((Object)this.appDataService.updatePersonData((UserId)EasyMock.eq((Object)JOHN_DOE.iterator().next()), (GroupId)EasyMock.eq((Object)new GroupId(GroupId.Type.self, null)), (String)EasyMock.eq((Object)"appId"), (Set)EasyMock.eq((Object)ImmutableSet.of((Object)"pandas")), (Map)EasyMock.eq((Object)values), (SecurityToken)EasyMock.eq((Object)this.token))).andReturn((Object)ImmediateFuture.newInstance((Object)null));
        this.replay();
        return operation.execute((Map)params, (Reader)new StringReader(jsonAppData), (SecurityToken)this.token, (BeanConverter)this.converter);
    }

    @Test
    public void testHandlePost() throws Exception {
        AppDataHandlerTest.assertNull(this.setupPostData("POST").get());
        this.verify();
    }

    @Test
    public void testHandlePut() throws Exception {
        AppDataHandlerTest.assertNull(this.setupPostData("PUT").get());
        this.verify();
    }

    @Test
    public void testHandleNullPostDataKeys() throws Exception {
        String path = "/appdata/john.doe/@self/appId";
        RestHandler operation = this.registry.getRestHandler(path, "POST");
        String jsonAppData = "{pandas: 'are fuzzy'}";
        HashMap params = Maps.newHashMap();
        params.put("fields", new String[]{"pandas"});
        HashMap values = Maps.newHashMap();
        values.put("Aokkey", "an ok key");
        values.put("", "an empty value");
        EasyMock.expect((Object)this.converter.convertToObject((String)EasyMock.eq((Object)jsonAppData), (Class)EasyMock.eq(Map.class))).andReturn((Object)values);
        this.replay();
        try {
            operation.execute((Map)params, (Reader)new StringReader(jsonAppData), (SecurityToken)this.token, (BeanConverter)this.converter).get();
            AppDataHandlerTest.fail();
        }
        catch (ExecutionException ee) {
            AppDataHandlerTest.assertEquals((long)400L, (long)((ProtocolException)ee.getCause()).getCode());
        }
        this.verify();
    }

    @Test
    public void testHandleInvalidPostDataKeys() throws Exception {
        String path = "/appdata/john.doe/@self/appId";
        RestHandler operation = this.registry.getRestHandler(path, "POST");
        String jsonAppData = "{pandas: 'are fuzzy'}";
        HashMap params = Maps.newHashMap();
        params.put("fields", new String[]{"pandas"});
        HashMap values = Maps.newHashMap();
        values.put("Aokkey", "an ok key");
        values.put("a bad key", "a good value");
        EasyMock.expect((Object)this.converter.convertToObject((String)EasyMock.eq((Object)jsonAppData), (Class)EasyMock.eq(Map.class))).andReturn((Object)values);
        this.replay();
        try {
            operation.execute((Map)params, (Reader)new StringReader(jsonAppData), (SecurityToken)this.token, (BeanConverter)this.converter).get();
            AppDataHandlerTest.fail();
        }
        catch (ExecutionException ee) {
            AppDataHandlerTest.assertEquals((long)400L, (long)((ProtocolException)ee.getCause()).getCode());
        }
        this.verify();
    }

    @Test
    public void testHandleDelete() throws Exception {
        HashMap params = Maps.newHashMap();
        params.put("fields", new String[]{"pandas"});
        String path = "/appdata/john.doe/@self/appId";
        RestHandler operation = this.registry.getRestHandler(path, "DELETE");
        EasyMock.expect((Object)this.appDataService.deletePersonData((UserId)EasyMock.eq((Object)JOHN_DOE.iterator().next()), (GroupId)EasyMock.eq((Object)new GroupId(GroupId.Type.self, null)), (String)EasyMock.eq((Object)"appId"), (Set)EasyMock.eq((Object)ImmutableSet.of((Object)"pandas")), (SecurityToken)EasyMock.eq((Object)this.token))).andReturn((Object)ImmediateFuture.newInstance((Object)null));
        this.replay();
        AppDataHandlerTest.assertNull(operation.execute((Map)params, null, (SecurityToken)this.token, (BeanConverter)this.converter).get());
        this.verify();
    }
}

