/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.EasyMockTestCase;
import org.apache.shindig.common.testing.FakeGadgetToken;
import org.apache.shindig.common.util.ImmediateFuture;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.config.JsonContainerConfig;
import org.apache.shindig.expressions.Expressions;
import org.apache.shindig.protocol.DefaultHandlerRegistry;
import org.apache.shindig.protocol.HandlerExecutionListener;
import org.apache.shindig.protocol.HandlerRegistry;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RestHandler;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.protocol.conversion.BeanConverter;
import org.apache.shindig.protocol.conversion.BeanJsonConverter;
import org.apache.shindig.social.core.model.ActivityEntryImpl;
import org.apache.shindig.social.opensocial.model.ActivityEntry;
import org.apache.shindig.social.opensocial.service.ActivityStreamHandler;
import org.apache.shindig.social.opensocial.spi.ActivityStreamService;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.easymock.EasyMock;
import org.json.JSONObject;
import org.junit.Before;
import org.junit.Test;

public class ActivityStreamHandlerTest
extends EasyMockTestCase {
    private BeanJsonConverter converter;
    private ActivityStreamService service;
    private ActivityStreamHandler handler;
    private FakeGadgetToken token;
    private static final Set<UserId> JOHN_DOE = ImmutableSet.of((Object)new UserId(UserId.Type.userId, "john.doe"));
    protected HandlerRegistry registry;
    protected ContainerConfig containerConfig;

    @Before
    public void setUp() throws Exception {
        this.token = new FakeGadgetToken();
        this.token.setAppId("appId");
        this.converter = (BeanJsonConverter)this.mock(BeanJsonConverter.class);
        this.service = (ActivityStreamService)this.mock(ActivityStreamService.class);
        JSONObject config = new JSONObject("{default:{'gadgets.container': ['default'],'gadgets.features':{opensocial:{supportedFields: {activityEntry: ['id', 'title']}}}}}");
        this.containerConfig = new JsonContainerConfig(config, Expressions.forTesting());
        this.handler = new ActivityStreamHandler(this.service, this.containerConfig);
        this.registry = new DefaultHandlerRegistry(null, this.converter, (HandlerExecutionListener)new HandlerExecutionListener.NoOpHandler());
        this.registry.addHandlers((Set)ImmutableSet.of((Object)this.handler));
    }

    private void assertHandleGetForGroup(GroupId.Type group) throws Exception {
        String path = "/activitystreams/john.doe/@" + group.toString();
        RestHandler operation = this.registry.getRestHandler(path, "GET");
        ImmutableList entries = ImmutableList.of();
        RestfulCollection data = new RestfulCollection((List)entries);
        EasyMock.expect((Object)this.service.getActivityEntries((Set)EasyMock.eq(JOHN_DOE), (GroupId)EasyMock.eq((Object)new GroupId(group, null)), (String)EasyMock.isNull(), (Set)EasyMock.eq((Object)ImmutableSet.of()), (CollectionOptions)EasyMock.isA(CollectionOptions.class), (SecurityToken)EasyMock.eq((Object)this.token))).andReturn((Object)ImmediateFuture.newInstance((Object)data));
        this.replay();
        ActivityStreamHandlerTest.assertEquals((Object)data, operation.execute((Map)Maps.newHashMap(), null, (SecurityToken)this.token, (BeanConverter)this.converter).get());
        this.verify();
        this.reset();
    }

    @Test
    public void testHandleGetAll() throws Exception {
        this.assertHandleGetForGroup(GroupId.Type.all);
    }

    @Test
    public void testHandleGetFriends() throws Exception {
        this.assertHandleGetForGroup(GroupId.Type.friends);
    }

    @Test
    public void testHandleGetSelf() throws Exception {
        this.assertHandleGetForGroup(GroupId.Type.self);
    }

    @Test
    public void testHandleGetPlural() throws Exception {
        String path = "/activitystreams/john.doe,jane.doe/@self/@app";
        RestHandler operation = this.registry.getRestHandler(path, "GET");
        ImmutableList entries = ImmutableList.of();
        RestfulCollection data = new RestfulCollection((List)entries);
        LinkedHashSet userIdSet = Sets.newLinkedHashSet(JOHN_DOE);
        userIdSet.add(new UserId(UserId.Type.userId, "jane.doe"));
        EasyMock.expect((Object)this.service.getActivityEntries((Set)EasyMock.eq((Object)userIdSet), (GroupId)EasyMock.eq((Object)new GroupId(GroupId.Type.self, null)), (String)EasyMock.eq((Object)"appId"), (Set)EasyMock.eq((Object)ImmutableSet.of()), (CollectionOptions)EasyMock.isA(CollectionOptions.class), (SecurityToken)EasyMock.eq((Object)this.token))).andReturn((Object)ImmediateFuture.newInstance((Object)data));
        this.replay();
        ActivityStreamHandlerTest.assertEquals((Object)data, operation.execute((Map)Maps.newHashMap(), null, (SecurityToken)this.token, (BeanConverter)this.converter).get());
        this.verify();
        this.reset();
    }

    @Test
    public void testHandleGetActivityEntryById() throws Exception {
        String path = "/activitystreams/john.doe/@friends/@app/myObjectId123";
        RestHandler operation = this.registry.getRestHandler(path, "GET");
        ActivityEntryImpl entry = new ActivityEntryImpl();
        EasyMock.expect((Object)this.service.getActivityEntry((UserId)EasyMock.eq((Object)JOHN_DOE.iterator().next()), (GroupId)EasyMock.eq((Object)new GroupId(GroupId.Type.friends, null)), (String)EasyMock.eq((Object)"appId"), (Set)EasyMock.eq((Object)ImmutableSet.of()), (String)EasyMock.eq((Object)"myObjectId123"), (SecurityToken)EasyMock.eq((Object)this.token))).andReturn((Object)ImmediateFuture.newInstance((Object)entry));
        this.replay();
        ActivityStreamHandlerTest.assertEquals((Object)entry, operation.execute((Map)Maps.newHashMap(), null, (SecurityToken)this.token, (BeanConverter)this.converter).get());
        this.verify();
        this.reset();
    }

    private Future<?> setupBodyRequest(String method) throws ProtocolException {
        String jsonActivityEntry = "{title: 'hi mom!', object: {id: 'testObject'}}";
        String path = "/activitystreams/john.doe/@self/@app";
        RestHandler operation = this.registry.getRestHandler(path, method);
        ActivityEntryImpl entry = new ActivityEntryImpl();
        EasyMock.expect((Object)this.converter.convertToObject((String)EasyMock.eq((Object)jsonActivityEntry), (Class)EasyMock.eq(ActivityEntry.class))).andReturn((Object)entry);
        EasyMock.expect((Object)this.service.createActivityEntry((UserId)EasyMock.eq((Object)JOHN_DOE.iterator().next()), (GroupId)EasyMock.eq((Object)new GroupId(GroupId.Type.self, null)), (String)EasyMock.eq((Object)"appId"), (Set)EasyMock.eq((Object)ImmutableSet.of()), (ActivityEntry)EasyMock.eq((Object)entry), (SecurityToken)EasyMock.eq((Object)this.token))).andReturn((Object)ImmediateFuture.newInstance((Object)null));
        this.replay();
        return operation.execute((Map)Maps.newHashMap(), (Reader)new StringReader(jsonActivityEntry), (SecurityToken)this.token, (BeanConverter)this.converter);
    }

    @Test
    public void testHandlePost() throws Exception {
        String jsonActivityEntry = "{title: 'hi mom!', object: {id: 'testObject'}}";
        String path = "/activitystreams/john.doe/@self/@app";
        RestHandler operation = this.registry.getRestHandler(path, "POST");
        ActivityEntryImpl entry = new ActivityEntryImpl();
        EasyMock.expect((Object)this.converter.convertToObject((String)EasyMock.eq((Object)jsonActivityEntry), (Class)EasyMock.eq(ActivityEntry.class))).andReturn((Object)entry);
        EasyMock.expect((Object)this.service.createActivityEntry((UserId)EasyMock.eq((Object)JOHN_DOE.iterator().next()), (GroupId)EasyMock.eq((Object)new GroupId(GroupId.Type.self, null)), (String)EasyMock.eq((Object)"appId"), (Set)EasyMock.eq((Object)ImmutableSet.of()), (ActivityEntry)EasyMock.eq((Object)entry), (SecurityToken)EasyMock.eq((Object)this.token))).andReturn((Object)ImmediateFuture.newInstance((Object)null));
        this.replay();
        Future future = operation.execute((Map)Maps.newHashMap(), (Reader)new StringReader(jsonActivityEntry), (SecurityToken)this.token, (BeanConverter)this.converter);
        ActivityStreamHandlerTest.assertNull(future.get());
        this.verify();
        this.reset();
    }

    @Test
    public void testHandlePut() throws Exception {
        String jsonActivityEntry = "{title: 'hi mom!', object: {id: 'testObject'}}";
        String path = "/activitystreams/john.doe/@self/@app/testObject";
        RestHandler operation = this.registry.getRestHandler(path, "PUT");
        ActivityEntryImpl entry = new ActivityEntryImpl();
        EasyMock.expect((Object)this.converter.convertToObject((String)EasyMock.eq((Object)jsonActivityEntry), (Class)EasyMock.eq(ActivityEntry.class))).andReturn((Object)entry);
        EasyMock.expect((Object)this.service.updateActivityEntry((UserId)EasyMock.eq((Object)JOHN_DOE.iterator().next()), (GroupId)EasyMock.eq((Object)new GroupId(GroupId.Type.self, null)), (String)EasyMock.eq((Object)"appId"), (Set)EasyMock.eq((Object)ImmutableSet.of()), (ActivityEntry)EasyMock.eq((Object)entry), (String)EasyMock.eq((Object)"testObject"), (SecurityToken)EasyMock.eq((Object)this.token))).andReturn((Object)ImmediateFuture.newInstance((Object)null));
        this.replay();
        Future future = operation.execute((Map)Maps.newHashMap(), (Reader)new StringReader(jsonActivityEntry), (SecurityToken)this.token, (BeanConverter)this.converter);
        ActivityStreamHandlerTest.assertNull(future.get());
        this.verify();
        this.reset();
    }

    @Test
    public void testHandleDelete() throws Exception {
        String path = "/activitystreams/john.doe/@self/@app/myObjectId123";
        RestHandler operation = this.registry.getRestHandler(path, "DELETE");
        EasyMock.expect((Object)this.service.deleteActivityEntries((UserId)EasyMock.eq((Object)JOHN_DOE.iterator().next()), (GroupId)EasyMock.eq((Object)new GroupId(GroupId.Type.self, null)), (String)EasyMock.eq((Object)"appId"), (Set)EasyMock.eq((Object)ImmutableSet.of((Object)"myObjectId123")), (SecurityToken)EasyMock.eq((Object)this.token))).andReturn((Object)ImmediateFuture.newInstance((Object)null));
        this.replay();
        ActivityStreamHandlerTest.assertNull(operation.execute((Map)Maps.newHashMap(), null, (SecurityToken)this.token, (BeanConverter)this.converter).get());
        this.verify();
        this.reset();
    }

    @Test
    public void testHandleGetSupportedFields() throws Exception {
        String path = "/activitystreams/@supportedFields";
        RestHandler operation = this.registry.getRestHandler(path, "GET");
        this.replay();
        List received = (List)operation.execute((Map)Maps.newHashMap(), null, (SecurityToken)this.token, (BeanConverter)this.converter).get();
        ActivityStreamHandlerTest.assertEquals((long)2L, (long)received.size());
        ActivityStreamHandlerTest.assertEquals((Object)"id", (Object)received.get(0).toString());
        ActivityStreamHandlerTest.assertEquals((Object)"title", (Object)received.get(1).toString());
        this.verify();
    }
}

