/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.model;

import org.apache.shindig.social.core.model.PersonImpl;
import org.apache.shindig.social.opensocial.model.ListField;
import org.apache.shindig.social.opensocial.model.Person;
import org.apache.shindig.social.opensocial.model.Url;
import org.junit.Assert;
import org.junit.Test;

public class PersonTest
extends Assert {
    @Test
    public void testInvalidFromUrlString() throws Exception {
        PersonTest.assertNull((Object)Person.Field.fromUrlString((String)"badness"));
    }

    @Test
    public void testFromUrlString() throws Exception {
        this.assertUrlStringMaps(Person.Field.NAME);
        this.assertUrlStringMaps(Person.Field.THUMBNAIL_URL);
    }

    private void assertUrlStringMaps(Person.Field field) {
        PersonTest.assertEquals((Object)field, (Object)Person.Field.fromUrlString((String)field.toString()));
    }

    @Test
    public void testGetProfileUrl() throws Exception {
        PersonImpl person = new PersonImpl();
        PersonTest.assertNull((Object)person.getProfileUrl());
        String address = "hi";
        person.setProfileUrl(address);
        PersonTest.assertEquals((Object)address, (Object)person.getProfileUrl());
        PersonTest.assertEquals((Object)address, (Object)((Url)person.getUrls().get(0)).getValue());
        PersonTest.assertEquals((Object)"profile", (Object)((Url)person.getUrls().get(0)).getType());
        PersonTest.assertNull((Object)((Url)person.getUrls().get(0)).getLinkText());
        address = "something new";
        person.setProfileUrl(address);
        PersonTest.assertEquals((Object)address, (Object)person.getProfileUrl());
        PersonTest.assertEquals((long)1L, (long)person.getUrls().size());
        PersonTest.assertEquals((Object)address, (Object)((Url)person.getUrls().get(0)).getValue());
    }

    @Test
    public void testGetThumbnailUrl() throws Exception {
        PersonImpl person = new PersonImpl();
        PersonTest.assertNull((Object)person.getThumbnailUrl());
        String url = "hi";
        person.setThumbnailUrl(url);
        PersonTest.assertEquals((Object)url, (Object)person.getThumbnailUrl());
        PersonTest.assertEquals((Object)url, (Object)((ListField)person.getPhotos().get(0)).getValue());
        PersonTest.assertEquals((Object)"thumbnail", (Object)((ListField)person.getPhotos().get(0)).getType());
        url = "something new";
        person.setThumbnailUrl(url);
        PersonTest.assertEquals((Object)url, (Object)person.getThumbnailUrl());
        PersonTest.assertEquals((long)1L, (long)person.getPhotos().size());
        PersonTest.assertEquals((Object)url, (Object)((ListField)person.getPhotos().get(0)).getValue());
    }
}

