/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.dataservice.integration;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TestUtils {
    public static String loadTestFixture(String path) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(path)));
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        return sb.toString();
    }

    public static boolean jsonsEqual(String json1, String json2) throws Exception {
        Object obj1Converted = TestUtils.convertJsonElement(new JSONObject(json1));
        Object obj2Converted = TestUtils.convertJsonElement(new JSONObject(json2));
        return obj1Converted.equals(obj2Converted);
    }

    public static boolean xmlsEqual(String xml1, String xml2) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc1 = db.parse(new InputSource(new StringReader(xml1)));
        Document doc2 = db.parse(new InputSource(new StringReader(xml2)));
        Set<Object> childSet1 = TestUtils.getChildSet(doc1.getDocumentElement(), "");
        Set<Object> childSet2 = TestUtils.getChildSet(doc2.getDocumentElement(), "");
        return ((Object)childSet1).equals(childSet2);
    }

    private static Object convertJsonElement(Object elem) throws JSONException {
        if (elem instanceof JSONObject) {
            JSONObject obj = (JSONObject)elem;
            Iterator keys = obj.keys();
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                jsonMap.put(key, TestUtils.convertJsonElement(obj.get(key)));
            }
            return jsonMap;
        }
        if (elem instanceof JSONArray) {
            JSONArray arr = (JSONArray)elem;
            HashSet<Object> jsonSet = new HashSet<Object>();
            for (int i = 0; i < arr.length(); ++i) {
                jsonSet.add(TestUtils.convertJsonElement(arr.get(i)));
            }
            return jsonSet;
        }
        return elem;
    }

    private static Set<Object> getChildSet(Node node, String basePath) {
        HashSet<Object> childSet = new HashSet<Object>();
        if (!node.hasChildNodes() && !node.getTextContent().trim().equals("")) {
            childSet.add(basePath + ":" + node.getTextContent());
        } else {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                childSet.add(TestUtils.getChildSet(children.item(i), basePath + "/" + node.getNodeName()));
            }
        }
        return childSet;
    }
}

