/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.dataservice.integration;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.shindig.social.dataservice.integration.AbstractLargeRestfulTests;
import org.apache.shindig.social.opensocial.util.XSDValidator;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Test;
import org.w3c.dom.NodeList;

public class RestfulXmlDataTest
extends AbstractLargeRestfulTests {
    @Test
    public void testGetFriendsAppDataJson() throws Exception {
        ImmutableMap extraParams = ImmutableMap.of((Object)"fields", (Object)"count");
        String resp = this.getResponse("/appdata/john.doe/@friends/app", "GET", (Map<String, String>)extraParams, "xml", "application/xml");
        XSDValidator.validateOpenSocial(resp);
        NodeList result = this.xp.getMatchingNodes("/:appdata/:entry", XMLUnit.buildTestDocument((String)resp));
        RestfulXmlDataTest.assertEquals((long)3L, (long)result.getLength());
        Map<String, Map<String, List<String>>> v = this.childNodesToMapofMap(result);
        RestfulXmlDataTest.assertEquals((long)3L, (long)v.size());
        RestfulXmlDataTest.assertTrue((boolean)v.containsKey("jane.doe"));
        RestfulXmlDataTest.assertTrue((boolean)v.containsKey("george.doe"));
        RestfulXmlDataTest.assertTrue((boolean)v.containsKey("maija.m"));
        RestfulXmlDataTest.assertEquals((long)1L, (long)v.get("jane.doe").size());
        RestfulXmlDataTest.assertEquals((long)1L, (long)v.get("george.doe").size());
        RestfulXmlDataTest.assertEquals((long)0L, (long)v.get("maija.m").size());
        RestfulXmlDataTest.assertEquals((Object)"7", (Object)v.get("jane.doe").get("count").get(0));
        RestfulXmlDataTest.assertEquals((Object)"2", (Object)v.get("george.doe").get("count").get(0));
    }

    @Test
    public void testGetSelfAppDataJson() throws Exception {
        HashMap extraParams = Maps.newHashMap();
        extraParams.put("fields", null);
        String resp = this.getResponse("/appdata/john.doe/@self/app", "GET", extraParams, "xml", "application/xml");
        XSDValidator.validateOpenSocial(resp);
        NodeList result = this.xp.getMatchingNodes("/:appdata/:entry", XMLUnit.buildTestDocument((String)resp));
        Map<String, Map<String, List<String>>> v = this.childNodesToMapofMap(result);
        RestfulXmlDataTest.assertEquals((long)1L, (long)v.size());
        RestfulXmlDataTest.assertTrue((boolean)v.containsKey("john.doe"));
        RestfulXmlDataTest.assertEquals((long)1L, (long)v.get("john.doe").size());
        RestfulXmlDataTest.assertEquals((Object)"0", (Object)v.get("john.doe").get("count").get(0));
    }

    @Test
    public void testGetSelfAppDataJsonWithKey() throws Exception {
        HashMap extraParams = Maps.newHashMap();
        extraParams.put("fields", "count");
        String resp = this.getResponse("/appdata/john.doe/@self/app", "GET", extraParams, "xml", "application/xml");
        XSDValidator.validateOpenSocial(resp);
        NodeList result = this.xp.getMatchingNodes("/:appdata/:entry", XMLUnit.buildTestDocument((String)resp));
        Map<String, Map<String, List<String>>> v = this.childNodesToMapofMap(result);
        RestfulXmlDataTest.assertEquals((long)1L, (long)v.size());
        RestfulXmlDataTest.assertTrue((boolean)v.containsKey("john.doe"));
        RestfulXmlDataTest.assertEquals((long)1L, (long)v.get("john.doe").size());
        RestfulXmlDataTest.assertEquals((Object)"0", (Object)v.get("john.doe").get("count").get(0));
    }

    @Test
    public void testGetSelfAppDataJsonWithInvalidKeys() throws Exception {
        HashMap extraParams = Maps.newHashMap();
        extraParams.put("fields", "peabody");
        String resp = this.getResponse("/appdata/john.doe/@self/app", "GET", extraParams, "xml", "application/xml");
        XSDValidator.validateOpenSocial(resp);
        NodeList result = this.xp.getMatchingNodes("/:appdata/:entry", XMLUnit.buildTestDocument((String)resp));
        Map<String, Map<String, List<String>>> v = this.childNodesToMapofMap(result);
        RestfulXmlDataTest.assertEquals((long)1L, (long)v.size());
        RestfulXmlDataTest.assertTrue((boolean)v.containsKey("john.doe"));
        RestfulXmlDataTest.assertEquals((long)0L, (long)v.get("john.doe").size());
    }

    @Test
    public void testDeleteAppData() throws Exception {
        this.assertCount("0");
        HashMap extraParams = Maps.newHashMap();
        extraParams.put("fields", "peabody");
        String resp = this.getResponse("/appdata/john.doe/@self/app", "DELETE", extraParams, "xml", "application/xml");
        XSDValidator.validateOpenSocial(resp);
        this.assertCount("0");
        extraParams.put("fields", "count");
        this.getResponse("/appdata/john.doe/@self/app", "DELETE", extraParams, "xml", "application/xml");
        XSDValidator.validateOpenSocial(resp);
        this.assertCount(null);
    }

    @Test
    public void testUpdateAppData() throws Exception {
        this.assertCount("0");
        HashMap extraParams = Maps.newHashMap();
        extraParams.put("fields", "count");
        String postData = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<map><entry><key>count</key><value>5</value></entry></map>";
        String resp = this.getResponse("/appdata/john.doe/@self/app", "POST", extraParams, postData, "xml", "application/xml");
        XSDValidator.validateOpenSocial(resp);
        this.assertCount("5");
    }

    private void assertCount(String expectedCount) throws Exception {
        String resp = this.getResponse("/appdata/john.doe/@self/app", "GET", "xml", "application/xml");
        XSDValidator.validateOpenSocial(resp);
        NodeList result = this.xp.getMatchingNodes("/:appdata/:entry", XMLUnit.buildTestDocument((String)resp));
        Map<String, Map<String, List<String>>> v = this.childNodesToMapofMap(result);
        RestfulXmlDataTest.assertEquals((long)1L, (long)v.size());
        RestfulXmlDataTest.assertTrue((boolean)v.containsKey("john.doe"));
        if (expectedCount != null) {
            RestfulXmlDataTest.assertEquals((long)1L, (long)v.get("john.doe").size());
            RestfulXmlDataTest.assertEquals((Object)String.valueOf(expectedCount), (Object)v.get("john.doe").get("count").get(0));
        } else {
            RestfulXmlDataTest.assertEquals((long)0L, (long)v.get("john.doe").size());
        }
    }
}

