/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.dataservice.integration;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.shindig.protocol.model.Enum;
import org.apache.shindig.protocol.model.EnumImpl;
import org.apache.shindig.social.core.model.AddressImpl;
import org.apache.shindig.social.core.model.BodyTypeImpl;
import org.apache.shindig.social.core.model.ListFieldImpl;
import org.apache.shindig.social.core.model.NameImpl;
import org.apache.shindig.social.core.model.OrganizationImpl;
import org.apache.shindig.social.core.model.PersonImpl;
import org.apache.shindig.social.core.model.UrlImpl;
import org.apache.shindig.social.dataservice.integration.AbstractLargeRestfulTests;
import org.apache.shindig.social.opensocial.model.Address;
import org.apache.shindig.social.opensocial.model.BodyType;
import org.apache.shindig.social.opensocial.model.Drinker;
import org.apache.shindig.social.opensocial.model.ListField;
import org.apache.shindig.social.opensocial.model.LookingFor;
import org.apache.shindig.social.opensocial.model.Name;
import org.apache.shindig.social.opensocial.model.NetworkPresence;
import org.apache.shindig.social.opensocial.model.Organization;
import org.apache.shindig.social.opensocial.model.Person;
import org.apache.shindig.social.opensocial.model.Smoker;
import org.apache.shindig.social.opensocial.model.Url;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Before;
import org.junit.Test;

public class RestfulJsonPeopleTest
extends AbstractLargeRestfulTests {
    private Person canonical;

    @Before
    public void restfulJsonPeopleTestBefore() throws Exception {
        NameImpl name = new NameImpl("Sir Shin H. Digg Social Butterfly");
        name.setAdditionalName("H");
        name.setFamilyName("Digg");
        name.setGivenName("Shin");
        name.setHonorificPrefix("Sir");
        name.setHonorificSuffix("Social Butterfly");
        this.canonical = new PersonImpl("canonical", "Shin Digg", (Name)name);
        this.canonical.setAboutMe("I have an example of every piece of data");
        this.canonical.setActivities((List)Lists.newArrayList((Object[])new String[]{"Coding Shindig"}));
        AddressImpl address = new AddressImpl("PoBox 3565, 1 OpenStandards Way, Apache, CA");
        address.setCountry("US");
        address.setLatitude(Float.valueOf(28.3043f));
        address.setLongitude(Float.valueOf(143.0859f));
        address.setLocality("who knows");
        address.setPostalCode("12345");
        address.setRegion("Apache, CA");
        address.setStreetAddress("1 OpenStandards Way");
        address.setType("home");
        address.setFormatted("PoBox 3565, 1 OpenStandards Way, Apache, CA");
        this.canonical.setAddresses((List)Lists.newArrayList((Object[])new Address[]{address}));
        this.canonical.setAge(Integer.valueOf(33));
        BodyTypeImpl bodyType = new BodyTypeImpl();
        bodyType.setBuild("svelte");
        bodyType.setEyeColor("blue");
        bodyType.setHairColor("black");
        bodyType.setHeight(Float.valueOf(1.84f));
        bodyType.setWeight(Float.valueOf(74.0f));
        this.canonical.setBodyType((BodyType)bodyType);
        this.canonical.setBooks((List)Lists.newArrayList((Object[])new String[]{"The Cathedral & the Bazaar", "Catch 22"}));
        this.canonical.setCars((List)Lists.newArrayList((Object[])new String[]{"beetle", "prius"}));
        this.canonical.setChildren("3");
        AddressImpl location = new AddressImpl();
        location.setLatitude(Float.valueOf(48.858192f));
        location.setLongitude(Float.valueOf(2.29419f));
        this.canonical.setCurrentLocation((Address)location);
        this.canonical.setBirthday(new Date());
        this.canonical.setDrinker((Enum)new EnumImpl((Enum.EnumKey)Drinker.SOCIALLY));
        ListFieldImpl email = new ListFieldImpl("work", "dev@shindig.apache.org");
        this.canonical.setEmails((List)Lists.newArrayList((Object[])new ListField[]{email}));
        this.canonical.setEthnicity("developer");
        this.canonical.setFashion("t-shirts");
        this.canonical.setFood((List)Lists.newArrayList((Object[])new String[]{"sushi", "burgers"}));
        this.canonical.setGender(Person.Gender.male);
        this.canonical.setHappiestWhen("coding");
        this.canonical.setHasApp(Boolean.valueOf(true));
        this.canonical.setHeroes((List)Lists.newArrayList((Object[])new String[]{"Doug Crockford", "Charles Babbage"}));
        this.canonical.setHumor("none to speak of");
        this.canonical.setInterests((List)Lists.newArrayList((Object[])new String[]{"PHP", "Java"}));
        this.canonical.setJobInterests("will work for beer");
        OrganizationImpl job1 = new OrganizationImpl();
        job1.setAddress((Address)new AddressImpl("1 Shindig Drive"));
        job1.setDescription("lots of coding");
        job1.setEndDate(new Date());
        job1.setField("Software Engineering");
        job1.setName("Apache.com");
        job1.setSalary("$1000000000");
        job1.setStartDate(new Date());
        job1.setSubField("Development");
        job1.setTitle("Grand PooBah");
        job1.setWebpage("http://shindig.apache.org/");
        job1.setType("job");
        OrganizationImpl job2 = new OrganizationImpl();
        job2.setAddress((Address)new AddressImpl("1 Skid Row"));
        job2.setDescription("");
        job2.setEndDate(new Date());
        job2.setField("College");
        job2.setName("School of hard Knocks");
        job2.setSalary("$100");
        job2.setStartDate(new Date());
        job2.setSubField("Lab Tech");
        job2.setTitle("Gopher");
        job2.setWebpage("");
        job2.setType("job");
        this.canonical.setOrganizations((List)Lists.newArrayList((Object[])new Organization[]{job1, job2}));
        this.canonical.setUpdated(new Date());
        this.canonical.setLanguagesSpoken((List)Lists.newArrayList((Object[])new String[]{"English", "Dutch", "Esperanto"}));
        this.canonical.setLivingArrangement("in a house");
        EnumImpl lookingForRandom = new EnumImpl((Enum.EnumKey)LookingFor.RANDOM, "Random");
        EnumImpl lookingForNetworking = new EnumImpl((Enum.EnumKey)LookingFor.NETWORKING, "Networking");
        this.canonical.setLookingFor((List)Lists.newArrayList((Object[])new Enum[]{lookingForRandom, lookingForNetworking}));
        this.canonical.setMovies((List)Lists.newArrayList((Object[])new String[]{"Iron Man", "Nosferatu"}));
        this.canonical.setMusic((List)Lists.newArrayList((Object[])new String[]{"Chieftains", "Beck"}));
        this.canonical.setNetworkPresence((Enum)new EnumImpl((Enum.EnumKey)NetworkPresence.ONLINE));
        this.canonical.setNickname("diggy");
        this.canonical.setPets("dog,cat");
        this.canonical.setPhoneNumbers((List)Lists.newArrayList((Object[])new ListField[]{new ListFieldImpl("work", "111-111-111"), new ListFieldImpl("mobile", "999-999-999")}));
        this.canonical.setPoliticalViews("open leaning");
        this.canonical.setProfileSong((Url)new UrlImpl("http://www.example.org/songs/OnlyTheLonely.mp3", "Feelin' blue", "road"));
        this.canonical.setProfileVideo((Url)new UrlImpl("http://www.example.org/videos/Thriller.flv", "Thriller", "video"));
        this.canonical.setQuotes((List)Lists.newArrayList((Object[])new String[]{"I am therfore I code", "Doh!"}));
        this.canonical.setRelationshipStatus("married to my job");
        this.canonical.setReligion("druidic");
        this.canonical.setRomance("twice a year");
        this.canonical.setScaredOf("COBOL");
        this.canonical.setSexualOrientation("north");
        this.canonical.setSmoker((Enum)new EnumImpl((Enum.EnumKey)Smoker.NO));
        this.canonical.setSports((List)Lists.newArrayList((Object[])new String[]{"frisbee", "rugby"}));
        this.canonical.setStatus("happy");
        this.canonical.setTags((List)Lists.newArrayList((Object[])new String[]{"C#", "JSON", "template"}));
        this.canonical.setThumbnailUrl("http://www.example.org/pic/?id=1");
        this.canonical.setUtcOffset(Long.valueOf(-8L));
        this.canonical.setTurnOffs((List)Lists.newArrayList((Object[])new String[]{"lack of unit tests", "cabbage"}));
        this.canonical.setTurnOns((List)Lists.newArrayList((Object[])new String[]{"well document code"}));
        this.canonical.setTvShows((List)Lists.newArrayList((Object[])new String[]{"House", "Battlestar Galactica"}));
        this.canonical.setUrls((List)Lists.newArrayList((Object[])new Url[]{new UrlImpl("http://www.example.org/?id=1", "my profile", "Profile"), new UrlImpl("http://www.example.org/pic/?id=1", "my awesome picture", "Thumbnail")}));
    }

    @Test
    public void testGetPersonJson() throws Exception {
        HashMap extraParams = Maps.newHashMap();
        extraParams.put("fields", Joiner.on((char)',').join((Iterable)Person.Field.ALL_FIELDS));
        String resp = this.getResponse("/people/canonical/@self", "GET", extraParams, null, "application/json");
        JSONObject result = this.getJson(resp).getJSONObject("entry");
        this.assertStringField(result, this.canonical.getAboutMe(), Person.Field.ABOUT_ME);
        this.assertStringListField(result, this.canonical.getActivities(), Person.Field.ACTIVITIES);
        JSONObject jsonAddress = result.getJSONArray(Person.Field.ADDRESSES.toString()).getJSONObject(0);
        this.assertAddressField((Address)this.canonical.getAddresses().get(0), jsonAddress);
        RestfulJsonPeopleTest.assertEquals((long)this.canonical.getAge().intValue(), (long)result.getInt(Person.Field.AGE.toString()));
        JSONObject jsonBody = result.getJSONObject(Person.Field.BODY_TYPE.toString());
        BodyType body = this.canonical.getBodyType();
        this.assertStringField(jsonBody, body.getBuild(), BodyType.Field.BUILD);
        this.assertStringField(jsonBody, body.getEyeColor(), BodyType.Field.EYE_COLOR);
        this.assertStringField(jsonBody, body.getHairColor(), BodyType.Field.HAIR_COLOR);
        this.assertFloatField(jsonBody, body.getHeight(), BodyType.Field.HEIGHT);
        this.assertFloatField(jsonBody, body.getWeight(), BodyType.Field.WEIGHT);
        this.assertStringListField(result, this.canonical.getBooks(), Person.Field.BOOKS);
        this.assertStringListField(result, this.canonical.getCars(), Person.Field.CARS);
        this.assertStringField(result, this.canonical.getChildren(), Person.Field.CHILDREN);
        JSONObject currentLocation = result.getJSONObject(Person.Field.CURRENT_LOCATION.toString());
        this.assertFloatField(currentLocation, this.canonical.getCurrentLocation().getLatitude(), Address.Field.LATITUDE);
        this.assertFloatField(currentLocation, this.canonical.getCurrentLocation().getLongitude(), Address.Field.LONGITUDE);
        this.assertStringField(result, this.canonical.getDisplayName(), Person.Field.DISPLAY_NAME);
        JSONArray emailArray = result.getJSONArray(Person.Field.EMAILS.toString());
        RestfulJsonPeopleTest.assertEquals((long)1L, (long)emailArray.length());
        for (int i = 0; i < this.canonical.getEmails().size(); ++i) {
            ListField expectedEmail = (ListField)this.canonical.getEmails().get(i);
            JSONObject actualEmail = emailArray.getJSONObject(i);
            RestfulJsonPeopleTest.assertEquals((Object)expectedEmail.getType(), (Object)actualEmail.getString(ListField.Field.TYPE.toString()));
            RestfulJsonPeopleTest.assertEquals((Object)expectedEmail.getValue(), (Object)actualEmail.getString(ListField.Field.VALUE.toString()));
        }
        this.assertStringField(result, this.canonical.getEthnicity(), Person.Field.ETHNICITY);
        this.assertStringField(result, this.canonical.getFashion(), Person.Field.FASHION);
        this.assertStringListField(result, this.canonical.getFood(), Person.Field.FOOD);
        this.assertStringField(result, this.canonical.getGender().toString(), Person.Field.GENDER);
        this.assertStringField(result, this.canonical.getHappiestWhen(), Person.Field.HAPPIEST_WHEN);
        this.assertBooleanField(result, this.canonical.getHasApp(), Person.Field.HAS_APP);
        this.assertStringListField(result, this.canonical.getHeroes(), Person.Field.HEROES);
        this.assertStringField(result, this.canonical.getHumor(), Person.Field.HUMOR);
        this.assertStringField(result, this.canonical.getId(), Person.Field.ID);
        this.assertStringListField(result, this.canonical.getInterests(), Person.Field.INTERESTS);
        this.assertStringField(result, this.canonical.getJobInterests(), Person.Field.JOB_INTERESTS);
        this.assertOrganizationField((Organization)this.canonical.getOrganizations().get(0), result.getJSONArray(Person.Field.ORGANIZATIONS.toString()).getJSONObject(0));
        this.assertStringListField(result, this.canonical.getLanguagesSpoken(), Person.Field.LANGUAGES_SPOKEN);
        this.assertStringField(result, this.canonical.getLivingArrangement(), Person.Field.LIVING_ARRANGEMENT);
        this.assertListEnumField(result, this.canonical.getLookingFor(), Person.Field.LOOKING_FOR);
        this.assertStringListField(result, this.canonical.getMovies(), Person.Field.MOVIES);
        this.assertStringListField(result, this.canonical.getMusic(), Person.Field.MUSIC);
        RestfulJsonPeopleTest.assertEquals((Object)this.canonical.getName().getFormatted(), (Object)result.getJSONObject(Person.Field.NAME.toString()).getString(Name.Field.FORMATTED.toString()));
        this.assertEnumField(result, this.canonical.getNetworkPresence(), Person.Field.NETWORKPRESENCE);
        this.assertStringField(result, this.canonical.getNickname(), Person.Field.NICKNAME);
        this.assertStringField(result, this.canonical.getPets(), Person.Field.PETS);
        JSONArray phoneArray = result.getJSONArray(Person.Field.PHONE_NUMBERS.toString());
        RestfulJsonPeopleTest.assertEquals((long)this.canonical.getPhoneNumbers().size(), (long)phoneArray.length());
        for (int i = 0; i < this.canonical.getPhoneNumbers().size(); ++i) {
            ListField expectedPhone = (ListField)this.canonical.getPhoneNumbers().get(i);
            JSONObject actualPhone = phoneArray.getJSONObject(i);
            RestfulJsonPeopleTest.assertEquals((Object)expectedPhone.getType(), (Object)actualPhone.getString(ListField.Field.TYPE.toString()));
            RestfulJsonPeopleTest.assertEquals((Object)expectedPhone.getValue(), (Object)actualPhone.getString(ListField.Field.VALUE.toString()));
        }
        this.assertStringField(result, this.canonical.getPoliticalViews(), Person.Field.POLITICAL_VIEWS);
        this.assertUrlField(this.canonical.getProfileSong(), result.getJSONObject(Person.Field.PROFILE_SONG.toString()));
        this.assertStringField(result, this.canonical.getProfileUrl(), Person.Field.PROFILE_URL);
        this.assertUrlField(this.canonical.getProfileVideo(), result.getJSONObject(Person.Field.PROFILE_VIDEO.toString()));
        this.assertStringListField(result, this.canonical.getQuotes(), Person.Field.QUOTES);
        this.assertStringField(result, this.canonical.getRelationshipStatus(), Person.Field.RELATIONSHIP_STATUS);
        this.assertStringField(result, this.canonical.getReligion(), Person.Field.RELIGION);
        this.assertStringField(result, this.canonical.getRomance(), Person.Field.ROMANCE);
        this.assertStringField(result, this.canonical.getScaredOf(), Person.Field.SCARED_OF);
        this.assertStringField(result, this.canonical.getSexualOrientation(), Person.Field.SEXUAL_ORIENTATION);
        this.assertEnumField(result, this.canonical.getSmoker(), Person.Field.SMOKER);
        this.assertStringListField(result, this.canonical.getSports(), Person.Field.SPORTS);
        this.assertStringField(result, this.canonical.getStatus(), Person.Field.STATUS);
        this.assertStringListField(result, this.canonical.getTags(), Person.Field.TAGS);
        this.assertStringField(result, this.canonical.getThumbnailUrl(), Person.Field.THUMBNAIL_URL);
        this.assertStringListField(result, this.canonical.getTurnOffs(), Person.Field.TURN_OFFS);
        this.assertStringListField(result, this.canonical.getTurnOns(), Person.Field.TURN_ONS);
        this.assertStringListField(result, this.canonical.getTvShows(), Person.Field.TV_SHOWS);
    }

    private void assertAddressField(Address expected, JSONObject actual) throws JSONException {
        this.assertStringField(actual, expected.getCountry(), Address.Field.COUNTRY);
        this.assertFloatField(actual, expected.getLatitude(), Address.Field.LATITUDE);
        this.assertStringField(actual, expected.getLocality(), Address.Field.LOCALITY);
        this.assertFloatField(actual, expected.getLongitude(), Address.Field.LONGITUDE);
        this.assertStringField(actual, expected.getPostalCode(), Address.Field.POSTAL_CODE);
        this.assertStringField(actual, expected.getRegion(), Address.Field.REGION);
        this.assertStringField(actual, expected.getStreetAddress(), Address.Field.STREET_ADDRESS);
        this.assertStringField(actual, expected.getType(), Address.Field.TYPE);
        this.assertStringField(actual, expected.getFormatted(), Address.Field.FORMATTED);
    }

    private void assertUrlField(Url expected, JSONObject actual) throws JSONException {
        this.assertStringField(actual, expected.getValue(), Url.Field.VALUE);
        this.assertStringField(actual, expected.getLinkText(), Url.Field.LINK_TEXT);
        this.assertStringField(actual, expected.getType(), Url.Field.TYPE);
    }

    private void assertOrganizationField(Organization expected, JSONObject actual) throws JSONException {
        this.assertStringField(actual.getJSONObject(Organization.Field.ADDRESS.toString()), expected.getAddress().getFormatted(), Address.Field.FORMATTED);
        this.assertStringField(actual, expected.getDescription(), Organization.Field.DESCRIPTION);
        this.assertStringField(actual, expected.getField(), Organization.Field.FIELD);
        this.assertStringField(actual, expected.getName(), Organization.Field.NAME);
        this.assertStringField(actual, expected.getSalary(), Organization.Field.SALARY);
        this.assertStringField(actual, expected.getSubField(), Organization.Field.SUB_FIELD);
        this.assertStringField(actual, expected.getTitle(), Organization.Field.TITLE);
        this.assertStringField(actual, expected.getWebpage(), Organization.Field.WEBPAGE);
        this.assertStringField(actual, expected.getType(), Organization.Field.TYPE);
    }

    private void assertBooleanField(JSONObject result, boolean expected, Object field) throws JSONException {
        RestfulJsonPeopleTest.assertEquals((Object)expected, (Object)result.getBoolean(field.toString()));
    }

    private void assertFloatField(JSONObject result, Float expected, Object field) throws JSONException {
        RestfulJsonPeopleTest.assertEquals((long)expected.intValue(), (long)result.getInt(field.toString()));
    }

    private void assertStringField(JSONObject result, String expected, Object field) throws JSONException {
        RestfulJsonPeopleTest.assertEquals((Object)expected, (Object)result.getString(field.toString()));
    }

    private void assertStringListField(JSONObject result, List<String> list, Person.Field field) throws JSONException {
        JSONArray actual = result.getJSONArray(field.toString());
        RestfulJsonPeopleTest.assertEquals((Object)list.get(0), (Object)actual.getString(0));
    }

    private void assertEnumField(JSONObject result, Enum expected, Person.Field field) throws JSONException {
        JSONObject actual = result.getJSONObject(field.toString());
        RestfulJsonPeopleTest.assertEquals((Object)expected.getDisplayValue(), (Object)actual.getString("displayValue"));
        RestfulJsonPeopleTest.assertEquals((Object)expected.getValue().toString(), (Object)actual.getString("value"));
    }

    private void assertListEnumField(JSONObject result, List<? extends Enum<? extends Enum.EnumKey>> expected, Person.Field field) throws JSONException {
        JSONArray actual = result.getJSONArray(field.toString());
        for (int i = 0; i < actual.length(); ++i) {
            RestfulJsonPeopleTest.assertEquals((Object)expected.get(i).getDisplayValue(), (Object)actual.getJSONObject(i).getString("displayValue"));
            RestfulJsonPeopleTest.assertEquals((Object)expected.get(i).getValue().toString(), (Object)actual.getJSONObject(i).getString("value"));
        }
    }

    @Test
    public void testGetPeople() throws Exception {
        HashMap extraParams = Maps.newHashMap();
        extraParams.put("sortBy", "name");
        extraParams.put("sortOrder", null);
        extraParams.put("filterBy", null);
        extraParams.put("startIndex", null);
        extraParams.put("count", "20");
        extraParams.put("fields", null);
        String resp = this.getResponse("/people/john.doe/@friends", "GET", extraParams, null, "application/json");
        JSONObject result = this.getJson(resp);
        RestfulJsonPeopleTest.assertEquals((long)3L, (long)result.getInt("totalResults"));
        RestfulJsonPeopleTest.assertEquals((long)0L, (long)result.getInt("startIndex"));
        JSONArray people = result.getJSONArray("entry");
        this.assertPerson(people.getJSONObject(0), "george.doe", "George Doe");
        this.assertPerson(people.getJSONObject(1), "jane.doe", "Jane Doe");
    }

    @Test
    public void testGetPeoplePagination() throws Exception {
        HashMap extraParams = Maps.newHashMap();
        extraParams.put("sortBy", "name");
        extraParams.put("sortOrder", null);
        extraParams.put("filterBy", null);
        extraParams.put("startIndex", "0");
        extraParams.put("count", "1");
        extraParams.put("fields", null);
        String resp = this.getResponse("/people/john.doe/@friends", "GET", extraParams, null, "application/json");
        JSONObject result = this.getJson(resp);
        RestfulJsonPeopleTest.assertEquals((long)3L, (long)result.getInt("totalResults"));
        RestfulJsonPeopleTest.assertEquals((long)0L, (long)result.getInt("startIndex"));
        JSONArray people = result.getJSONArray("entry");
        this.assertPerson(people.getJSONObject(0), "george.doe", "George Doe");
        extraParams.put("startIndex", "1");
        resp = this.getResponse("/people/john.doe/@friends", "GET", extraParams, null, "application/json");
        result = this.getJson(resp);
        RestfulJsonPeopleTest.assertEquals((long)3L, (long)result.getInt("totalResults"));
        RestfulJsonPeopleTest.assertEquals((long)1L, (long)result.getInt("startIndex"));
        people = result.getJSONArray("entry");
        this.assertPerson(people.getJSONObject(0), "jane.doe", "Jane Doe");
    }

    private void assertPerson(JSONObject person, String expectedId, String expectedName) throws Exception {
        RestfulJsonPeopleTest.assertEquals((Object)expectedId, (Object)person.getString("id"));
        RestfulJsonPeopleTest.assertEquals((Object)expectedName, (Object)person.getJSONObject("name").getString("formatted"));
    }
}

