/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.dataservice.integration;

import com.google.common.collect.Maps;
import java.util.HashMap;
import org.apache.shindig.social.dataservice.integration.AbstractLargeRestfulTests;
import org.json.JSONObject;
import org.junit.Test;

public class RestfulJsonDataTest
extends AbstractLargeRestfulTests {
    @Test
    public void testGetFriendsAppDataJson() throws Exception {
        HashMap extraParams = Maps.newHashMap();
        extraParams.put("fields", "count");
        String resp = this.getResponse("/appdata/john.doe/@friends/app", "GET", extraParams, null, "application/json");
        JSONObject data = this.getJson(resp).getJSONObject("entry");
        RestfulJsonDataTest.assertEquals((long)3L, (long)data.length());
        JSONObject janesEntries = data.getJSONObject("jane.doe");
        RestfulJsonDataTest.assertEquals((long)1L, (long)janesEntries.length());
        RestfulJsonDataTest.assertEquals((Object)"7", (Object)janesEntries.getString("count"));
        JSONObject georgesEntries = data.getJSONObject("george.doe");
        RestfulJsonDataTest.assertEquals((long)1L, (long)georgesEntries.length());
        RestfulJsonDataTest.assertEquals((Object)"2", (Object)georgesEntries.getString("count"));
    }

    @Test
    public void testGetSelfAppDataJson() throws Exception {
        HashMap extraParams = Maps.newHashMap();
        extraParams.put("fields", null);
        String resp = this.getResponse("/appdata/john.doe/@self/app", "GET", extraParams, null, "application/json");
        JSONObject data = this.getJson(resp).getJSONObject("entry");
        RestfulJsonDataTest.assertEquals((long)1L, (long)data.length());
        JSONObject johnsEntries = data.getJSONObject("john.doe");
        RestfulJsonDataTest.assertEquals((long)1L, (long)johnsEntries.length());
        RestfulJsonDataTest.assertEquals((Object)"0", (Object)johnsEntries.getString("count"));
    }

    @Test
    public void testGetSelfAppDataJsonWithKey() throws Exception {
        HashMap extraParams = Maps.newHashMap();
        extraParams.put("fields", "count");
        String resp = this.getResponse("/appdata/john.doe/@self/app", "GET", extraParams, null, "application/json");
        JSONObject data = this.getJson(resp).getJSONObject("entry");
        RestfulJsonDataTest.assertEquals((long)1L, (long)data.length());
        JSONObject johnsEntries = data.getJSONObject("john.doe");
        RestfulJsonDataTest.assertEquals((long)1L, (long)johnsEntries.length());
        RestfulJsonDataTest.assertEquals((Object)"0", (Object)johnsEntries.getString("count"));
    }

    @Test
    public void testGetSelfAppDataJsonWithInvalidKeys() throws Exception {
        HashMap extraParams = Maps.newHashMap();
        extraParams.put("fields", "peabody");
        String resp = this.getResponse("/appdata/john.doe/@self/app", "GET", extraParams, null, "application/json");
        JSONObject data = this.getJson(resp).getJSONObject("entry");
        RestfulJsonDataTest.assertEquals((long)1L, (long)data.length());
        JSONObject johnsEntries = data.getJSONObject("john.doe");
        RestfulJsonDataTest.assertEquals((long)0L, (long)johnsEntries.length());
    }

    @Test
    public void testDeleteAppData() throws Exception {
        this.assertCount("0");
        HashMap extraParams = Maps.newHashMap();
        extraParams.put("fields", "peabody");
        this.getResponse("/appdata/john.doe/@self/app", "DELETE", extraParams, null, "application/json");
        this.assertCount("0");
        extraParams.put("fields", "count");
        this.getResponse("/appdata/john.doe/@self/app", "DELETE", extraParams, null, "application/json");
        this.assertCount(null);
    }

    @Test
    public void testUpdateAppData() throws Exception {
        this.assertCount("0");
        HashMap extraParams = Maps.newHashMap();
        extraParams.put("fields", "count");
        String postData = "{count : 5}";
        this.getResponse("/appdata/john.doe/@self/app", "POST", extraParams, postData, null, "application/json");
        this.assertCount("5");
    }

    private void assertCount(String expectedCount) throws Exception {
        String resp = this.getResponse("/appdata/john.doe/@self/app", "GET", null, "application/json");
        JSONObject data = this.getJson(resp).getJSONObject("entry");
        RestfulJsonDataTest.assertEquals((long)1L, (long)data.length());
        JSONObject johnsEntries = data.getJSONObject("john.doe");
        if (expectedCount != null) {
            RestfulJsonDataTest.assertEquals((long)1L, (long)johnsEntries.length());
            RestfulJsonDataTest.assertEquals((Object)expectedCount, (Object)johnsEntries.getString("count"));
        } else {
            RestfulJsonDataTest.assertEquals((long)0L, (long)johnsEntries.length());
        }
    }
}

