/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.dataservice.integration;

import org.apache.shindig.social.dataservice.integration.AbstractLargeRestfulTests;
import org.apache.shindig.social.dataservice.integration.TestUtils;
import org.junit.Test;

public class RestfulJsonActivityEntryTest
extends AbstractLargeRestfulTests {
    private static final String FIXTURE_LOC = "src/test/java/org/apache/shindig/social/dataservice/integration/fixtures/";

    @Test
    public void testGetActivityEntryJsonById() throws Exception {
        String resp = this.getResponse("/activitystreams/john.doe/@self/1/activity1", "GET", null, "application/json");
        String expected = TestUtils.loadTestFixture("src/test/java/org/apache/shindig/social/dataservice/integration/fixtures/ActivityEntryJsonId.json");
        RestfulJsonActivityEntryTest.assertTrue((boolean)TestUtils.jsonsEqual(expected, resp));
    }

    @Test
    public void testGetActivityEntryJsonByIds() throws Exception {
        String resp = this.getResponse("/activitystreams/john.doe/@self/1/activity1,activity2", "GET", null, "application/json");
        String expected = TestUtils.loadTestFixture("src/test/java/org/apache/shindig/social/dataservice/integration/fixtures/ActivityEntryJsonIds.json");
        RestfulJsonActivityEntryTest.assertTrue((boolean)TestUtils.jsonsEqual(expected, resp));
    }

    @Test
    public void testGetActivityEntryJsonByGroup() throws Exception {
        String expected = TestUtils.loadTestFixture("src/test/java/org/apache/shindig/social/dataservice/integration/fixtures/ActivityEntryJsonGroup.json");
        String resp = this.getResponse("/activitystreams/john.doe/@self/1", "GET", null, "application/json");
        RestfulJsonActivityEntryTest.assertTrue((boolean)TestUtils.jsonsEqual(expected, resp));
        resp = this.getResponse("/activitystreams/jane.doe,canonical/@friends", "GET", null, "application/json");
        RestfulJsonActivityEntryTest.assertTrue((boolean)TestUtils.jsonsEqual(expected, resp));
    }

    @Test
    public void testDeleteActivityEntryJson() throws Exception {
        this.getResponse("/activitystreams/john.doe/@self/1/activity1", "DELETE", null, "application/json");
        String resp = this.getResponse("/activitystreams/john.doe/@self/1", "GET", null, "application/json");
        String expected = TestUtils.loadTestFixture("src/test/java/org/apache/shindig/social/dataservice/integration/fixtures/ActivityEntryJsonDelete.json");
        RestfulJsonActivityEntryTest.assertTrue((boolean)TestUtils.jsonsEqual(expected, resp));
    }

    @Test
    public void testUpdateActivityEntryJson() throws Exception {
        String expected = TestUtils.loadTestFixture("src/test/java/org/apache/shindig/social/dataservice/integration/fixtures/ActivityEntryJsonUpdated.json");
        String postData = "{id: 'activity2', title : 'Super Updated Activity', actor: {id: 'john.doe'}, object : {id: 'object2'}}";
        String putResp = this.getResponse("/activitystreams/john.doe/@self/1/activity2", "PUT", postData, null, "application/json");
        RestfulJsonActivityEntryTest.assertTrue((boolean)TestUtils.jsonsEqual(expected, putResp));
        String getResp = this.getResponse("/activitystreams/john.doe/@self/1/activity2", "GET", null, "application/json");
        RestfulJsonActivityEntryTest.assertTrue((boolean)TestUtils.jsonsEqual(expected, getResp));
    }

    @Test
    public void testCreateActivityEntryJson() throws Exception {
        String expected = TestUtils.loadTestFixture("src/test/java/org/apache/shindig/social/dataservice/integration/fixtures/ActivityEntryJsonCreated.json");
        String postData = "{id: 'activityCreated', title : 'Super Created Activity', actor: {id: 'john.doe'}, object : {id: 'objectCreated'}}";
        String postResp = this.getResponse("/activitystreams/john.doe/@self/1", "POST", postData, null, "application/json");
        RestfulJsonActivityEntryTest.assertTrue((boolean)TestUtils.jsonsEqual(expected, postResp));
        String getResp = this.getResponse("/activitystreams/john.doe/@self/1/activityCreated", "GET", null, "application/json");
        RestfulJsonActivityEntryTest.assertTrue((boolean)TestUtils.jsonsEqual(expected, getResp));
    }

    @Test
    public void testActivityEntryExtensionJson() throws Exception {
        String expected = TestUtils.loadTestFixture("src/test/java/org/apache/shindig/social/dataservice/integration/fixtures/ActivityEntryJsonExtension.json");
        String postData = "{extension1: 'extension1Value', id: 'activityCreated', title : 'Super Created Activity', actor: {id: 'john.doe', extension2: 'extension2Value'}, object : {extension3: [{ext1: 'ext1Value'}], id: 'objectCreated'}}";
        String postResp = this.getResponse("/activitystreams/john.doe/@self/1", "POST", postData, null, "application/json");
        RestfulJsonActivityEntryTest.assertTrue((boolean)TestUtils.jsonsEqual(expected, postResp));
        String getResp = this.getResponse("/activitystreams/john.doe/@self/1/activityCreated", "GET", null, "application/json");
        RestfulJsonActivityEntryTest.assertTrue((boolean)TestUtils.jsonsEqual(expected, getResp));
    }

    @Test
    public void testGetActivityEntrySupportedFields() throws Exception {
        String resp = this.getResponse("/activitystreams/@supportedFields", "GET", null, "application/json");
        String expected = TestUtils.loadTestFixture("src/test/java/org/apache/shindig/social/dataservice/integration/fixtures/ActivityStreamsSupportedFields.json");
        RestfulJsonActivityEntryTest.assertTrue((boolean)TestUtils.jsonsEqual(expected, resp));
    }
}

