/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.oauth;

import java.util.Arrays;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthProblemException;
import net.oauth.OAuthServiceProvider;
import net.oauth.OAuthValidator;
import net.oauth.SimpleOAuthValidator;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.shindig.auth.AnonymousSecurityToken;
import org.apache.shindig.auth.AuthenticationHandler;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.EasyMockTestCase;
import org.apache.shindig.common.testing.FakeHttpServletRequest;
import org.apache.shindig.common.util.CharsetUtil;
import org.apache.shindig.social.core.oauth.FakeOAuthRequest;
import org.apache.shindig.social.core.oauth.OAuthAuthenticationHandler;
import org.apache.shindig.social.core.oauth.OAuthSecurityToken;
import org.apache.shindig.social.opensocial.oauth.OAuthDataStore;
import org.apache.shindig.social.opensocial.oauth.OAuthEntry;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;

public class OAuthAuthenticationHanderTest
extends EasyMockTestCase {
    OAuthDataStore mockStore = (OAuthDataStore)this.mock(OAuthDataStore.class);
    OAuthValidator validator = new SimpleOAuthValidator();
    OAuthAuthenticationHandler reqHandler;
    private FakeOAuthRequest formEncodedPost;
    private FakeOAuthRequest nonFormEncodedPost;
    private static final String TEST_URL = "http://www.example.org/a/b?x=y";
    private static final String TOKEN = "atoken";
    private static final String APP_ID = "app:12345";
    private static final String DOMAIN = "example.org";
    private static final String CONTAINER = "sandbox";

    @Before
    public void setUp() throws Exception {
        this.reqHandler = new OAuthAuthenticationHandler(this.mockStore, this.validator);
        this.formEncodedPost = new FakeOAuthRequest("POST", TEST_URL, "a=b&c=d", "application/x-www-form-urlencoded");
        this.nonFormEncodedPost = new FakeOAuthRequest("POST", TEST_URL, "BODY", "text/plain");
    }

    private void expectTokenEntry() {
        this.expectTokenEntry(this.createOAuthEntry());
    }

    private void expectTokenEntry(OAuthEntry authEntry) {
        EasyMock.expect((Object)this.mockStore.getEntry((String)EasyMock.eq((Object)TOKEN))).andReturn((Object)authEntry).anyTimes();
    }

    private OAuthEntry createOAuthEntry() {
        OAuthEntry authEntry = new OAuthEntry();
        authEntry.setAppId(APP_ID);
        authEntry.setAuthorized(true);
        authEntry.setConsumerKey("gadget:12345");
        authEntry.setToken(TOKEN);
        authEntry.setTokenSecret("secret");
        authEntry.setType(OAuthEntry.Type.ACCESS);
        authEntry.setUserId("requestor12345");
        authEntry.setIssueTime(new Date());
        authEntry.setDomain(DOMAIN);
        authEntry.setContainer(CONTAINER);
        return authEntry;
    }

    private void expectConsumer() {
        try {
            EasyMock.expect((Object)this.mockStore.getConsumer((String)EasyMock.eq((Object)"gadget:12345"))).andReturn((Object)new OAuthConsumer(null, "gadget:12345", "secret", new OAuthServiceProvider(null, null, null))).anyTimes();
        }
        catch (OAuthProblemException oAuthProblemException) {
            // empty catch block
        }
    }

    private void expectSecurityToken() {
        try {
            EasyMock.expect((Object)this.mockStore.getSecurityTokenForConsumerRequest((String)EasyMock.eq((Object)"gadget:12345"), (String)EasyMock.eq((Object)"requestor12345"))).andReturn((Object)new AnonymousSecurityToken());
        }
        catch (OAuthProblemException oAuthProblemException) {
            // empty catch block
        }
    }

    @Test
    public void testVerifyOAuthRequest() throws Exception {
        this.expectTokenEntry();
        this.expectConsumer();
        this.replay();
        FakeHttpServletRequest request = this.formEncodedPost.sign(TOKEN, FakeOAuthRequest.OAuthParamLocation.URI_QUERY, FakeOAuthRequest.BodySigning.NONE);
        SecurityToken token = this.reqHandler.getSecurityTokenFromRequest((HttpServletRequest)request);
        OAuthAuthenticationHanderTest.assertEquals((Object)"requestor12345", (Object)token.getViewerId());
        OAuthAuthenticationHanderTest.assertEquals((Object)APP_ID, (Object)token.getAppId());
        OAuthAuthenticationHanderTest.assertEquals((Object)DOMAIN, (Object)token.getDomain());
        OAuthAuthenticationHanderTest.assertEquals((Object)CONTAINER, (Object)token.getContainer());
        OAuthAuthenticationHanderTest.assertNotNull((Object)token);
        OAuthAuthenticationHanderTest.assertTrue((boolean)(token instanceof OAuthSecurityToken));
        this.verify();
    }

    @Test
    public void testVerifyGet() throws Exception {
        this.expectTokenEntry();
        this.expectConsumer();
        this.replay();
        FakeOAuthRequest get = new FakeOAuthRequest("GET", TEST_URL, null, null);
        FakeHttpServletRequest request = get.sign(TOKEN, FakeOAuthRequest.OAuthParamLocation.URI_QUERY, FakeOAuthRequest.BodySigning.NONE);
        OAuthAuthenticationHanderTest.assertNotNull((Object)this.reqHandler.getSecurityTokenFromRequest((HttpServletRequest)request));
    }

    @Test
    public void testVerifyGetSignatureInHeader() throws Exception {
        this.expectTokenEntry();
        this.expectConsumer();
        this.replay();
        FakeOAuthRequest get = new FakeOAuthRequest("GET", TEST_URL, null, null);
        FakeHttpServletRequest request = get.sign(TOKEN, FakeOAuthRequest.OAuthParamLocation.AUTH_HEADER, FakeOAuthRequest.BodySigning.NONE);
        OAuthAuthenticationHanderTest.assertNotNull((Object)this.reqHandler.getSecurityTokenFromRequest((HttpServletRequest)request));
    }

    @Test
    public void testVerifyRequestSignatureInBody() throws Exception {
        this.expectTokenEntry();
        this.expectConsumer();
        this.replay();
        FakeHttpServletRequest request = this.formEncodedPost.sign(TOKEN, FakeOAuthRequest.OAuthParamLocation.POST_BODY, FakeOAuthRequest.BodySigning.NONE);
        SecurityToken token = this.reqHandler.getSecurityTokenFromRequest((HttpServletRequest)request);
        OAuthAuthenticationHanderTest.assertNotNull((Object)token);
        this.verify();
    }

    @Test
    public void testVerifyFailNoTokenEntry() throws Exception {
        this.expectTokenEntry(null);
        this.expectConsumer();
        this.replay();
        FakeHttpServletRequest request = this.formEncodedPost.sign(TOKEN, FakeOAuthRequest.OAuthParamLocation.URI_QUERY, FakeOAuthRequest.BodySigning.NONE);
        try {
            this.reqHandler.getSecurityTokenFromRequest((HttpServletRequest)request);
            OAuthAuthenticationHanderTest.fail((String)"Expect failure as no token entry in store");
        }
        catch (AuthenticationHandler.InvalidAuthenticationException invalidAuthenticationException) {
            // empty catch block
        }
        this.verify();
    }

    @Test
    public void testVerifyFailTokenSecretMismatch() throws Exception {
        OAuthEntry authEntry = this.createOAuthEntry();
        authEntry.setTokenSecret("badsecret");
        this.expectTokenEntry(authEntry);
        this.expectConsumer();
        this.replay();
        FakeHttpServletRequest request = this.formEncodedPost.sign(TOKEN, FakeOAuthRequest.OAuthParamLocation.URI_QUERY, FakeOAuthRequest.BodySigning.NONE);
        try {
            this.reqHandler.getSecurityTokenFromRequest((HttpServletRequest)request);
            OAuthAuthenticationHanderTest.fail((String)"Expect failure as token secrets mismatch");
        }
        catch (AuthenticationHandler.InvalidAuthenticationException invalidAuthenticationException) {
            // empty catch block
        }
        this.verify();
    }

    @Test
    public void testVerifyFailTokenIsRequest() throws Exception {
        OAuthEntry authEntry = this.createOAuthEntry();
        authEntry.setType(OAuthEntry.Type.REQUEST);
        this.expectTokenEntry(authEntry);
        this.expectConsumer();
        this.replay();
        FakeHttpServletRequest request = this.formEncodedPost.sign(TOKEN, FakeOAuthRequest.OAuthParamLocation.URI_QUERY, FakeOAuthRequest.BodySigning.NONE);
        try {
            this.reqHandler.getSecurityTokenFromRequest((HttpServletRequest)request);
            OAuthAuthenticationHanderTest.fail((String)"Expect failure as token is a request token not an access token");
        }
        catch (AuthenticationHandler.InvalidAuthenticationException invalidAuthenticationException) {
            // empty catch block
        }
        this.verify();
    }

    @Test
    public void testVerifyFailTokenIsExpired() throws Exception {
        OAuthEntry authEntry = this.createOAuthEntry();
        authEntry.setIssueTime(new Date(System.currentTimeMillis() - 31536000001L));
        authEntry.setType(OAuthEntry.Type.REQUEST);
        this.expectTokenEntry(authEntry);
        this.expectConsumer();
        this.replay();
        FakeHttpServletRequest request = this.formEncodedPost.sign(TOKEN, FakeOAuthRequest.OAuthParamLocation.URI_QUERY, FakeOAuthRequest.BodySigning.NONE);
        try {
            this.reqHandler.getSecurityTokenFromRequest((HttpServletRequest)request);
            OAuthAuthenticationHanderTest.fail((String)"Expect failure as token is expired");
        }
        catch (AuthenticationHandler.InvalidAuthenticationException invalidAuthenticationException) {
            // empty catch block
        }
        this.verify();
    }

    @Test
    public void testVerifyConsumerRequest() throws Exception {
        this.expectConsumer();
        this.expectSecurityToken();
        this.replay();
        FakeHttpServletRequest request = this.formEncodedPost.sign(null, FakeOAuthRequest.OAuthParamLocation.URI_QUERY, FakeOAuthRequest.BodySigning.NONE);
        SecurityToken token = this.reqHandler.getSecurityTokenFromRequest((HttpServletRequest)request);
        OAuthAuthenticationHanderTest.assertNotNull((Object)token);
        OAuthAuthenticationHanderTest.assertFalse((boolean)(token instanceof OAuthSecurityToken));
        this.verify();
    }

    @Test
    public void testVerifyConsumerGet() throws Exception {
        this.expectConsumer();
        this.expectSecurityToken();
        this.replay();
        FakeOAuthRequest get = new FakeOAuthRequest("GET", TEST_URL, null, null);
        FakeHttpServletRequest request = get.sign(null, FakeOAuthRequest.OAuthParamLocation.URI_QUERY, FakeOAuthRequest.BodySigning.NONE);
        OAuthAuthenticationHanderTest.assertNotNull((Object)this.reqHandler.getSecurityTokenFromRequest((HttpServletRequest)request));
    }

    @Test
    public void testVerifyConsumerGetSignatureInHeader() throws Exception {
        this.expectConsumer();
        this.expectSecurityToken();
        this.replay();
        FakeOAuthRequest get = new FakeOAuthRequest("GET", TEST_URL, null, null);
        FakeHttpServletRequest request = get.sign(null, FakeOAuthRequest.OAuthParamLocation.AUTH_HEADER, FakeOAuthRequest.BodySigning.NONE);
        OAuthAuthenticationHanderTest.assertNotNull((Object)this.reqHandler.getSecurityTokenFromRequest((HttpServletRequest)request));
    }

    @Test
    public void testVerifyConsumerRequestSignatureInAuthHeader() throws Exception {
        this.expectConsumer();
        this.expectSecurityToken();
        this.replay();
        FakeHttpServletRequest request = this.formEncodedPost.sign(null, FakeOAuthRequest.OAuthParamLocation.AUTH_HEADER, FakeOAuthRequest.BodySigning.NONE);
        this.reqHandler.getSecurityTokenFromRequest((HttpServletRequest)request);
        this.verify();
    }

    @Test
    public void testVerifyConsumerRequestSignatureInBody() throws Exception {
        this.expectConsumer();
        this.expectSecurityToken();
        this.replay();
        FakeHttpServletRequest request = this.formEncodedPost.sign(null, FakeOAuthRequest.OAuthParamLocation.POST_BODY, FakeOAuthRequest.BodySigning.NONE);
        this.reqHandler.getSecurityTokenFromRequest((HttpServletRequest)request);
        this.verify();
    }

    @Test
    public void testNoSignature() throws Exception {
        this.replay();
        FakeHttpServletRequest request = this.formEncodedPost.sign(null, FakeOAuthRequest.OAuthParamLocation.URI_QUERY, FakeOAuthRequest.BodySigning.NONE);
        request.setParameter("oauth_signature", new String[]{""});
        SecurityToken st = this.reqHandler.getSecurityTokenFromRequest((HttpServletRequest)request);
        OAuthAuthenticationHanderTest.assertNull((Object)st);
    }

    @Test
    public void testBodyHashSigning() throws Exception {
        this.expectConsumer();
        this.expectSecurityToken();
        this.replay();
        FakeHttpServletRequest request = this.nonFormEncodedPost.sign(null, FakeOAuthRequest.OAuthParamLocation.URI_QUERY, FakeOAuthRequest.BodySigning.HASH);
        OAuthAuthenticationHanderTest.assertNotNull((Object)this.reqHandler.getSecurityTokenFromRequest((HttpServletRequest)request));
    }

    @Test
    public void testConsumerFailBodyHashSigningWithFormEncoding() throws Exception {
        this.replay();
        FakeOAuthRequest bodyHashPost = new FakeOAuthRequest("POST", TEST_URL, "a=b&c=d&oauth_body_hash=hash", "application/x-www-form-urlencoded");
        FakeHttpServletRequest request = bodyHashPost.sign(null, FakeOAuthRequest.OAuthParamLocation.URI_QUERY, FakeOAuthRequest.BodySigning.NONE);
        try {
            this.reqHandler.getSecurityTokenFromRequest((HttpServletRequest)request);
            OAuthAuthenticationHanderTest.fail((String)"Cant have body signing with form-encoded post bodies");
        }
        catch (AuthenticationHandler.InvalidAuthenticationException invalidAuthenticationException) {
            // empty catch block
        }
    }

    @Test
    public void testStashBody() throws Exception {
        FakeHttpServletRequest req = new FakeHttpServletRequest();
        String body = "BODY";
        req.setPostData(CharsetUtil.getUtf8Bytes((String)body));
        byte[] bytes = OAuthAuthenticationHandler.readBody((HttpServletRequest)req);
        OAuthAuthenticationHanderTest.assertTrue((boolean)Arrays.equals(bytes, CharsetUtil.getUtf8Bytes((String)body)));
        OAuthAuthenticationHanderTest.assertEquals((Object)req.getAttribute("STASHED_BODY"), (Object)bytes);
    }

    @Test
    public void testBodySigning() throws Exception {
        FakeHttpServletRequest req = new FakeHttpServletRequest();
        req.setContentType("text/plain");
        String body = "BODY";
        req.setPostData(CharsetUtil.getUtf8Bytes((String)body));
        String hash = new String(Base64.encodeBase64((byte[])DigestUtils.sha((byte[])CharsetUtil.getUtf8Bytes((String)body))), "UTF-8");
        req.setParameter("oauth_body_hash", new String[]{hash});
        OAuthAuthenticationHandler.verifyBodyHash((HttpServletRequest)req, (String)hash);
    }

    @Test
    public void testFailBodySigning() throws Exception {
        FakeHttpServletRequest req = new FakeHttpServletRequest();
        req.setContentType("text/plain");
        String body = "BODY";
        req.setPostData(CharsetUtil.getUtf8Bytes((String)body));
        String hash = new String(Base64.encodeBase64((byte[])DigestUtils.sha((byte[])CharsetUtil.getUtf8Bytes((String)"NOTBODY"))), "UTF-8");
        req.setParameter("oauth_body_hash", new String[]{hash});
        try {
            OAuthAuthenticationHandler.verifyBodyHash((HttpServletRequest)req, (String)hash);
            OAuthAuthenticationHanderTest.fail((String)"Body verification should fail");
        }
        catch (AuthenticationHandler.InvalidAuthenticationException iae) {
            // empty catch block
        }
    }

    @Test
    public void testFailBodySigningWithFormEncoded() throws Exception {
        FakeHttpServletRequest req = new FakeHttpServletRequest();
        req.setContentType("application/x-www-form-urlencoded");
        String body = "BODY";
        req.setPostData(CharsetUtil.getUtf8Bytes((String)body));
        String hash = new String(Base64.encodeBase64((byte[])DigestUtils.sha((byte[])CharsetUtil.getUtf8Bytes((String)body))), "UTF-8");
        req.setParameter("oauth_body_hash", new String[]{hash});
        try {
            OAuthAuthenticationHandler.verifyBodyHash((HttpServletRequest)req, (String)hash);
            OAuthAuthenticationHanderTest.fail((String)"Body verification should fail");
        }
        catch (AuthenticationHandler.InvalidAuthenticationException iae) {
            // empty catch block
        }
    }

    @Test
    public void testBodyHashNoContentType() throws Exception {
        FakeHttpServletRequest req = new FakeHttpServletRequest();
        req.setPostData(CharsetUtil.getUtf8Bytes((String)""));
        String hash = new String(Base64.encodeBase64((byte[])DigestUtils.sha((byte[])CharsetUtil.getUtf8Bytes((String)""))), "UTF-8");
        OAuthAuthenticationHandler.verifyBodyHash((HttpServletRequest)req, (String)hash);
    }
}

