/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.oauth;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLEncoder;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.common.testing.FakeHttpServletRequest;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.social.core.oauth.MockServletOutputStream;
import org.apache.shindig.social.core.oauth2.OAuth2Servlet;
import org.apache.shindig.social.dataservice.integration.AbstractLargeRestfulTests;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.json.JSONObject;
import org.junit.Before;
import org.junit.Test;

public class OAuth2ImplicitFlowTest
extends AbstractLargeRestfulTests {
    protected OAuth2Servlet servlet = null;
    public static final String IMPLICIT_CLIENT_ID = "advancedImplicitClient";
    protected static final String REDIRECT_URI = "http://localhost:8080/oauthclients/ImplicitClientHelper.html";

    @Override
    @Before
    public void abstractLargeRestfulBefore() throws Exception {
        super.abstractLargeRestfulBefore();
        this.servlet = new OAuth2Servlet();
        this.injector.injectMembers((Object)this.servlet);
    }

    @Test
    public void testGetAccessTokenWithRedirectParamAndState() throws Exception {
        FakeHttpServletRequest req = new FakeHttpServletRequest("http://localhost:8080/oauth2");
        req.setContentType("application/x-www-form-urlencoded");
        req.setPostData("client_id=advancedImplicitClient&response_type=token&state=PRESERVEME&redirect_uri=" + URLEncoder.encode(REDIRECT_URI, "UTF-8"), "UTF-8");
        req.setMethod("GET");
        req.setServletPath("/oauth2");
        req.setPathInfo("/authorize");
        HttpServletResponse resp = (HttpServletResponse)this.mock(HttpServletResponse.class);
        Capture redirectURI = new Capture();
        resp.setHeader((String)EasyMock.eq((Object)"Location"), (String)EasyMock.capture((Capture)redirectURI));
        resp.setStatus(302);
        MockServletOutputStream outputStream = new MockServletOutputStream();
        EasyMock.expect((Object)resp.getOutputStream()).andReturn((Object)outputStream).anyTimes();
        PrintWriter writer = new PrintWriter((OutputStream)((Object)outputStream));
        EasyMock.expect((Object)resp.getWriter()).andReturn((Object)writer).anyTimes();
        this.replay();
        this.servlet.service((ServletRequest)req, (ServletResponse)resp);
        writer.flush();
        String fragment = UriBuilder.parse((String)((String)redirectURI.getValue())).getFragment();
        OAuth2ImplicitFlowTest.assertTrue((boolean)((String)redirectURI.getValue()).startsWith(REDIRECT_URI));
        OAuth2ImplicitFlowTest.assertTrue((boolean)fragment.contains("token_type=bearer"));
        OAuth2ImplicitFlowTest.assertTrue((boolean)fragment.contains("access_token="));
        OAuth2ImplicitFlowTest.assertTrue((boolean)fragment.contains("expires_in="));
        OAuth2ImplicitFlowTest.assertTrue((boolean)fragment.contains("state=PRESERVEME"));
        this.verify();
    }

    @Test
    public void testGetAccessTokenNoRedirectParam() throws Exception {
        FakeHttpServletRequest req = new FakeHttpServletRequest("http://localhost:8080/oauth2");
        req.setContentType("application/x-www-form-urlencoded");
        req.setPostData("client_id=advancedImplicitClient&response_type=token", "UTF-8");
        req.setMethod("GET");
        req.setServletPath("/oauth2");
        req.setPathInfo("/authorize");
        HttpServletResponse resp = (HttpServletResponse)this.mock(HttpServletResponse.class);
        Capture redirectURI = new Capture();
        resp.setHeader((String)EasyMock.eq((Object)"Location"), (String)EasyMock.capture((Capture)redirectURI));
        resp.setStatus(302);
        MockServletOutputStream outputStream = new MockServletOutputStream();
        EasyMock.expect((Object)resp.getOutputStream()).andReturn((Object)outputStream).anyTimes();
        PrintWriter writer = new PrintWriter((OutputStream)((Object)outputStream));
        EasyMock.expect((Object)resp.getWriter()).andReturn((Object)writer).anyTimes();
        this.replay();
        this.servlet.service((ServletRequest)req, (ServletResponse)resp);
        writer.flush();
        String fragment = UriBuilder.parse((String)((String)redirectURI.getValue())).getFragment();
        OAuth2ImplicitFlowTest.assertTrue((boolean)((String)redirectURI.getValue()).startsWith(REDIRECT_URI));
        OAuth2ImplicitFlowTest.assertTrue((boolean)fragment.contains("token_type=bearer"));
        OAuth2ImplicitFlowTest.assertTrue((boolean)fragment.contains("access_token="));
        OAuth2ImplicitFlowTest.assertTrue((boolean)fragment.contains("expires_in="));
        this.verify();
    }

    @Test
    public void testGetAccessTokenWithBadRedirect() throws Exception {
        FakeHttpServletRequest req = new FakeHttpServletRequest("http://localhost:8080/oauth2");
        req.setContentType("application/x-www-form-urlencoded");
        req.setPostData("client_id=advancedImplicitClient&response_type=token&redirect_uri=" + URLEncoder.encode("BAD_REDIRECT", "UTF-8"), "UTF-8");
        req.setMethod("GET");
        req.setServletPath("/oauth2");
        req.setPathInfo("/authorize");
        HttpServletResponse resp = (HttpServletResponse)this.mock(HttpServletResponse.class);
        resp.setStatus(EasyMock.eq((int)403));
        MockServletOutputStream outputStream = new MockServletOutputStream();
        EasyMock.expect((Object)resp.getOutputStream()).andReturn((Object)outputStream).anyTimes();
        PrintWriter writer = new PrintWriter((OutputStream)((Object)outputStream));
        EasyMock.expect((Object)resp.getWriter()).andReturn((Object)writer).anyTimes();
        this.replay();
        this.servlet.service((ServletRequest)req, (ServletResponse)resp);
        writer.flush();
        this.verify();
        String response = new String(outputStream.getBuffer(), "UTF-8");
        JSONObject respObj = new JSONObject(response);
        OAuth2ImplicitFlowTest.assertTrue((boolean)respObj.has("error"));
    }

    @Test
    public void testGetAccessTokenWithBadClientID() throws Exception {
        FakeHttpServletRequest req = new FakeHttpServletRequest("http://localhost:8080/oauth2");
        req.setContentType("application/x-www-form-urlencoded");
        req.setPostData("client_id=BAD-ID&response_type=token&redirect_uri=" + URLEncoder.encode(REDIRECT_URI, "UTF-8"), "UTF-8");
        req.setMethod("GET");
        req.setServletPath("/oauth2");
        req.setPathInfo("/authorize");
        HttpServletResponse resp = (HttpServletResponse)this.mock(HttpServletResponse.class);
        resp.setStatus(EasyMock.eq((int)403));
        MockServletOutputStream outputStream = new MockServletOutputStream();
        EasyMock.expect((Object)resp.getOutputStream()).andReturn((Object)outputStream).anyTimes();
        PrintWriter writer = new PrintWriter((OutputStream)((Object)outputStream));
        EasyMock.expect((Object)resp.getWriter()).andReturn((Object)writer).anyTimes();
        this.replay();
        this.servlet.service((ServletRequest)req, (ServletResponse)resp);
        writer.flush();
        this.verify();
        String response = new String(outputStream.getBuffer(), "UTF-8");
        JSONObject respObj = new JSONObject(response);
        OAuth2ImplicitFlowTest.assertTrue((boolean)respObj.has("error"));
    }
}

