/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.oauth;

import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.shindig.common.testing.FakeHttpServletRequest;
import org.apache.shindig.social.core.oauth.MockServletOutputStream;
import org.apache.shindig.social.core.oauth2.OAuth2Servlet;
import org.apache.shindig.social.dataservice.integration.AbstractLargeRestfulTests;
import org.easymock.EasyMock;
import org.json.JSONObject;
import org.junit.Before;
import org.junit.Test;

public class OAuth2ClientCredentialFlowTest
extends AbstractLargeRestfulTests {
    protected static final String CLIENT_CRED_CLIENT = "testClientCredentialsClient";
    protected static final String CLIENT_CRED_SECRET = "clientCredentialsClient_secret";
    protected OAuth2Servlet servlet = null;

    @Override
    @Before
    public void abstractLargeRestfulBefore() throws Exception {
        super.abstractLargeRestfulBefore();
        this.servlet = new OAuth2Servlet();
        this.injector.injectMembers((Object)this.servlet);
    }

    @Test
    public void testClientCredFlowBadHeader() throws Exception {
        FakeHttpServletRequest req = new FakeHttpServletRequest("http://localhost:8080", "/oauth2", "grant_type=client_credentials");
        req.setHeader("Authorization", "Basic *^%#");
        req.setMethod("GET");
        req.setServletPath("/oauth2");
        req.setPathInfo("/access_token");
        HttpServletResponse resp = (HttpServletResponse)this.mock(HttpServletResponse.class);
        resp.setStatus(EasyMock.eq((int)400));
        MockServletOutputStream outputStream = new MockServletOutputStream();
        EasyMock.expect((Object)resp.getOutputStream()).andReturn((Object)outputStream).anyTimes();
        PrintWriter writer = new PrintWriter((OutputStream)((Object)outputStream));
        EasyMock.expect((Object)resp.getWriter()).andReturn((Object)writer).anyTimes();
        this.replay();
        this.servlet.service((ServletRequest)req, (ServletResponse)resp);
        writer.flush();
        String response = new String(outputStream.getBuffer(), "UTF-8");
        JSONObject respObj = new JSONObject(response);
        OAuth2ClientCredentialFlowTest.assertTrue((boolean)respObj.has("error"));
        this.verify();
    }

    @Test
    public void testClientCredFlowBadPass() throws Exception {
        FakeHttpServletRequest req = new FakeHttpServletRequest("http://localhost:8080", "/oauth2", "grant_type=client_credentials");
        req.setHeader("Authorization", "Basic " + Base64.encodeBase64String((byte[])"testClientCredentialsClient:badsecret".getBytes("UTF-8")));
        req.setMethod("GET");
        req.setServletPath("/oauth2");
        req.setPathInfo("/access_token");
        HttpServletResponse resp = (HttpServletResponse)this.mock(HttpServletResponse.class);
        resp.setStatus(EasyMock.eq((int)400));
        MockServletOutputStream outputStream = new MockServletOutputStream();
        EasyMock.expect((Object)resp.getOutputStream()).andReturn((Object)outputStream).anyTimes();
        PrintWriter writer = new PrintWriter((OutputStream)((Object)outputStream));
        EasyMock.expect((Object)resp.getWriter()).andReturn((Object)writer).anyTimes();
        this.replay();
        this.servlet.service((ServletRequest)req, (ServletResponse)resp);
        writer.flush();
        String response = new String(outputStream.getBuffer(), "UTF-8");
        JSONObject respObj = new JSONObject(response);
        OAuth2ClientCredentialFlowTest.assertTrue((boolean)respObj.has("error"));
        this.verify();
    }

    @Test
    public void testClientCredFlowBasicAuth() throws Exception {
        FakeHttpServletRequest req = new FakeHttpServletRequest("http://localhost:8080", "/oauth2", "grant_type=client_credentials");
        req.setHeader("Authorization", "Basic " + Base64.encodeBase64String((byte[])"testClientCredentialsClient:clientCredentialsClient_secret".getBytes("UTF-8")));
        req.setMethod("GET");
        req.setServletPath("/oauth2");
        req.setPathInfo("/access_token");
        HttpServletResponse resp = (HttpServletResponse)this.mock(HttpServletResponse.class);
        resp.setStatus(200);
        MockServletOutputStream outputStream = new MockServletOutputStream();
        EasyMock.expect((Object)resp.getOutputStream()).andReturn((Object)outputStream).anyTimes();
        PrintWriter writer = new PrintWriter((OutputStream)((Object)outputStream));
        EasyMock.expect((Object)resp.getWriter()).andReturn((Object)writer).anyTimes();
        this.replay();
        this.servlet.service((ServletRequest)req, (ServletResponse)resp);
        writer.flush();
        JSONObject tokenResponse = new JSONObject(new String(outputStream.getBuffer(), "UTF-8"));
        OAuth2ClientCredentialFlowTest.assertEquals((Object)"bearer", (Object)tokenResponse.getString("token_type"));
        OAuth2ClientCredentialFlowTest.assertNotNull((Object)tokenResponse.getString("access_token"));
        OAuth2ClientCredentialFlowTest.assertTrue((tokenResponse.getLong("expires_in") > 0L ? 1 : 0) != 0);
        this.verify();
    }

    @Test
    public void testClientCredFlowParams() throws Exception {
        FakeHttpServletRequest req = new FakeHttpServletRequest("http://localhost:8080", "/oauth2", "client_id=testClientCredentialsClient&grant_type=client_credentials&client_secret=clientCredentialsClient_secret");
        req.setMethod("GET");
        req.setServletPath("/oauth2");
        req.setPathInfo("/access_token");
        HttpServletResponse resp = (HttpServletResponse)this.mock(HttpServletResponse.class);
        resp.setStatus(200);
        MockServletOutputStream outputStream = new MockServletOutputStream();
        EasyMock.expect((Object)resp.getOutputStream()).andReturn((Object)outputStream).anyTimes();
        PrintWriter writer = new PrintWriter((OutputStream)((Object)outputStream));
        EasyMock.expect((Object)resp.getWriter()).andReturn((Object)writer).anyTimes();
        this.replay();
        this.servlet.service((ServletRequest)req, (ServletResponse)resp);
        writer.flush();
        JSONObject tokenResponse = new JSONObject(new String(outputStream.getBuffer(), "UTF-8"));
        OAuth2ClientCredentialFlowTest.assertEquals((Object)"bearer", (Object)tokenResponse.getString("token_type"));
        OAuth2ClientCredentialFlowTest.assertNotNull((Object)tokenResponse.getString("access_token"));
        OAuth2ClientCredentialFlowTest.assertTrue((tokenResponse.getLong("expires_in") > 0L ? 1 : 0) != 0);
        this.verify();
    }
}

