/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.oauth;

import com.google.inject.Guice;
import com.google.inject.Module;
import javax.servlet.http.HttpServletRequest;
import org.apache.shindig.auth.AuthenticationHandler;
import org.apache.shindig.common.EasyMockTestCase;
import org.apache.shindig.common.testing.FakeHttpServletRequest;
import org.apache.shindig.social.SocialApiTestsGuiceModule;
import org.apache.shindig.social.core.oauth2.OAuth2AuthenticationHandler;
import org.junit.Before;
import org.junit.Test;

public class OAuth2AuthenticationHandlerTest
extends EasyMockTestCase {
    private final String ACCESS_TOKEN = "testClient_accesstoken_1";
    protected OAuth2AuthenticationHandler handler = null;

    @Before
    public void setUp() {
        this.handler = (OAuth2AuthenticationHandler)Guice.createInjector((Module[])new Module[]{new SocialApiTestsGuiceModule()}).getInstance(OAuth2AuthenticationHandler.class);
    }

    @Test
    public void testValidAccessTokenViaURL() throws AuthenticationHandler.InvalidAuthenticationException {
        this.replay();
        this.handler.getSecurityTokenFromRequest((HttpServletRequest)new FakeHttpServletRequest("http://localhost:8080/oauth2", "/some_protected_uri", "access_token=testClient_accesstoken_1"));
    }

    @Test
    public void testInvalidAccessTokenViaURL() {
        this.replay();
        try {
            this.handler.getSecurityTokenFromRequest((HttpServletRequest)new FakeHttpServletRequest("http://localhost:8080/oauth2", "/some_protected_uri", "access_token=BADTOKEN"));
        }
        catch (AuthenticationHandler.InvalidAuthenticationException ex) {
            return;
        }
        OAuth2AuthenticationHandlerTest.fail((String)"Handler allowed invalid token without throwing exception");
    }

    @Test
    public void testValidAccessTokenViaHeader() throws AuthenticationHandler.InvalidAuthenticationException {
        this.replay();
        FakeHttpServletRequest req = new FakeHttpServletRequest("http://localhost:8080/oauth2", "/some_protected_uri", "");
        req.setHeader("Authorization", "Bearer testClient_accesstoken_1");
        this.handler.getSecurityTokenFromRequest((HttpServletRequest)req);
    }

    @Test
    public void testInvalidAccessTokenViaHeader() {
        this.replay();
        FakeHttpServletRequest req = new FakeHttpServletRequest("http://localhost:8080/oauth2", "/some_protected_uri", "");
        req.setHeader("Authorization", "Bearer BADVALUEK");
        try {
            this.handler.getSecurityTokenFromRequest((HttpServletRequest)req);
        }
        catch (AuthenticationHandler.InvalidAuthenticationException ex) {
            return;
        }
        OAuth2AuthenticationHandlerTest.fail((String)"Handler allowed invalid token without throwing exception");
    }
}

