/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.oauth;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URLEncoder;
import java.util.UUID;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.shindig.auth.AuthenticationHandler;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.testing.FakeHttpServletRequest;
import org.apache.shindig.social.core.oauth.MockServletOutputStream;
import org.apache.shindig.social.core.oauth2.OAuth2AuthenticationHandler;
import org.apache.shindig.social.core.oauth2.OAuth2Servlet;
import org.apache.shindig.social.dataservice.integration.AbstractLargeRestfulTests;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.json.JSONObject;
import org.junit.Before;
import org.junit.Test;

public class OAuth2AuthCodeFlowTest
extends AbstractLargeRestfulTests {
    protected static final String SIMPLE_ACCESS_TOKEN = "TEST_TOKEN";
    protected static final String PUBLIC_CLIENT_ID = "testClient";
    protected static final String PUBLIC_AUTH_CODE = "testClient_authcode_1";
    protected static final String CONF_CLIENT_ID = "advancedAuthorizationCodeClient";
    protected static final String CONF_CLIENT_SECRET = "advancedAuthorizationCodeClient_secret";
    protected static final String CONF_AUTH_CODE = "advancedClient_authcode_1";
    protected static final String PUBLIC_REDIRECT_URI = "http://localhost:8080/oauthclients/AuthorizationCodeClient";
    protected static final String REDIRECT_URI = "http://localhost:8080/oauthclients/AuthorizationCodeClient/friends";
    protected OAuth2Servlet servlet = null;

    @Override
    @Before
    public void abstractLargeRestfulBefore() throws Exception {
        super.abstractLargeRestfulBefore();
        this.servlet = new OAuth2Servlet();
        this.injector.injectMembers((Object)this.servlet);
    }

    @Test
    public void testGetAccessToken() throws Exception {
        FakeHttpServletRequest req = new FakeHttpServletRequest("http://localhost:8080/oauth2");
        req.setContentType("application/x-www-form-urlencoded");
        req.setPostData("client_id=testClient&grant_type=authorization_code&redirect_uri=" + URLEncoder.encode(PUBLIC_REDIRECT_URI, "UTF-8") + "&code=" + PUBLIC_AUTH_CODE, "UTF-8");
        req.setMethod("GET");
        req.setServletPath("/oauth2");
        req.setPathInfo("/access_token");
        HttpServletResponse resp = (HttpServletResponse)this.mock(HttpServletResponse.class);
        resp.setStatus(200);
        MockServletOutputStream outputStream = new MockServletOutputStream();
        EasyMock.expect((Object)resp.getOutputStream()).andReturn((Object)outputStream).anyTimes();
        PrintWriter writer = new PrintWriter((OutputStream)((Object)outputStream));
        EasyMock.expect((Object)resp.getWriter()).andReturn((Object)writer).anyTimes();
        this.replay();
        this.servlet.service((ServletRequest)req, (ServletResponse)resp);
        writer.flush();
        JSONObject tokenResponse = new JSONObject(new String(outputStream.getBuffer(), "UTF-8"));
        OAuth2AuthCodeFlowTest.assertEquals((Object)"bearer", (Object)tokenResponse.getString("token_type"));
        OAuth2AuthCodeFlowTest.assertNotNull((Object)tokenResponse.getString("access_token"));
        OAuth2AuthCodeFlowTest.assertTrue((tokenResponse.getLong("expires_in") > 0L ? 1 : 0) != 0);
        this.verify();
    }

    @Test
    public void testGetAuthorizationCode() throws Exception {
        FakeHttpServletRequest req = new FakeHttpServletRequest("http://localhost:8080/oauth2");
        req.setContentType("application/x-www-form-urlencoded");
        req.setPostData("client_id=testClient&response_type=code&redirect_uri=" + URLEncoder.encode(PUBLIC_REDIRECT_URI, "UTF-8"), "UTF-8");
        req.setMethod("GET");
        req.setServletPath("/oauth2");
        req.setPathInfo("/authorize");
        HttpServletResponse resp = (HttpServletResponse)this.mock(HttpServletResponse.class);
        Capture redirectURI = new Capture();
        resp.setHeader((String)EasyMock.eq((Object)"Location"), (String)EasyMock.capture((Capture)redirectURI));
        resp.setStatus(EasyMock.eq((int)302));
        MockServletOutputStream outputStream = new MockServletOutputStream();
        EasyMock.expect((Object)resp.getOutputStream()).andReturn((Object)outputStream).anyTimes();
        PrintWriter writer = new PrintWriter((OutputStream)((Object)outputStream));
        EasyMock.expect((Object)resp.getWriter()).andReturn((Object)writer).anyTimes();
        this.replay();
        this.servlet.service((ServletRequest)req, (ServletResponse)resp);
        writer.flush();
        String response = new String(outputStream.getBuffer(), "UTF-8");
        OAuth2AuthCodeFlowTest.assertTrue((response == null || response.equals("") ? 1 : 0) != 0);
        this.verify();
        OAuth2AuthCodeFlowTest.assertTrue((boolean)((String)redirectURI.getValue()).startsWith("http://localhost:8080/oauthclients/AuthorizationCodeClient?code="));
        String code = ((String)redirectURI.getValue()).substring(((String)redirectURI.getValue()).indexOf("=") + 1);
        UUID id = UUID.fromString(code);
        OAuth2AuthCodeFlowTest.assertTrue((id != null ? 1 : 0) != 0);
    }

    @Test
    public void testGetAuthorizationCodePreserveState() throws Exception {
        FakeHttpServletRequest req = new FakeHttpServletRequest("http://localhost:8080", "/oauth2", "client_id=testClient&response_type=code&state=PRESERVEME&redirect_uri=" + URLEncoder.encode(PUBLIC_REDIRECT_URI, "UTF-8"));
        req.setMethod("GET");
        req.setServletPath("/oauth2");
        req.setPathInfo("/authorize");
        HttpServletResponse resp = (HttpServletResponse)this.mock(HttpServletResponse.class);
        Capture redirectURI = new Capture();
        resp.setHeader((String)EasyMock.eq((Object)"Location"), (String)EasyMock.capture((Capture)redirectURI));
        resp.setStatus(EasyMock.eq((int)302));
        MockServletOutputStream outputStream = new MockServletOutputStream();
        EasyMock.expect((Object)resp.getOutputStream()).andReturn((Object)outputStream).anyTimes();
        PrintWriter writer = new PrintWriter((OutputStream)((Object)outputStream));
        EasyMock.expect((Object)resp.getWriter()).andReturn((Object)writer).anyTimes();
        this.replay();
        this.servlet.service((ServletRequest)req, (ServletResponse)resp);
        writer.flush();
        String response = new String(outputStream.getBuffer(), "UTF-8");
        OAuth2AuthCodeFlowTest.assertTrue((response == null || response.equals("") ? 1 : 0) != 0);
        this.verify();
        OAuth2AuthCodeFlowTest.assertTrue((boolean)((String)redirectURI.getValue()).startsWith(PUBLIC_REDIRECT_URI));
        URI uri = new URI((String)redirectURI.getValue());
        OAuth2AuthCodeFlowTest.assertTrue((boolean)uri.getQuery().contains("state=PRESERVEME"));
        OAuth2AuthCodeFlowTest.assertTrue((boolean)uri.getQuery().contains("code="));
    }

    @Test
    public void testGetAuthorizationCodeConfidential() throws Exception {
        FakeHttpServletRequest req = new FakeHttpServletRequest("http://localhost:8080", "/oauth2", "client_id=advancedAuthorizationCodeClient&response_type=code&client_secret=advancedAuthorizationCodeClient_secretredirect_uri=" + URLEncoder.encode(REDIRECT_URI, "UTF-8"));
        req.setMethod("GET");
        req.setServletPath("/oauth2");
        req.setPathInfo("/authorize");
        HttpServletResponse resp = (HttpServletResponse)this.mock(HttpServletResponse.class);
        Capture redirectURI = new Capture();
        resp.setHeader((String)EasyMock.eq((Object)"Location"), (String)EasyMock.capture((Capture)redirectURI));
        resp.setStatus(EasyMock.eq((int)302));
        MockServletOutputStream outputStream = new MockServletOutputStream();
        EasyMock.expect((Object)resp.getOutputStream()).andReturn((Object)outputStream).anyTimes();
        PrintWriter writer = new PrintWriter((OutputStream)((Object)outputStream));
        EasyMock.expect((Object)resp.getWriter()).andReturn((Object)writer).anyTimes();
        this.replay();
        this.servlet.service((ServletRequest)req, (ServletResponse)resp);
        writer.flush();
        String response = new String(outputStream.getBuffer(), "UTF-8");
        OAuth2AuthCodeFlowTest.assertTrue((response == null || response.equals("") ? 1 : 0) != 0);
        this.verify();
        OAuth2AuthCodeFlowTest.assertTrue((boolean)((String)redirectURI.getValue()).startsWith("http://localhost:8080/oauthclients/AuthorizationCodeClient/friends?code="));
        String code = ((String)redirectURI.getValue()).substring(((String)redirectURI.getValue()).indexOf("=") + 1);
        UUID id = UUID.fromString(code);
        OAuth2AuthCodeFlowTest.assertTrue((id != null ? 1 : 0) != 0);
    }

    @Test
    public void testGetAuthorizationCodeNoRedirect() throws Exception {
        FakeHttpServletRequest req = new FakeHttpServletRequest("http://localhost:8080", "/oauth2", "client_id=advancedAuthorizationCodeClient&response_type=code");
        req.setMethod("GET");
        req.setServletPath("/oauth2");
        req.setPathInfo("/authorize");
        HttpServletResponse resp = (HttpServletResponse)this.mock(HttpServletResponse.class);
        Capture redirectURI = new Capture();
        resp.setHeader((String)EasyMock.eq((Object)"Location"), (String)EasyMock.capture((Capture)redirectURI));
        Capture respCode = new Capture();
        resp.setStatus(EasyMock.capture((Capture)respCode));
        MockServletOutputStream outputStream = new MockServletOutputStream();
        EasyMock.expect((Object)resp.getOutputStream()).andReturn((Object)outputStream).anyTimes();
        PrintWriter writer = new PrintWriter((OutputStream)((Object)outputStream));
        EasyMock.expect((Object)resp.getWriter()).andReturn((Object)writer).anyTimes();
        this.replay();
        this.servlet.service((ServletRequest)req, (ServletResponse)resp);
        writer.flush();
        String response = new String(outputStream.getBuffer(), "UTF-8");
        OAuth2AuthCodeFlowTest.assertTrue((response == null || response.equals("") ? 1 : 0) != 0);
        this.verify();
        OAuth2AuthCodeFlowTest.assertEquals((Object)302, (Object)respCode.getValue());
        OAuth2AuthCodeFlowTest.assertTrue((boolean)((String)redirectURI.getValue()).startsWith("http://localhost:8080/oauthclients/AuthorizationCodeClient/friends?code="));
        String code = ((String)redirectURI.getValue()).substring(((String)redirectURI.getValue()).indexOf("=") + 1);
        UUID id = UUID.fromString(code);
        OAuth2AuthCodeFlowTest.assertTrue((id != null ? 1 : 0) != 0);
    }

    @Test
    public void testGetAuthorizationCodeBadRedirect() throws Exception {
        FakeHttpServletRequest req = new FakeHttpServletRequest("http://localhost:8080", "/oauth2", "client_id=advancedAuthorizationCodeClient&response_type=code&redirect_uri=" + URLEncoder.encode("http://example.org/redirect/", "UTF-8"));
        req.setMethod("GET");
        req.setServletPath("/oauth2");
        req.setPathInfo("/authorize");
        HttpServletResponse resp = (HttpServletResponse)this.mock(HttpServletResponse.class);
        resp.setStatus(403);
        MockServletOutputStream outputStream = new MockServletOutputStream();
        EasyMock.expect((Object)resp.getOutputStream()).andReturn((Object)outputStream).anyTimes();
        PrintWriter writer = new PrintWriter((OutputStream)((Object)outputStream));
        EasyMock.expect((Object)resp.getWriter()).andReturn((Object)writer).anyTimes();
        this.replay();
        this.servlet.service((ServletRequest)req, (ServletResponse)resp);
        writer.flush();
        JSONObject tokenResponse = new JSONObject(new String(outputStream.getBuffer(), "UTF-8"));
        OAuth2AuthCodeFlowTest.assertEquals((Object)"invalid_request", (Object)tokenResponse.getString("error"));
        this.verify();
    }

    @Test
    public void testConfidentialAuthCodeFlow() throws Exception {
        FakeHttpServletRequest req = new FakeHttpServletRequest("http://localhost:8080", "/oauth2", "client_id=advancedAuthorizationCodeClient&client_secret=advancedAuthorizationCodeClient_secret&response_type=code&redirect_uri=" + URLEncoder.encode(REDIRECT_URI, "UTF-8"));
        req.setMethod("GET");
        req.setServletPath("/oauth2");
        req.setPathInfo("/authorize");
        HttpServletResponse resp = (HttpServletResponse)this.mock(HttpServletResponse.class);
        Capture redirectURI = new Capture();
        resp.setHeader((String)EasyMock.eq((Object)"Location"), (String)EasyMock.capture((Capture)redirectURI));
        resp.setStatus(EasyMock.eq((int)302));
        MockServletOutputStream outputStream = new MockServletOutputStream();
        EasyMock.expect((Object)resp.getOutputStream()).andReturn((Object)outputStream).anyTimes();
        PrintWriter writer = new PrintWriter((OutputStream)((Object)outputStream));
        EasyMock.expect((Object)resp.getWriter()).andReturn((Object)writer).anyTimes();
        this.replay();
        this.servlet.service((ServletRequest)req, (ServletResponse)resp);
        writer.flush();
        String response = new String(outputStream.getBuffer(), "UTF-8");
        OAuth2AuthCodeFlowTest.assertTrue((response == null || response.equals("") ? 1 : 0) != 0);
        this.verify();
        OAuth2AuthCodeFlowTest.assertTrue((boolean)((String)redirectURI.getValue()).startsWith("http://localhost:8080/oauthclients/AuthorizationCodeClient/friends?code="));
        String code = ((String)redirectURI.getValue()).substring(((String)redirectURI.getValue()).indexOf("=") + 1);
        UUID id = UUID.fromString(code);
        OAuth2AuthCodeFlowTest.assertTrue((id != null ? 1 : 0) != 0);
        this.reset();
        req = new FakeHttpServletRequest("http://localhost:8080", "/oauth2", "client_id=advancedAuthorizationCodeClient&grant_type=authorization_code&redirect_uri=" + URLEncoder.encode(REDIRECT_URI, "UTF-8") + "&code=" + code + "&client_secret=" + CONF_CLIENT_SECRET);
        req.setMethod("GET");
        req.setServletPath("/oauth2");
        req.setPathInfo("/access_token");
        resp = (HttpServletResponse)this.mock(HttpServletResponse.class);
        resp.setStatus(200);
        outputStream = new MockServletOutputStream();
        EasyMock.expect((Object)resp.getOutputStream()).andReturn((Object)outputStream).anyTimes();
        writer = new PrintWriter((OutputStream)((Object)outputStream));
        EasyMock.expect((Object)resp.getWriter()).andReturn((Object)writer).anyTimes();
        this.replay();
        this.servlet.service((ServletRequest)req, (ServletResponse)resp);
        writer.flush();
        JSONObject tokenResponse = new JSONObject(new String(outputStream.getBuffer(), "UTF-8"));
        OAuth2AuthCodeFlowTest.assertEquals((Object)"bearer", (Object)tokenResponse.getString("token_type"));
        OAuth2AuthCodeFlowTest.assertNotNull((Object)tokenResponse.getString("access_token"));
        OAuth2AuthCodeFlowTest.assertTrue((tokenResponse.getLong("expires_in") > 0L ? 1 : 0) != 0);
        this.verify();
    }

    @Test
    public void testGetAccessTokenConfidentialClientParams() throws Exception {
        FakeHttpServletRequest req = new FakeHttpServletRequest("http://localhost:8080", "/oauth2", "client_id=advancedAuthorizationCodeClient&grant_type=authorization_code&redirect_uri=" + URLEncoder.encode(REDIRECT_URI, "UTF-8") + "&code=" + CONF_AUTH_CODE + "&client_secret=" + CONF_CLIENT_SECRET);
        req.setMethod("GET");
        req.setServletPath("/oauth2");
        req.setPathInfo("/access_token");
        HttpServletResponse resp = (HttpServletResponse)this.mock(HttpServletResponse.class);
        resp.setStatus(200);
        MockServletOutputStream outputStream = new MockServletOutputStream();
        EasyMock.expect((Object)resp.getOutputStream()).andReturn((Object)outputStream).anyTimes();
        PrintWriter writer = new PrintWriter((OutputStream)((Object)outputStream));
        EasyMock.expect((Object)resp.getWriter()).andReturn((Object)writer).anyTimes();
        this.replay();
        this.servlet.service((ServletRequest)req, (ServletResponse)resp);
        writer.flush();
        JSONObject tokenResponse = new JSONObject(new String(outputStream.getBuffer(), "UTF-8"));
        OAuth2AuthCodeFlowTest.assertEquals((Object)"bearer", (Object)tokenResponse.getString("token_type"));
        OAuth2AuthCodeFlowTest.assertNotNull((Object)tokenResponse.getString("access_token"));
        OAuth2AuthCodeFlowTest.assertTrue((tokenResponse.getLong("expires_in") > 0L ? 1 : 0) != 0);
        this.verify();
    }

    @Test
    public void testGetAccessTokenConfidentialClientBasicAuth() throws Exception {
        FakeHttpServletRequest req = new FakeHttpServletRequest("http://localhost:8080", "/oauth2", "client_id=advancedAuthorizationCodeClient&grant_type=authorization_code&redirect_uri=" + URLEncoder.encode(REDIRECT_URI, "UTF-8") + "&code=" + CONF_AUTH_CODE);
        req.setHeader("Authorization", "Basic " + Base64.encodeBase64String((byte[])"advancedAuthorizationCodeClient:advancedAuthorizationCodeClient_secret".getBytes("UTF-8")));
        req.setMethod("GET");
        req.setServletPath("/oauth2");
        req.setPathInfo("/access_token");
        HttpServletResponse resp = (HttpServletResponse)this.mock(HttpServletResponse.class);
        resp.setStatus(200);
        MockServletOutputStream outputStream = new MockServletOutputStream();
        EasyMock.expect((Object)resp.getOutputStream()).andReturn((Object)outputStream).anyTimes();
        PrintWriter writer = new PrintWriter((OutputStream)((Object)outputStream));
        EasyMock.expect((Object)resp.getWriter()).andReturn((Object)writer).anyTimes();
        this.replay();
        this.servlet.service((ServletRequest)req, (ServletResponse)resp);
        writer.flush();
        JSONObject tokenResponse = new JSONObject(new String(outputStream.getBuffer(), "UTF-8"));
        OAuth2AuthCodeFlowTest.assertEquals((Object)"bearer", (Object)tokenResponse.getString("token_type"));
        OAuth2AuthCodeFlowTest.assertNotNull((Object)tokenResponse.getString("access_token"));
        OAuth2AuthCodeFlowTest.assertTrue((tokenResponse.getLong("expires_in") > 0L ? 1 : 0) != 0);
        this.verify();
    }

    @Test
    public void testGetAccessTokenConfClientBasicAuthBadID() throws Exception {
        FakeHttpServletRequest req = new FakeHttpServletRequest("http://localhost:8080", "/oauth2", "client_id=advancedAuthorizationCodeClient&grant_type=authorization_code&redirect_uri=" + URLEncoder.encode(REDIRECT_URI, "UTF-8") + "&code=" + CONF_AUTH_CODE);
        req.setHeader("Authorization", "Basic " + Base64.encodeBase64String((byte[])"BAD_ID:advancedAuthorizationCodeClient_secret".getBytes("UTF-8")));
        req.setMethod("GET");
        req.setServletPath("/oauth2");
        req.setPathInfo("/access_token");
        HttpServletResponse resp = (HttpServletResponse)this.mock(HttpServletResponse.class);
        resp.setStatus(403);
        MockServletOutputStream outputStream = new MockServletOutputStream();
        EasyMock.expect((Object)resp.getOutputStream()).andReturn((Object)outputStream).anyTimes();
        PrintWriter writer = new PrintWriter((OutputStream)((Object)outputStream));
        EasyMock.expect((Object)resp.getWriter()).andReturn((Object)writer).anyTimes();
        this.replay();
        this.servlet.service((ServletRequest)req, (ServletResponse)resp);
        writer.flush();
        String response = new String(outputStream.getBuffer(), "UTF-8");
        OAuth2AuthCodeFlowTest.assertTrue((response == null || response.equals("") ? 1 : 0) != 0);
        this.verify();
    }

    @Test
    public void testGetAccessTokenBadConfidentialClientParams() throws Exception {
        FakeHttpServletRequest req = new FakeHttpServletRequest("http://localhost:8080/oauth2");
        req.setContentType("application/x-www-form-urlencoded");
        req.setPostData("client_id=advancedAuthorizationCodeClient&grant_type=authorization_code&redirect_uri=" + URLEncoder.encode(REDIRECT_URI, "UTF-8") + "&code=" + CONF_AUTH_CODE + "&client_secret=BAD_SECRET", "UTF-8");
        req.setMethod("GET");
        req.setServletPath("/oauth2");
        req.setPathInfo("/access_token");
        HttpServletResponse resp = (HttpServletResponse)this.mock(HttpServletResponse.class);
        resp.setStatus(400);
        MockServletOutputStream outputStream = new MockServletOutputStream();
        EasyMock.expect((Object)resp.getOutputStream()).andReturn((Object)outputStream).anyTimes();
        PrintWriter writer = new PrintWriter((OutputStream)((Object)outputStream));
        EasyMock.expect((Object)resp.getWriter()).andReturn((Object)writer).anyTimes();
        this.replay();
        this.servlet.service((ServletRequest)req, (ServletResponse)resp);
        writer.flush();
        JSONObject tokenResponse = new JSONObject(new String(outputStream.getBuffer(), "UTF-8"));
        OAuth2AuthCodeFlowTest.assertEquals((Object)"unauthorized_client", (Object)tokenResponse.getString("error"));
        this.verify();
    }

    @Test
    public void testGetAccessTokenBadClient() throws Exception {
        FakeHttpServletRequest req = new FakeHttpServletRequest("http://localhost:8080", "/oauth2", "client_id=BAD_CLIENT&grant_type=authorization_code&redirect_uri=" + URLEncoder.encode(REDIRECT_URI, "UTF-8") + "&code=" + PUBLIC_AUTH_CODE);
        req.setMethod("GET");
        req.setServletPath("/oauth2");
        req.setPathInfo("/access_token");
        HttpServletResponse resp = (HttpServletResponse)this.mock(HttpServletResponse.class);
        resp.setStatus(400);
        MockServletOutputStream outputStream = new MockServletOutputStream();
        EasyMock.expect((Object)resp.getOutputStream()).andReturn((Object)outputStream).anyTimes();
        PrintWriter writer = new PrintWriter((OutputStream)((Object)outputStream));
        EasyMock.expect((Object)resp.getWriter()).andReturn((Object)writer).anyTimes();
        this.replay();
        this.servlet.service((ServletRequest)req, (ServletResponse)resp);
        writer.flush();
        JSONObject tokenResponse = new JSONObject(new String(outputStream.getBuffer(), "UTF-8"));
        OAuth2AuthCodeFlowTest.assertEquals((Object)"invalid_client", (Object)tokenResponse.getString("error"));
        this.verify();
    }

    @Test
    public void testGetAccessTokenBadGrantType() throws Exception {
        FakeHttpServletRequest req = new FakeHttpServletRequest("http://localhost:8080", "/oauth2", "client_id=testClient&grant_type=BAD_GRANT&redirect_uri=" + URLEncoder.encode(REDIRECT_URI, "UTF-8") + "&code=" + PUBLIC_AUTH_CODE);
        req.setMethod("GET");
        req.setServletPath("/oauth2");
        req.setPathInfo("/access_token");
        HttpServletResponse resp = (HttpServletResponse)this.mock(HttpServletResponse.class);
        resp.setStatus(400);
        MockServletOutputStream outputStream = new MockServletOutputStream();
        EasyMock.expect((Object)resp.getOutputStream()).andReturn((Object)outputStream).anyTimes();
        PrintWriter writer = new PrintWriter((OutputStream)((Object)outputStream));
        EasyMock.expect((Object)resp.getWriter()).andReturn((Object)writer).anyTimes();
        this.replay();
        this.servlet.service((ServletRequest)req, (ServletResponse)resp);
        writer.flush();
        JSONObject tokenResponse = new JSONObject(new String(outputStream.getBuffer(), "UTF-8"));
        OAuth2AuthCodeFlowTest.assertEquals((Object)"unsupported_grant_type", (Object)tokenResponse.getString("error"));
        this.verify();
    }

    @Test
    public void testGetAccessTokenBadAuthCode() throws Exception {
        FakeHttpServletRequest req = new FakeHttpServletRequest("http://localhost:8080", "/oauth2", "client_id=testClient&grant_type=authorization_code&redirect_uri=" + URLEncoder.encode(REDIRECT_URI, "UTF-8") + "&code=BAD-CODE-OMG");
        req.setMethod("GET");
        req.setServletPath("/oauth2");
        req.setPathInfo("/access_token");
        HttpServletResponse resp = (HttpServletResponse)this.mock(HttpServletResponse.class);
        resp.setStatus(400);
        MockServletOutputStream outputStream = new MockServletOutputStream();
        EasyMock.expect((Object)resp.getOutputStream()).andReturn((Object)outputStream).anyTimes();
        PrintWriter writer = new PrintWriter((OutputStream)((Object)outputStream));
        EasyMock.expect((Object)resp.getWriter()).andReturn((Object)writer).anyTimes();
        this.replay();
        this.servlet.service((ServletRequest)req, (ServletResponse)resp);
        writer.flush();
        JSONObject tokenResponse = new JSONObject(new String(outputStream.getBuffer(), "UTF-8"));
        OAuth2AuthCodeFlowTest.assertEquals((Object)"invalid_grant", (Object)tokenResponse.getString("error"));
        this.verify();
    }

    @Test
    public void testReuseAuthorizationCode() throws Exception {
        FakeHttpServletRequest req = new FakeHttpServletRequest("http://localhost:8080", "/oauth2", "client_id=advancedAuthorizationCodeClient&client_secret=advancedAuthorizationCodeClient_secret&response_type=code&redirect_uri=" + URLEncoder.encode(REDIRECT_URI, "UTF-8"));
        req.setMethod("GET");
        req.setServletPath("/oauth2");
        req.setPathInfo("/authorize");
        HttpServletResponse resp = (HttpServletResponse)this.mock(HttpServletResponse.class);
        Capture redirectURI = new Capture();
        resp.setHeader((String)EasyMock.eq((Object)"Location"), (String)EasyMock.capture((Capture)redirectURI));
        resp.setStatus(EasyMock.eq((int)302));
        MockServletOutputStream outputStream = new MockServletOutputStream();
        EasyMock.expect((Object)resp.getOutputStream()).andReturn((Object)outputStream).anyTimes();
        PrintWriter writer = new PrintWriter((OutputStream)((Object)outputStream));
        EasyMock.expect((Object)resp.getWriter()).andReturn((Object)writer).anyTimes();
        this.replay();
        this.servlet.service((ServletRequest)req, (ServletResponse)resp);
        writer.flush();
        String response = new String(outputStream.getBuffer(), "UTF-8");
        OAuth2AuthCodeFlowTest.assertTrue((response == null || response.equals("") ? 1 : 0) != 0);
        this.verify();
        OAuth2AuthCodeFlowTest.assertTrue((boolean)((String)redirectURI.getValue()).startsWith("http://localhost:8080/oauthclients/AuthorizationCodeClient/friends?code="));
        String code = ((String)redirectURI.getValue()).substring(((String)redirectURI.getValue()).indexOf("=") + 1);
        UUID id = UUID.fromString(code);
        OAuth2AuthCodeFlowTest.assertTrue((id != null ? 1 : 0) != 0);
        System.out.println("Retrieved authorization code: " + code);
        this.reset();
        req = new FakeHttpServletRequest("http://localhost:8080", "/oauth2", "client_id=advancedAuthorizationCodeClient&grant_type=authorization_code&redirect_uri=" + URLEncoder.encode(REDIRECT_URI, "UTF-8") + "&code=" + code + "&client_secret=" + CONF_CLIENT_SECRET);
        req.setMethod("GET");
        req.setServletPath("/oauth2");
        req.setPathInfo("/access_token");
        resp = (HttpServletResponse)this.mock(HttpServletResponse.class);
        resp.setStatus(200);
        outputStream = new MockServletOutputStream();
        EasyMock.expect((Object)resp.getOutputStream()).andReturn((Object)outputStream).anyTimes();
        writer = new PrintWriter((OutputStream)((Object)outputStream));
        EasyMock.expect((Object)resp.getWriter()).andReturn((Object)writer).anyTimes();
        this.replay();
        this.servlet.service((ServletRequest)req, (ServletResponse)resp);
        writer.flush();
        JSONObject tokenResponse = new JSONObject(new String(outputStream.getBuffer(), "UTF-8"));
        OAuth2AuthCodeFlowTest.assertEquals((Object)"bearer", (Object)tokenResponse.getString("token_type"));
        OAuth2AuthCodeFlowTest.assertNotNull((Object)tokenResponse.getString("access_token"));
        OAuth2AuthCodeFlowTest.assertTrue((tokenResponse.getLong("expires_in") > 0L ? 1 : 0) != 0);
        this.verify();
        String accessToken = tokenResponse.getString("access_token");
        System.out.println("Retrieved access token: " + accessToken);
        this.reset();
        OAuth2AuthenticationHandler handler = (OAuth2AuthenticationHandler)this.injector.getInstance(OAuth2AuthenticationHandler.class);
        req = new FakeHttpServletRequest("http://localhost:8080", "/social/rest/activitystreams/john.doe/@self/1/object1", "access_token=" + accessToken);
        req.setMethod("GET");
        SecurityToken token = handler.getSecurityTokenFromRequest((HttpServletRequest)req);
        OAuth2AuthCodeFlowTest.assertNotNull((Object)token);
        this.reset();
        req = new FakeHttpServletRequest("http://localhost:8080", "/oauth2", "client_id=advancedAuthorizationCodeClient&grant_type=authorization_code&redirect_uri=" + URLEncoder.encode(REDIRECT_URI, "UTF-8") + "&code=" + code + "&client_secret=" + CONF_CLIENT_SECRET);
        req.setMethod("GET");
        req.setServletPath("/oauth2");
        req.setPathInfo("/access_token");
        resp = (HttpServletResponse)this.mock(HttpServletResponse.class);
        resp.setStatus(403);
        outputStream = new MockServletOutputStream();
        EasyMock.expect((Object)resp.getOutputStream()).andReturn((Object)outputStream).anyTimes();
        writer = new PrintWriter((OutputStream)((Object)outputStream));
        EasyMock.expect((Object)resp.getWriter()).andReturn((Object)writer).anyTimes();
        this.replay();
        this.servlet.service((ServletRequest)req, (ServletResponse)resp);
        writer.flush();
        tokenResponse = new JSONObject(new String(outputStream.getBuffer(), "UTF-8"));
        System.out.println("Rejection response: " + tokenResponse.toString());
        OAuth2AuthCodeFlowTest.assertEquals((Object)"invalid_grant", (Object)tokenResponse.getString("error"));
        this.verify();
        req = new FakeHttpServletRequest("http://localhost:8080", "/social/rest/activitystreams/john.doe/@self/1/object1", "access_token=" + accessToken);
        req.setMethod("GET");
        try {
            handler.getSecurityTokenFromRequest((HttpServletRequest)req);
        }
        catch (AuthenticationHandler.InvalidAuthenticationException ist) {
            return;
        }
        OAuth2AuthCodeFlowTest.fail((String)"Should have thrown InvalidAuthenticationException");
    }
}

