/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.config;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.util.List;
import org.apache.shindig.auth.AuthenticationHandler;
import org.apache.shindig.common.PropertiesModule;
import org.apache.shindig.social.core.config.SocialApiGuiceModule;
import org.apache.shindig.social.core.oauth.AuthenticationHandlerProvider;
import org.apache.shindig.social.core.oauth2.OAuth2Service;
import org.apache.shindig.social.core.oauth2.OAuth2ServiceImpl;
import org.apache.shindig.social.opensocial.oauth.OAuthDataStore;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SocialApiGuiceModuleTest
extends Assert {
    private Injector injector;

    @Before
    public void setUp() throws Exception {
        this.injector = Guice.createInjector((Module[])new Module[]{new SocialApiGuiceModule(), new PropertiesModule(), new AbstractModule(){

            protected void configure() {
                this.bind(OAuthDataStore.class).toInstance(EasyMock.createMock(OAuthDataStore.class));
                this.bind(OAuth2Service.class).toInstance(EasyMock.createMock(OAuth2ServiceImpl.class));
            }
        }});
    }

    @Test
    public void testAuthHandler() {
        ((AuthenticationHandlerProvider)this.injector.getInstance(AuthenticationHandlerProvider.class)).get();
        AuthenticationHandlerProvider provider = (AuthenticationHandlerProvider)this.injector.getInstance(AuthenticationHandlerProvider.class);
        SocialApiGuiceModuleTest.assertEquals((long)4L, (long)provider.get().size());
        List handlers = (List)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<List<AuthenticationHandler>>(){}));
        SocialApiGuiceModuleTest.assertEquals((long)4L, (long)handlers.size());
    }
}

