/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.sync.data.websocket;

import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.plugin.sync.data.websocket.client.ShenyuWebsocketClient;
import org.apache.shenyu.plugin.sync.data.websocket.config.WebsocketConfig;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.apache.shenyu.sync.data.api.DiscoveryUpstreamDataSubscriber;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.apache.shenyu.sync.data.api.ProxySelectorDataSubscriber;
import org.apache.shenyu.sync.data.api.SyncDataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketSyncDataService
implements SyncDataService {
    private static final Logger LOG = LoggerFactory.getLogger(WebsocketSyncDataService.class);
    private static final String ORIGIN_HEADER_NAME = "Origin";
    private final List<ShenyuWebsocketClient> clients = new ArrayList<ShenyuWebsocketClient>();

    public WebsocketSyncDataService(WebsocketConfig websocketConfig, PluginDataSubscriber pluginDataSubscriber, List<MetaDataSubscriber> metaDataSubscribers, List<AuthDataSubscriber> authDataSubscribers, List<ProxySelectorDataSubscriber> proxySelectorDataSubscribers, List<DiscoveryUpstreamDataSubscriber> discoveryUpstreamDataSubscribers) {
        String[] urls;
        for (String url : urls = StringUtils.split((String)websocketConfig.getUrls(), (String)",")) {
            try {
                if (StringUtils.isNotEmpty((CharSequence)websocketConfig.getAllowOrigin())) {
                    ImmutableMap headers = ImmutableMap.of((Object)ORIGIN_HEADER_NAME, (Object)websocketConfig.getAllowOrigin());
                    this.clients.add(new ShenyuWebsocketClient(new URI(url), (Map<String, String>)headers, Objects.requireNonNull(pluginDataSubscriber), metaDataSubscribers, authDataSubscribers, proxySelectorDataSubscribers, discoveryUpstreamDataSubscribers));
                    continue;
                }
                this.clients.add(new ShenyuWebsocketClient(new URI(url), Objects.requireNonNull(pluginDataSubscriber), metaDataSubscribers, authDataSubscribers, proxySelectorDataSubscribers, discoveryUpstreamDataSubscribers));
            }
            catch (URISyntaxException e) {
                LOG.error("websocket url({}) is error", (Object)url, (Object)e);
            }
        }
    }

    public void close() {
        for (ShenyuWebsocketClient client : this.clients) {
            client.nowClose();
        }
    }
}

