/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.sync.data.websocket.handler;

import java.util.EnumMap;
import java.util.List;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.plugin.sync.data.websocket.handler.AuthDataHandler;
import org.apache.shenyu.plugin.sync.data.websocket.handler.DataHandler;
import org.apache.shenyu.plugin.sync.data.websocket.handler.MetaDataHandler;
import org.apache.shenyu.plugin.sync.data.websocket.handler.PluginDataHandler;
import org.apache.shenyu.plugin.sync.data.websocket.handler.RuleDataHandler;
import org.apache.shenyu.plugin.sync.data.websocket.handler.SelectorDataHandler;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;

public class WebsocketDataHandler {
    private static final EnumMap<ConfigGroupEnum, DataHandler> ENUM_MAP = new EnumMap(ConfigGroupEnum.class);

    public WebsocketDataHandler(PluginDataSubscriber pluginDataSubscriber, List<MetaDataSubscriber> metaDataSubscribers, List<AuthDataSubscriber> authDataSubscribers) {
        ENUM_MAP.put(ConfigGroupEnum.PLUGIN, new PluginDataHandler(pluginDataSubscriber));
        ENUM_MAP.put(ConfigGroupEnum.SELECTOR, new SelectorDataHandler(pluginDataSubscriber));
        ENUM_MAP.put(ConfigGroupEnum.RULE, new RuleDataHandler(pluginDataSubscriber));
        ENUM_MAP.put(ConfigGroupEnum.APP_AUTH, new AuthDataHandler(authDataSubscribers));
        ENUM_MAP.put(ConfigGroupEnum.META_DATA, new MetaDataHandler(metaDataSubscribers));
    }

    public void executor(ConfigGroupEnum type, String json, String eventType) {
        ENUM_MAP.get(type).handle(json, eventType);
    }
}

