/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sync.data.http;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.shenyu.common.concurrent.ShenyuThreadFactory;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.sync.data.http.config.HttpConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class AccessTokenManager {
    public static final Logger LOG = LoggerFactory.getLogger(AccessTokenManager.class);
    private volatile String accessToken;
    private long tokenExpiredTime;
    private long lastRefreshTime;
    private long tokenRefreshWindow;
    private final RestTemplate restTemplate;
    private final HttpConfig httpConfig;
    private final ScheduledExecutorService executorService;

    public AccessTokenManager(RestTemplate restTemplate, HttpConfig httpConfig) {
        this.restTemplate = restTemplate;
        this.httpConfig = httpConfig;
        this.executorService = new ScheduledThreadPoolExecutor(1, ShenyuThreadFactory.create((String)"http-long-polling-client-token-refresh", (boolean)true));
        this.start(Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)httpConfig.getUrl())));
    }

    public void login(List<String> servers) {
        if (System.currentTimeMillis() - this.lastRefreshTime < this.tokenExpiredTime - this.tokenRefreshWindow) {
            return;
        }
        for (String server : servers) {
            if (!this.doLogin(server).booleanValue()) continue;
            this.lastRefreshTime = System.currentTimeMillis();
            return;
        }
    }

    private Boolean doLogin(String server) {
        String param = "userName=" + this.httpConfig.getUsername() + "&" + "password" + "=" + this.httpConfig.getPassword();
        String url = String.join((CharSequence)"?", server + "/platform/login", param);
        try {
            String result = (String)this.restTemplate.getForObject(url, String.class, new Object[0]);
            Map resultMap = GsonUtils.getInstance().convertToMap(result);
            if (!String.valueOf(200).equals(String.valueOf(resultMap.get("code")))) {
                LOG.warn(String.format("get token from server : [%s] error", server));
                return false;
            }
            String tokenJson = GsonUtils.getInstance().toJson(resultMap.get("data"));
            LOG.info("login success: {} ", (Object)tokenJson);
            Map tokenMap = GsonUtils.getInstance().convertToMap(tokenJson);
            this.accessToken = (String)tokenMap.get("token");
            this.tokenExpiredTime = (Long)tokenMap.get("expiredTime");
            this.tokenRefreshWindow = this.tokenExpiredTime / 10L;
            return true;
        }
        catch (RestClientException e) {
            LOG.error(String.format("get token from server : [%s] error", server), (Throwable)e);
            return false;
        }
    }

    private void start(List<String> servers) {
        this.login(servers);
        this.executorService.scheduleWithFixedDelay(() -> this.login(servers), 5000L, 5000L, TimeUnit.MILLISECONDS);
    }

    public String getAccessToken() {
        return this.accessToken;
    }
}

