/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.plugin.oauth2;

import java.util.Collections;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class DefaultClientsConfiguredCondition
extends SpringBootCondition {
    private static final Bindable<Map<String, OAuth2ClientProperties.Registration>> STRING_REGISTRATION_MAP = Bindable.mapOf(String.class, OAuth2ClientProperties.Registration.class);

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Map<String, OAuth2ClientProperties.Registration> registrations = this.getRegistrations(context.getEnvironment());
        return registrations.isEmpty() ? ConditionOutcome.match((String)"use default configuration") : ConditionOutcome.noMatch((String)"use user configuration");
    }

    private Map<String, OAuth2ClientProperties.Registration> getRegistrations(Environment environment) {
        return (Map)Binder.get((Environment)environment).bind("spring.security.oauth2.client.registration", STRING_REGISTRATION_MAP).orElse(Collections.emptyMap());
    }
}

